/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.query.internal;

import java.util.List;
import java.util.Map;
import javax.persistence.ParameterMode;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.boot.model.query.internal.AbstractNamedQueryDefinition;
import org.hibernate.boot.model.query.spi.NamedHqlQueryDefinition;
import org.hibernate.boot.model.query.spi.ParameterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.named.internal.NamedHqlQueryMementoImpl;
import org.hibernate.query.named.spi.NamedHqlQueryMemento;

public class NamedHqlQueryDefinitionImpl
extends AbstractNamedQueryDefinition
implements NamedHqlQueryDefinition {
    private final String hqlString;
    private final Integer firstResult;
    private final Integer maxResults;

    public NamedHqlQueryDefinitionImpl(String name, String hqlString, List<ParameterDefinition> parameterDefinitions, Integer firstResult, Integer maxResults, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, LockOptions lockOptions, Integer timeout, Integer fetchSize, String comment, Map<String, Object> hints) {
        super(name, parameterDefinitions, cacheable, cacheRegion, cacheMode, flushMode, readOnly, lockOptions, timeout, fetchSize, comment, hints);
        this.hqlString = hqlString;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
    }

    @Override
    public String getQueryString() {
        return this.hqlString;
    }

    @Override
    public NamedHqlQueryMemento resolve(SessionFactoryImplementor factory) {
        return new NamedHqlQueryMementoImpl(this.getName(), this.resolveParameterDescriptors(factory), this.hqlString, this.firstResult, this.maxResults, this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
    }

    public static class Builder
    extends AbstractNamedQueryDefinition.AbstractBuilder<Builder> {
        private final String hqlString;
        private Integer firstResult;
        private Integer maxResults;

        public Builder(String name, String hqlString) {
            super(name);
            this.hqlString = hqlString;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setFirstResult(Integer firstResult) {
            this.firstResult = firstResult;
            return this.getThis();
        }

        public Builder setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this.getThis();
        }

        @Override
        protected ParameterDefinition createPositionalParameter(int i, Class javaType, ParameterMode mode) {
            throw new NotYetImplementedFor6Exception();
        }

        @Override
        protected ParameterDefinition createNamedParameter(String name, Class javaType, ParameterMode mode) {
            throw new NotYetImplementedFor6Exception();
        }

        public NamedHqlQueryDefinitionImpl build() {
            return new NamedHqlQueryDefinitionImpl(this.getName(), this.hqlString, this.getParameterDescriptors(), this.firstResult, this.maxResults, this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
        }
    }
}

