/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.query.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.ParameterMode;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.model.query.internal.AbstractNamedQueryDefinition;
import org.hibernate.boot.model.query.spi.NamedNativeQueryDefinition;
import org.hibernate.boot.model.query.spi.ParameterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.internal.QueryParameterPositionalImpl;
import org.hibernate.query.named.internal.NamedNativeQueryMementoImpl;
import org.hibernate.query.named.spi.NamedNativeQueryMemento;
import org.hibernate.query.named.spi.ParameterMemento;

public class NamedNativeQueryDefinitionImpl
extends AbstractNamedQueryDefinition
implements NamedNativeQueryDefinition {
    private final String sqlString;
    private final String resultSetMappingName;
    private final Set<String> querySpaces;

    public NamedNativeQueryDefinitionImpl(String name, String sqlString, List<ParameterDefinition> parameterDescriptors, String resultSetMappingName, Set<String> querySpaces, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, LockOptions lockOptions, Integer timeout, Integer fetchSize, String comment, Map<String, Object> hints) {
        super(name, parameterDescriptors, cacheable, cacheRegion, cacheMode, flushMode, readOnly, lockOptions, timeout, fetchSize, comment, hints);
        this.sqlString = sqlString;
        this.resultSetMappingName = resultSetMappingName;
        this.querySpaces = querySpaces;
    }

    @Override
    public String getQueryString() {
        return this.sqlString;
    }

    @Override
    public String getResultSetMappingName() {
        return this.resultSetMappingName;
    }

    @Override
    public NamedNativeQueryMemento resolve(SessionFactoryImplementor factory) {
        return new NamedNativeQueryMementoImpl(this.getName(), this.resolveParameterDescriptors(factory), this.sqlString, this.resultSetMappingName, this.querySpaces, this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
    }

    public static class Builder
    extends AbstractNamedQueryDefinition.AbstractBuilder<Builder> {
        private String sqlString;
        private String resultSetMapping;

        public Builder(String name) {
            super(name);
        }

        public Builder setSqlString(String sqlString) {
            this.sqlString = sqlString;
            return this;
        }

        public NamedNativeQueryDefinitionImpl build() {
            return new NamedNativeQueryDefinitionImpl(this.getName(), this.sqlString, this.getParameterDescriptors(), this.resultSetMapping, this.getQuerySpaces(), this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        protected ParameterDefinition createPositionalParameter(final int i, final Class javaType, ParameterMode mode) {
            return new ParameterDefinition(){

                @Override
                public ParameterMemento resolve(SessionFactoryImplementor factory) {
                    return session -> new QueryParameterPositionalImpl(i, false, factory.getTypeConfiguration().getBasicTypeRegistry().getBasicType(javaType));
                }
            };
        }

        @Override
        protected ParameterDefinition createNamedParameter(String name, Class javaType, ParameterMode mode) {
            return null;
        }

        public Builder setResultSetMapping(String resultSetMapping) {
            this.resultSetMapping = resultSetMapping;
            return this;
        }
    }
}

