/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.MappedAuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.MappedNamespace;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.NamespaceName;

public class Database {
    private final Dialect dialect;
    private final JdbcEnvironment jdbcEnvironment;
    private MappedNamespace implicitNamespace;
    private final Map<NamespaceName, MappedNamespace> namespaceMap = new TreeMap<NamespaceName, MappedNamespace>();
    private Map<String, MappedAuxiliaryDatabaseObject> auxiliaryDatabaseObjects;
    private List<InitCommand> initCommands;

    public Database(MetadataBuildingOptions buildingOptions) {
        this(buildingOptions, buildingOptions.getServiceRegistry().getService(JdbcEnvironment.class));
    }

    public Database(MetadataBuildingOptions buildingOptions, JdbcEnvironment jdbcEnvironment) {
        this.jdbcEnvironment = jdbcEnvironment;
        this.dialect = Database.determineDialect(buildingOptions);
        this.implicitNamespace = this.makeNamespace(new NamespaceName(this.toIdentifier(buildingOptions.getMappingDefaults().getImplicitCatalogName()), this.toIdentifier(buildingOptions.getMappingDefaults().getImplicitSchemaName())));
    }

    private static Dialect determineDialect(MetadataBuildingOptions buildingOptions) {
        Dialect dialect = buildingOptions.getServiceRegistry().getService(JdbcServices.class).getDialect();
        if (dialect != null) {
            return dialect;
        }
        return new H2Dialect();
    }

    private MappedNamespace makeNamespace(NamespaceName name) {
        MappedNamespace namespace = new MappedNamespace(name);
        this.namespaceMap.put(name, namespace);
        return namespace;
    }

    public MappedNamespace locateNamespace(Identifier catalog, Identifier schema) {
        return this.locateNamespace(new NamespaceName(catalog, schema));
    }

    public MappedNamespace locateNamespace(NamespaceName name) {
        if (name.getCatalog() == null && name.getSchema() == null) {
            return this.getDefaultNamespace();
        }
        return this.namespaceMap.computeIfAbsent(name, n -> this.makeNamespace(name));
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public JdbcEnvironment getJdbcEnvironment() {
        return this.jdbcEnvironment;
    }

    public Identifier toIdentifier(String text) {
        return text == null ? null : this.jdbcEnvironment.getIdentifierHelper().toIdentifier(text);
    }

    public Collection<MappedNamespace> getNamespaces() {
        return this.namespaceMap.values();
    }

    public MappedNamespace getDefaultNamespace() {
        return this.implicitNamespace;
    }

    public MappedNamespace adjustDefaultNamespace(Identifier catalogName, Identifier schemaName) {
        NamespaceName name = new NamespaceName(catalogName, schemaName);
        if (this.implicitNamespace.getName().equals(name)) {
            return this.implicitNamespace;
        }
        MappedNamespace namespace = this.namespaceMap.get(name);
        if (namespace == null) {
            namespace = this.makeNamespace(name);
        }
        this.implicitNamespace = namespace;
        return this.implicitNamespace;
    }

    public MappedNamespace adjustDefaultNamespace(String implicitCatalogName, String implicitSchemaName) {
        return this.adjustDefaultNamespace(this.toIdentifier(implicitCatalogName), this.toIdentifier(implicitSchemaName));
    }

    public void addAuxiliaryDatabaseObject(MappedAuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        if (this.auxiliaryDatabaseObjects == null) {
            this.auxiliaryDatabaseObjects = new HashMap<String, MappedAuxiliaryDatabaseObject>();
        }
        this.auxiliaryDatabaseObjects.put(auxiliaryDatabaseObject.getIdentifier(), auxiliaryDatabaseObject);
    }

    public Collection<MappedAuxiliaryDatabaseObject> getAuxiliaryDatabaseObjects() {
        return this.auxiliaryDatabaseObjects == null ? Collections.emptyList() : this.auxiliaryDatabaseObjects.values();
    }

    public Collection<InitCommand> getInitCommands() {
        return this.initCommands == null ? Collections.emptyList() : this.initCommands;
    }

    public void addInitCommand(InitCommand initCommand) {
        if (this.initCommands == null) {
            this.initCommands = new ArrayList<InitCommand>();
        }
        this.initCommands.add(initCommand);
    }
}

