/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.relational;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.DenormalizedMappedTable;
import org.hibernate.boot.model.relational.MappedSequence;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.Table;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.NamespaceName;
import org.hibernate.naming.spi.RelationalNamespace;

public class MappedNamespace
implements RelationalNamespace<MappedTable, MappedSequence> {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(MappedNamespace.class);
    private final NamespaceName name;
    private Map<Identifier, MappedTable> tables = new TreeMap<Identifier, MappedTable>();
    private Map<Identifier, MappedSequence> sequences = new TreeMap<Identifier, MappedSequence>();

    public MappedNamespace(NamespaceName name) {
        this.name = name;
        log.debugf("Created database namespace [logicalName=%s]", name.toString());
    }

    @Override
    public Identifier getCatalogName() {
        return this.getName().getCatalog();
    }

    @Override
    public Identifier getSchemaName() {
        return this.getName().getSchema();
    }

    @Override
    public NamespaceName getName() {
        return this.name;
    }

    @Override
    public MappedTable getTable(UUID tableUid) {
        for (MappedTable table : this.tables.values()) {
            if (!tableUid.equals(table.getUid())) continue;
            return table;
        }
        throw new HibernateException("Could not locate Table by uid [" + tableUid + "] in namespace [" + this + ']');
    }

    @Override
    public Collection<MappedTable> getTables() {
        return this.tables.values();
    }

    public MappedTable locateTable(Identifier logicalTableName) {
        return this.tables.get(logicalTableName);
    }

    public MappedTable createTable(Identifier logicalTableName, boolean isAbstract) {
        MappedTable existing = this.tables.get(logicalTableName);
        if (existing != null) {
            return existing;
        }
        Table table = new Table(this, logicalTableName, isAbstract);
        this.tables.put(logicalTableName, table);
        return table;
    }

    public DenormalizedMappedTable createDenormalizedTable(Identifier logicalTableName, boolean isAbstract, MappedTable includedTable) {
        MappedTable existing = this.tables.get(logicalTableName);
        if (existing != null) {
            return (DenormalizedMappedTable)existing;
        }
        DenormalizedTable table = new DenormalizedTable(this, logicalTableName, isAbstract, includedTable);
        this.tables.put(logicalTableName, table);
        return table;
    }

    public MappedSequence locateSequence(Identifier name) {
        return this.sequences.get(name);
    }

    public MappedSequence createSequence(Identifier logicalName, int initialValue, int increment) {
        if (this.sequences.containsKey(logicalName)) {
            throw new HibernateException("Sequence was already registered with that name [" + logicalName.toString() + "]");
        }
        Sequence sequence = new Sequence(this.getName().getCatalog(), this.getName().getSchema(), logicalName, initialValue, increment);
        this.sequences.put(logicalName, sequence);
        return sequence;
    }

    public String toString() {
        return "Schema{name=" + this.getName() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedNamespace that = (MappedNamespace)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public Collection<MappedSequence> getSequences() {
        return this.sequences.values();
    }
}

