/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.relational;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.Loggable;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedForeignKey;
import org.hibernate.boot.model.relational.MappedIndex;
import org.hibernate.boot.model.relational.MappedPrimaryKey;
import org.hibernate.boot.model.relational.MappedUniqueKey;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.KeyValue;
import org.hibernate.metamodel.model.relational.internal.InflightTable;
import org.hibernate.metamodel.model.relational.spi.PhysicalNamingStrategy;
import org.hibernate.metamodel.model.relational.spi.RuntimeDatabaseModelProducer;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.QualifiedTableName;
import org.hibernate.type.spi.TypeConfiguration;

public interface MappedTable<T extends MappedColumn>
extends Loggable {
    public UUID getUid();

    public List<String> getCheckConstraints();

    public boolean isExportable();

    public List<InitCommand> getInitCommands();

    public Set<T> getMappedColumns();

    public void setName(String var1);

    public String getName();

    public Identifier getNameIdentifier();

    public String getQuotedName();

    public String getQuotedName(Dialect var1);

    public QualifiedTableName getQualifiedTableName();

    public String getSchema();

    public String getCatalog();

    public MappedIndex getOrCreateIndex(String var1);

    public MappedUniqueKey getOrCreateUniqueKey(String var1);

    default public MappedUniqueKey createUniqueKey(List<T> columns) {
        return null;
    }

    public void addUniqueKey(MappedUniqueKey var1);

    public void addFormula(Formula var1);

    public void createForeignKeys();

    public MappedForeignKey createForeignKey(String var1, List<T> var2, String var3, String var4);

    public MappedForeignKey createForeignKey(String var1, List var2, String var3, String var4, List var5);

    public void setUniqueInteger(int var1);

    public KeyValue getIdentifierValue();

    public void addCheckConstraint(String var1);

    public boolean containsColumn(T var1);

    public String getRowId();

    public void setRowId(String var1);

    public String getSubselect();

    public void setSubselect(String var1);

    public boolean isSubselect();

    public void setHasDenormalizedTables();

    public void setAbstract(boolean var1);

    public boolean isAbstract();

    public boolean isPhysicalTable();

    public String getComment();

    public void setComment(String var1);

    public T getColumn(T var1);

    public T getColumn(Identifier var1);

    public T getColumn(int var1);

    public void addColumn(T var1);

    public Collection<MappedIndex> getIndexes();

    public Collection<MappedForeignKey> getForeignKeys();

    public Collection<MappedUniqueKey> getUniqueKeys();

    public MappedPrimaryKey getPrimaryKey();

    public void setPrimaryKey(MappedPrimaryKey var1);

    public void addInitCommand(InitCommand var1);

    default public boolean hasDenormalizedTables() {
        return false;
    }

    default public void setIdentifierValue(KeyValue idValue) {
    }

    public InflightTable generateRuntimeTable(PhysicalNamingStrategy var1, JdbcEnvironment var2, IdentifierGeneratorFactory var3, RuntimeDatabaseModelProducer.Callback var4, TypeConfiguration var5);
}

