/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.relational;

import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.MappedSequence;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.metamodel.model.relational.spi.PhysicalNamingStrategy;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.QualifiedSequenceName;
import org.hibernate.naming.spi.QualifiedNameParser;

public class Sequence
implements MappedSequence {
    private final QualifiedSequenceName logicalName;
    private int initialValue = 1;
    private int incrementSize = 1;

    public Sequence(Identifier catalogName, Identifier schemaName, Identifier sequenceName) {
        this.logicalName = new QualifiedSequenceName(catalogName, schemaName, sequenceName);
    }

    public Sequence(Identifier catalogName, Identifier schemaName, Identifier sequenceName, int initialValue, int incrementSize) {
        this(catalogName, schemaName, sequenceName);
        this.initialValue = initialValue;
        this.incrementSize = incrementSize;
    }

    @Deprecated
    public QualifiedSequenceName getName() {
        return this.logicalName;
    }

    @Override
    public QualifiedSequenceName getLogicalName() {
        return this.logicalName;
    }

    @Override
    public int getInitialValue() {
        return this.initialValue;
    }

    @Override
    public int getIncrementSize() {
        return this.incrementSize;
    }

    @Override
    public void validate(int initialValue, int incrementSize) {
        if (this.initialValue != initialValue) {
            throw new HibernateException(String.format("Multiple references to database sequence [%s] were encountered attempting to set conflicting values for 'initial value'.  Found [%s] and [%s]", this.logicalName.render(), this.initialValue, initialValue));
        }
        if (this.incrementSize != incrementSize) {
            throw new HibernateException(String.format("Multiple references to database sequence [%s] were encountered attempting to set conflicting values for 'increment size'.  Found [%s] and [%s]", this.logicalName.render(), this.incrementSize, incrementSize));
        }
    }

    @Override
    public org.hibernate.metamodel.model.relational.spi.Sequence generateRuntimeSequence(PhysicalNamingStrategy namingStrategy, JdbcEnvironment jdbcEnvironment) {
        return new org.hibernate.metamodel.model.relational.spi.Sequence(this.getLogicalName().getCatalogName(), this.getLogicalName().getSchemaName(), this.getLogicalName().getSequenceName(), this.getInitialValue(), this.getIncrementSize(), namingStrategy, jdbcEnvironment);
    }

    @Override
    public String toLoggableString() {
        return "Sequence(" + this.logicalName.render() + ")";
    }

    public static class Name
    extends QualifiedNameParser.NameParts {
        public Name(Identifier catalogIdentifier, Identifier schemaIdentifier, Identifier nameIdentifier) {
            super(catalogIdentifier, schemaIdentifier, nameIdentifier);
        }
    }
}

