/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.resultset.internal;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Metamodel;
import org.hibernate.boot.model.resultset.spi.ResultSetMappingDefinition;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.sql.spi.QueryResultBuilder;
import org.hibernate.query.sql.spi.QueryResultBuilderRootEntity;

public class EntityResultDefinitionImpl
implements ResultSetMappingDefinition.EntityResult {
    private final String entityName;
    private final String entityClassName;
    private final String tableAlias;
    private LockMode lockMode;

    public EntityResultDefinitionImpl(String entityName, String entityClassName, String tableAlias) {
        if (StringHelper.isEmpty(entityName) && StringHelper.isEmpty(entityClassName)) {
            throw new HibernateException("Native-query entity result must specify either entity class name or entity name");
        }
        this.entityName = entityName;
        this.entityClassName = entityClassName;
        this.tableAlias = tableAlias;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public String getEntityClassName() {
        return this.entityClassName;
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public QueryResultBuilder generateQueryResultBuilder(Metamodel metamodel) {
        EntityTypeDescriptor entityDescriptor = StringHelper.isNotEmpty(this.entityName) ? metamodel.findEntityDescriptor(this.entityName) : metamodel.findEntityDescriptor(this.entityClassName);
        return new QueryResultBuilderRootEntity(this.tableAlias, entityDescriptor);
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
    }
}

