/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.resultset.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.boot.model.resultset.internal.FetchDefinitionImpl;
import org.hibernate.boot.model.resultset.spi.ResultSetMappingDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.ResultSetMappingDescriptor;

public class ResultSetMappingDefinitionImpl
implements ResultSetMappingDefinition {
    private final String name;
    private List<ResultSetMappingDefinition.Result> results;
    private List<FetchDefinitionImpl> fetches;

    public ResultSetMappingDefinitionImpl(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ResultSetMappingDefinition.Result> getResults() {
        return this.results == null ? Collections.emptyList() : Collections.unmodifiableList(this.results);
    }

    @Override
    public List<FetchDefinitionImpl> getFetches() {
        return this.fetches == null ? Collections.emptyList() : Collections.unmodifiableList(this.fetches);
    }

    public void addResult(ResultSetMappingDefinition.Result result) {
        if (this.results == null) {
            this.results = new ArrayList<ResultSetMappingDefinition.Result>();
        }
        this.results.add(result);
    }

    public void addFetch(FetchDefinitionImpl fetch) {
        if (this.fetches == null) {
            this.fetches = new ArrayList<FetchDefinitionImpl>();
        }
        this.fetches.add(fetch);
    }

    @Override
    public ResultSetMappingDescriptor resolve(SessionFactoryImplementor sessionFactory) {
        ResultSetMappingDescriptor resultSetMapping = new ResultSetMappingDescriptor(this.name);
        for (ResultSetMappingDefinition.Result result : this.results) {
            resultSetMapping.addResultBuilder(result.generateQueryResultBuilder(sessionFactory.getMetamodel()));
        }
        return resultSetMapping;
    }
}

