/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.resultset.internal;

import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Metamodel;
import org.hibernate.boot.model.resultset.spi.ResultSetMappingDefinition;
import org.hibernate.query.sql.spi.QueryResultBuilder;
import org.hibernate.query.sql.spi.QueryResultBuilderScalar;
import org.hibernate.type.spi.BasicType;

public class ScalarResultDefinitionImpl
implements ResultSetMappingDefinition.ScalarResult {
    private final String columnAlias;
    private final String typeName;

    public ScalarResultDefinitionImpl(String columnAlias, String typeName) {
        this.columnAlias = columnAlias;
        this.typeName = typeName;
    }

    @Override
    public String getColumnAlias() {
        return this.columnAlias;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public QueryResultBuilder generateQueryResultBuilder(Metamodel metamodel) {
        BasicType basicType = metamodel.getTypeConfiguration().getBasicTypeRegistry().getBasicTypeByName(this.typeName);
        if (basicType == null) {
            throw this.noTypeException(this.typeName);
        }
        return new QueryResultBuilderScalar(this.columnAlias, basicType.getSqlExpressableType(metamodel.getTypeConfiguration()));
    }

    protected HibernateException noTypeException(String typeName) {
        throw new MappingException(String.format("Unable to resolve type [%s] specified for native query scalar return", typeName));
    }
}

