/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal;

import java.util.function.Supplier;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class SourceHelper {
    public static <T extends JavaTypeDescriptor> T resolveJavaDescriptor(String name, TypeConfiguration typeConfiguration, Supplier<T> generator) {
        JavaTypeDescriptorRegistry jtr = typeConfiguration.getJavaTypeDescriptorRegistry();
        JavaTypeDescriptor jtd = jtr.getDescriptor(name);
        if (jtd == null) {
            jtd = (JavaTypeDescriptor)generator.get();
            jtr.addDescriptor(jtd);
        }
        return (T)jtd;
    }

    public static <T> Class<T> resolveJavaType(String className, MetadataBuildingContext metadataBuildingContext) {
        return SourceHelper.resolveJavaType(className, metadataBuildingContext.getBootstrapContext());
    }

    public static <T> Class<T> resolveJavaType(String className, BootstrapContext bootstrapContext) {
        ClassLoaderService cls = bootstrapContext.getServiceRegistry().getService(ClassLoaderService.class);
        try {
            return cls.classForName(className);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private SourceHelper() {
    }
}

