/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal.hbm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryCollectionLoadReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryJoinReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryPropertyReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryScalarReturnType;
import org.hibernate.boot.jaxb.hbm.spi.NativeQueryNonScalarRootReturn;
import org.hibernate.boot.jaxb.hbm.spi.ResultSetMappingBindingDefinition;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.boot.model.resultset.internal.EntityResultDefinitionImpl;
import org.hibernate.boot.model.resultset.internal.FetchDefinitionImpl;
import org.hibernate.boot.model.resultset.internal.PersistentCollectionResultDefinitionImpl;
import org.hibernate.boot.model.resultset.internal.ResultSetMappingDefinitionImpl;
import org.hibernate.boot.model.resultset.internal.ScalarResultDefinitionImpl;
import org.hibernate.boot.model.resultset.spi.ResultSetMappingDefinition;
import org.hibernate.boot.model.source.internal.hbm.HbmLocalMetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;

public abstract class ResultSetMappingBinder {
    public static ResultSetMappingDefinition bind(ResultSetMappingBindingDefinition hbmResultSetMapping, HbmLocalMetadataBuildingContext context) {
        if (hbmResultSetMapping.getName() == null) {
            throw new MappingException("ResultSet mapping did not specify name", context.getOrigin());
        }
        ResultSetMappingDefinitionImpl bootModel = new ResultSetMappingDefinitionImpl(hbmResultSetMapping.getName());
        ResultSetMappingBinder.bind(hbmResultSetMapping, bootModel, context);
        return bootModel;
    }

    public static ResultSetMappingDefinition bind(ResultSetMappingBindingDefinition resultSetMappingSource, HbmLocalMetadataBuildingContext context, String prefix) {
        if (StringHelper.isEmpty(prefix)) {
            throw new AssertionFailure("Passed prefix was null; perhaps you meant to call the alternate #bind form?");
        }
        String resultSetName = prefix + '.' + resultSetMappingSource.getName();
        ResultSetMappingDefinitionImpl binding = new ResultSetMappingDefinitionImpl(resultSetName);
        ResultSetMappingBinder.bind(resultSetMappingSource, binding, context);
        return binding;
    }

    private static void bind(ResultSetMappingBindingDefinition hbmModel, ResultSetMappingDefinitionImpl bootModel, HbmLocalMetadataBuildingContext context) {
        for (Object valueMappingSource : hbmModel.getValueMappingSources()) {
            if (JaxbHbmNativeQueryReturnType.class.isInstance(valueMappingSource)) {
                bootModel.addResult(ResultSetMappingBinder.extractReturnDescription((JaxbHbmNativeQueryReturnType)valueMappingSource, context));
                continue;
            }
            if (JaxbHbmNativeQueryCollectionLoadReturnType.class.isInstance(valueMappingSource)) {
                bootModel.addResult(ResultSetMappingBinder.extractReturnDescription((JaxbHbmNativeQueryCollectionLoadReturnType)valueMappingSource, context));
                continue;
            }
            if (JaxbHbmNativeQueryJoinReturnType.class.isInstance(valueMappingSource)) {
                bootModel.addFetch(ResultSetMappingBinder.extractReturnDescription((JaxbHbmNativeQueryJoinReturnType)valueMappingSource, context));
                continue;
            }
            if (!JaxbHbmNativeQueryScalarReturnType.class.isInstance(valueMappingSource)) continue;
            bootModel.addResult(ResultSetMappingBinder.extractReturnDescription((JaxbHbmNativeQueryScalarReturnType)valueMappingSource, context));
        }
    }

    public static ScalarResultDefinitionImpl extractReturnDescription(JaxbHbmNativeQueryScalarReturnType rtnSource, final HbmLocalMetadataBuildingContext context) {
        return new ScalarResultDefinitionImpl(rtnSource.getColumn(), rtnSource.getType()){

            @Override
            protected HibernateException noTypeException(String typeName) {
                throw new MappingException(String.format("Unable to resolve type [%s] specified for native query scalar return", typeName), context.getOrigin());
            }
        };
    }

    public static ResultSetMappingDefinition.EntityResult extractReturnDescription(JaxbHbmNativeQueryReturnType rtnSource, HbmLocalMetadataBuildingContext context) {
        return new EntityResultDefinitionImpl(rtnSource.getEntityName(), rtnSource.getClazz(), rtnSource.getAlias());
    }

    public static FetchDefinitionImpl extractReturnDescription(JaxbHbmNativeQueryJoinReturnType rtnSource, HbmLocalMetadataBuildingContext context) {
        int dot = rtnSource.getProperty().lastIndexOf(46);
        if (dot == -1) {
            throw new MappingException(String.format(Locale.ENGLISH, "Role attribute for sql query return [%s] not formatted correctly {owningAlias.propertyName}", rtnSource.getAlias()), context.getOrigin());
        }
        String roleOwnerAlias = rtnSource.getProperty().substring(0, dot);
        String roleProperty = rtnSource.getProperty().substring(dot + 1);
        return new FetchDefinitionImpl(rtnSource.getAlias(), roleOwnerAlias, roleProperty, rtnSource.getLockMode());
    }

    public static PersistentCollectionResultDefinitionImpl extractReturnDescription(JaxbHbmNativeQueryCollectionLoadReturnType rtnSource, HbmLocalMetadataBuildingContext context) {
        int dot = rtnSource.getRole().lastIndexOf(46);
        if (dot == -1) {
            throw new MappingException(String.format(Locale.ENGLISH, "Collection attribute for sql query return [%s] not formatted correctly {OwnerClassName.propertyName}", rtnSource.getAlias()), context.getOrigin());
        }
        return new PersistentCollectionResultDefinitionImpl(context.findEntityBinding(null, rtnSource.getRole().substring(0, dot)).getClassName(), rtnSource.getRole().substring(dot + 1), rtnSource.getAlias(), rtnSource.getLockMode(), ResultSetMappingBinder.extractPropertyResults(rtnSource.getAlias(), rtnSource, null, context));
    }

    private static Map<String, String[]> extractPropertyResults(String alias, JaxbHbmNativeQueryReturnType rtnSource, PersistentClass pc, HbmLocalMetadataBuildingContext context) {
        Map<String, String[]> results = ResultSetMappingBinder.extractPropertyResults(alias, (NativeQueryNonScalarRootReturn)rtnSource, pc, context);
        if (rtnSource.getReturnDiscriminator() != null) {
            String column;
            if (results == null) {
                results = new HashMap<String, String[]>();
            }
            if ((column = rtnSource.getReturnDiscriminator().getColumn()) == null) {
                throw new MappingException(String.format(Locale.ENGLISH, "return-discriminator [%s (%s)] did not specify column", pc.getEntityName(), alias), context.getOrigin());
            }
            results.put("class", new String[]{column});
        }
        return results;
    }

    private static Map<String, String[]> extractPropertyResults(String alias, NativeQueryNonScalarRootReturn rtnSource, PersistentClass pc, HbmLocalMetadataBuildingContext context) {
        if (CollectionHelper.isEmpty(rtnSource.getReturnProperty())) {
            return null;
        }
        HashMap<String, String[]> results = new HashMap<String, String[]>();
        ArrayList<JaxbHbmNativeQueryPropertyReturnType> propertyReturnSources = new ArrayList<JaxbHbmNativeQueryPropertyReturnType>();
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (JaxbHbmNativeQueryPropertyReturnType propertyReturnSource : rtnSource.getReturnProperty()) {
            List<PersistentAttributeMapping> parentAttributes;
            int n = propertyReturnSource.getName().lastIndexOf(46);
            if (pc == null || n == -1) {
                propertyReturnSources.add(propertyReturnSource);
                propertyNames.add(propertyReturnSource.getName());
                continue;
            }
            String reducedName = propertyReturnSource.getName().substring(0, n);
            Value value = pc.getRecursiveProperty(reducedName).getValue();
            if (value instanceof Component) {
                Component comp = (Component)value;
                parentAttributes = comp.getDeclaredPersistentAttributes();
            } else if (value instanceof ToOne) {
                ToOne toOne = (ToOne)value;
                PersistentClass referencedPc = context.getMetadataCollector().getEntityBinding(toOne.getReferencedEntityName());
                if (toOne.getReferencedPropertyName() != null) {
                    try {
                        parentAttributes = ((Component)referencedPc.getRecursiveProperty(toOne.getReferencedPropertyName()).getValue()).getDeclaredPersistentAttributes();
                    }
                    catch (ClassCastException e) {
                        throw new MappingException("dotted notation reference neither a component nor a many/one to one", e, context.getOrigin());
                    }
                } else {
                    try {
                        if (referencedPc.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping() == null) {
                            parentAttributes = ((Component)referencedPc.getIdentifierAttributeMapping().getValueMapping()).getDeclaredPersistentAttributes();
                        }
                        parentAttributes = referencedPc.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping().getDeclaredPersistentAttributes();
                    }
                    catch (ClassCastException e) {
                        throw new MappingException("dotted notation reference neither a component nor a many/one to one", e, context.getOrigin());
                    }
                }
            } else {
                throw new MappingException("dotted notation reference neither a component nor a many/one to one", context.getOrigin());
            }
            boolean hasFollowers = false;
            ArrayList<String> followers = new ArrayList<String>();
            for (PersistentAttributeMapping parentAttribute : parentAttributes) {
                String currentPropertyName = parentAttribute.getName();
                String currentName = reducedName + '.' + currentPropertyName;
                if (hasFollowers) {
                    followers.add(currentName);
                }
                if (!propertyReturnSource.getName().equals(currentName)) continue;
                hasFollowers = true;
            }
            int index = propertyNames.size();
            for (String follower : followers) {
                int currentIndex = ResultSetMappingBinder.getIndexOfFirstMatchingProperty(propertyNames, follower);
                index = currentIndex != -1 && currentIndex < index ? currentIndex : index;
            }
            propertyNames.add(index, propertyReturnSource.getName());
            propertyReturnSources.add(index, propertyReturnSource);
        }
        HashSet<String> uniqueReturnProperty = new HashSet<String>();
        for (JaxbHbmNativeQueryPropertyReturnType jaxbHbmNativeQueryPropertyReturnType : propertyReturnSources) {
            String name = jaxbHbmNativeQueryPropertyReturnType.getName();
            if ("class".equals(name)) {
                throw new MappingException("class is not a valid property name to use in a <return-property>, use <return-discriminator> instead", context.getOrigin());
            }
            ArrayList<String> allResultColumns = ResultSetMappingBinder.extractResultColumns(jaxbHbmNativeQueryPropertyReturnType);
            if (allResultColumns.isEmpty()) {
                throw new MappingException(String.format(Locale.ENGLISH, "return-property [alias=%s, property=%s] must specify at least one column or return-column name", alias, jaxbHbmNativeQueryPropertyReturnType.getName()), context.getOrigin());
            }
            if (uniqueReturnProperty.contains(name)) {
                throw new MappingException(String.format(Locale.ENGLISH, "Duplicate return-property [alias=%s] : %s", alias, jaxbHbmNativeQueryPropertyReturnType.getName()), context.getOrigin());
            }
            uniqueReturnProperty.add(name);
            ArrayList intermediateResults = (ArrayList)results.get(name);
            if (intermediateResults == null) {
                results.put(name, (String[])allResultColumns);
                continue;
            }
            intermediateResults.addAll(allResultColumns);
        }
        for (Object object : results.entrySet()) {
            Map.Entry entry = (Map.Entry)object;
            if (!(entry.getValue() instanceof ArrayList)) continue;
            ArrayList list = (ArrayList)entry.getValue();
            entry.setValue(list.toArray(new String[list.size()]));
        }
        return results.isEmpty() ? Collections.EMPTY_MAP : results;
    }

    private static int getIndexOfFirstMatchingProperty(List propertyNames, String follower) {
        int propertySize = propertyNames.size();
        for (int propIndex = 0; propIndex < propertySize; ++propIndex) {
            if (!((String)propertyNames.get(propIndex)).startsWith(follower)) continue;
            return propIndex;
        }
        return -1;
    }

    private static ArrayList<String> extractResultColumns(JaxbHbmNativeQueryPropertyReturnType propertyReturnSource) {
        String column = ResultSetMappingBinder.unquote(propertyReturnSource.getColumn());
        ArrayList<String> allResultColumns = new ArrayList<String>();
        if (column != null) {
            allResultColumns.add(column);
        }
        for (JaxbHbmNativeQueryPropertyReturnType.JaxbHbmReturnColumn returnColumnSource : propertyReturnSource.getReturnColumn()) {
            allResultColumns.add(ResultSetMappingBinder.unquote(returnColumnSource.getName()));
        }
        return allResultColumns;
    }

    private static String unquote(String name) {
        if (name != null && name.charAt(0) == '`') {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }
}

