/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.type.internal;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.type.spi.TypeDefinitionRegistry;
import org.hibernate.boot.model.type.spi.TypeResolverTemplate;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class TypeDefinitionRegistryImpl
implements TypeDefinitionRegistry {
    private static final Logger log = Logger.getLogger(TypeDefinitionRegistryImpl.class);
    private final TypeConfiguration typeConfiguration;
    private final Map<String, TypeDefinition> typeDefinitionMap = new HashMap<String, TypeDefinition>();

    public TypeDefinitionRegistryImpl(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    @Override
    public TypeDefinition resolve(String typeName) {
        return this.typeDefinitionMap.get(typeName);
    }

    @Override
    public TypeDefinitionRegistry register(TypeDefinition typeDefinition) {
        return this.register(typeDefinition, TypeDefinitionRegistry.DuplicationStrategy.OVERWRITE);
    }

    @Override
    public TypeDefinitionRegistry register(TypeDefinition typeDefinition, TypeDefinitionRegistry.DuplicationStrategy duplicationStrategy) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException("TypeDefinition to register cannot be null");
        }
        if (typeDefinition.getTypeImplementorClass() == null) {
            throw new IllegalArgumentException("TypeDefinition to register cannot define null #typeImplementorClass");
        }
        if (!StringHelper.isEmpty(typeDefinition.getName())) {
            this.register(typeDefinition.getName(), typeDefinition, duplicationStrategy);
        }
        if (typeDefinition.getRegistrationKeys() != null) {
            for (String registrationKey : typeDefinition.getRegistrationKeys()) {
                this.register(registrationKey, typeDefinition, duplicationStrategy);
            }
        }
        return this;
    }

    private void register(String name, TypeDefinition typeDefinition, TypeDefinitionRegistry.DuplicationStrategy duplicationStrategy) {
        if (duplicationStrategy == TypeDefinitionRegistry.DuplicationStrategy.KEEP) {
            if (!this.typeDefinitionMap.containsKey(name)) {
                this.typeDefinitionMap.put(name, typeDefinition);
            }
        } else {
            TypeResolverTemplate existing = this.typeDefinitionMap.put(name, typeDefinition);
            if (existing != null && existing != typeDefinition) {
                if (duplicationStrategy == TypeDefinitionRegistry.DuplicationStrategy.OVERWRITE) {
                    log.debugf("Overwrote existing registration [%s] for type definition.", (Object)name);
                } else {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Attempted to ovewrite registration [%s] for type definition.", name));
                }
            }
        }
    }
}

