/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.registry.selector.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.selector.spi.StrategySelectionException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.jboss.logging.Logger;

public class StrategySelectorImpl
implements StrategySelector {
    private static final Logger log = Logger.getLogger(StrategySelectorImpl.class);
    private static final StandardCreator STANDARD_CREATOR = new StandardCreator();
    private final Map<Class, Map<String, Class>> namedStrategyImplementorByStrategyMap = new ConcurrentHashMap<Class, Map<String, Class>>();
    private final ClassLoaderService classLoaderService;

    public static <I> StandardCreator<I> getStandardCreator() {
        return STANDARD_CREATOR;
    }

    public StrategySelectorImpl(ClassLoaderService classLoaderService) {
        this.classLoaderService = classLoaderService;
    }

    @Override
    public <T> void registerStrategyImplementor(Class<T> strategy, String name, Class<? extends T> implementation) {
        Class<T> old;
        Map<String, Class> namedStrategyImplementorMap = this.namedStrategyImplementorByStrategyMap.get(strategy);
        if (namedStrategyImplementorMap == null) {
            namedStrategyImplementorMap = new ConcurrentHashMap<String, Class>();
            this.namedStrategyImplementorByStrategyMap.put(strategy, namedStrategyImplementorMap);
        }
        if ((old = namedStrategyImplementorMap.put(name, implementation)) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Registering named strategy selector [%s] : [%s] -> [%s]", strategy.getName(), name, implementation.getName()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Registering named strategy selector [%s] : [%s] -> [%s] (replacing [%s])", strategy.getName(), name, implementation.getName(), old.getName()));
        }
    }

    @Override
    public <T> void unRegisterStrategyImplementor(Class<T> strategy, Class<? extends T> implementation) {
        Map<String, Class> namedStrategyImplementorMap = this.namedStrategyImplementorByStrategyMap.get(strategy);
        if (namedStrategyImplementorMap == null) {
            log.debug((Object)"Named strategy map did not exist on call to un-register");
            return;
        }
        Iterator<Class> itr = namedStrategyImplementorMap.values().iterator();
        while (itr.hasNext()) {
            Class registered = itr.next();
            if (!registered.equals(implementation)) continue;
            itr.remove();
        }
        if (namedStrategyImplementorMap.isEmpty()) {
            this.namedStrategyImplementorByStrategyMap.remove(strategy);
        }
    }

    public Collection getRegisteredStrategyImplementors(Class strategy) {
        Map<String, Class> registrations = this.namedStrategyImplementorByStrategyMap.get(strategy);
        if (registrations == null) {
            return Collections.emptySet();
        }
        return new HashSet<Class>(registrations.values());
    }

    @Override
    public <T, I extends T> Class<I> selectStrategyImplementor(Class<T> strategy, String name) {
        Class registered;
        Map<String, Class> namedStrategyImplementorMap = this.namedStrategyImplementorByStrategyMap.get(strategy);
        if (namedStrategyImplementorMap != null && (registered = namedStrategyImplementorMap.get(name)) != null) {
            return registered;
        }
        try {
            return this.classLoaderService.classForName(name);
        }
        catch (ClassLoadingException e) {
            throw new StrategySelectionException("Unable to resolve name [" + name + "] as strategy [" + strategy.getName() + "]", (Throwable)((Object)e));
        }
    }

    @Override
    public <T, I extends T> I resolveStrategy(Class<T> strategy, Object strategyReference) {
        return this.resolveStrategy(strategy, strategyReference, StrategySelectorImpl.getStandardCreator());
    }

    @Override
    public <T, I extends T> I resolveStrategy(Class<T> strategy, Object strategyReference, I fallbackValue) {
        return (I)this.resolveStrategy(strategy, strategyReference, (Supplier<I>)((Supplier<Object>)() -> fallbackValue), (Function<Class<I>, I>)StrategySelectorImpl.getStandardCreator());
    }

    @Override
    public <T, I extends T> I resolveStrategy(Class<T> strategy, Object strategyReference, Supplier<I> fallbackValueSupplier) {
        return this.resolveStrategy(strategy, strategyReference, fallbackValueSupplier, (Function<Class<I>, I>)StrategySelectorImpl.getStandardCreator());
    }

    @Override
    public <T, I extends T> I resolveStrategy(Class<T> strategy, Object strategyReference, Function<Class<I>, I> creator) {
        return this.resolveStrategy(strategy, strategyReference, (I)null, creator);
    }

    @Override
    public <T, I extends T> I resolveStrategy(Class<T> strategy, Object strategyReference, I fallbackValue, Function<Class<I>, I> creator) {
        return (I)this.resolveStrategy(strategy, strategyReference, () -> fallbackValue, creator);
    }

    @Override
    public <T, I extends T> I resolveStrategy(Class<T> strategy, Object strategyReference, Supplier<I> fallbackValueSupplier, Function<Class<I>, I> creator) {
        if (strategyReference == null) {
            try {
                return fallbackValueSupplier.get();
            }
            catch (Exception e) {
                throw new StrategySelectionException("Default value supplier threw exception", e);
            }
        }
        if (strategy.isInstance(strategyReference)) {
            return (I)strategy.cast(strategyReference);
        }
        Class<I> implementationClass = Class.class.isInstance(strategyReference) ? (Class<I>)strategyReference : this.selectStrategyImplementor(strategy, strategyReference.toString());
        try {
            return creator.apply(implementationClass);
        }
        catch (Exception e) {
            throw new StrategySelectionException(String.format("Could not instantiate named strategy class [%s]", implementationClass.getName()), e);
        }
    }

    @Override
    public <T, I extends T> I resolveStrategy(Class<T> strategy, Object strategyReference, Callable<I> fallbackValueSupplier, Function<Class<I>, I> creator) {
        return this.resolveStrategy(strategy, strategyReference, this.supplier(fallbackValueSupplier), creator);
    }

    @Deprecated
    private <I> Supplier<I> supplier(Callable<I> callableForm) {
        return () -> {
            try {
                return callableForm.call();
            }
            catch (Exception e) {
                throw new StrategySelectionException("Error calling Callable to determine strategy default value", e);
            }
        };
    }

    @Override
    public <T, I extends T> I resolveDefaultableStrategy(Class<T> strategy, Object strategyReference, I fallbackValue) {
        return (I)this.resolveStrategy(strategy, strategyReference, () -> fallbackValue);
    }

    @Override
    public <T> T resolveDefaultableStrategy(Class<T> strategy, Object strategyReference, Supplier<T> fallbackValueSupplier) {
        return (T)this.resolveDefaultableStrategy(strategy, strategyReference, () -> fallbackValueSupplier.get());
    }

    @Override
    public <T, I extends T> I resolveDefaultableStrategy(Class<T> strategy, Object strategyReference, Callable<I> fallbackValueSupplier) {
        return this.resolveStrategy(strategy, strategyReference, fallbackValueSupplier, (Function<Class<I>, I>)StrategySelectorImpl.getStandardCreator());
    }

    private static class StandardCreator<I>
    implements Function<Class<I>, I> {
        private StandardCreator() {
        }

        @Override
        public I apply(Class<I> strategyImplClass) {
            try {
                return strategyImplClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new StrategySelectionException(String.format("Could not instantiate named strategy class [%s]", strategyImplClass.getName()), e);
            }
        }
    }
}

