/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi.interceptor;

import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.type.descriptor.java.internal.CollectionJavaDescriptor;

public class LazyAttributeDescriptor {
    private final int attributeIndex;
    private final int lazyIndex;
    private final String name;
    private final String fetchGroupName;

    public static LazyAttributeDescriptor from(PersistentAttributeMapping attributeMapping, int attributeIndex, int lazyIndex) {
        String fetchGroupName = attributeMapping.getLazyGroup();
        if (fetchGroupName == null) {
            JavaTypeMapping javaTypeMapping = attributeMapping.getValueMapping().getJavaTypeMapping();
            fetchGroupName = javaTypeMapping.getJavaTypeDescriptor() instanceof CollectionJavaDescriptor ? attributeMapping.getName() : "DEFAULT";
        }
        return new LazyAttributeDescriptor(attributeIndex, lazyIndex, attributeMapping.getName(), fetchGroupName);
    }

    private LazyAttributeDescriptor(int attributeIndex, int lazyIndex, String name, String fetchGroupName) {
        assert (attributeIndex >= lazyIndex);
        this.attributeIndex = attributeIndex;
        this.lazyIndex = lazyIndex;
        this.name = name;
        this.fetchGroupName = fetchGroupName;
    }

    public int getAttributeIndex() {
        return this.attributeIndex;
    }

    public int getLazyIndex() {
        return this.lazyIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getFetchGroupName() {
        return this.fetchGroupName;
    }
}

