/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal;

import org.hibernate.boot.model.domain.EntityMapping;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributesMetadata;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.bytecode.spi.NotInstrumentedException;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class BytecodeEnhancementMetadataPojoImpl
implements BytecodeEnhancementMetadata {
    private final String entityName;
    private final Class entityClass;
    private final boolean enhancedForLazyLoading;
    private final LazyAttributesMetadata lazyAttributesMetadata;

    public static BytecodeEnhancementMetadata from(EntityMapping entityMapping) {
        Class mappedClass = entityMapping.getJavaTypeMapping().getJavaTypeDescriptor().getJavaType();
        boolean enhancedForLazyLoading = PersistentAttributeInterceptable.class.isAssignableFrom(mappedClass);
        LazyAttributesMetadata lazyAttributesMetadata = enhancedForLazyLoading ? LazyAttributesMetadata.from(entityMapping) : LazyAttributesMetadata.nonEnhanced(entityMapping.getEntityName());
        return new BytecodeEnhancementMetadataPojoImpl(entityMapping.getEntityName(), mappedClass, enhancedForLazyLoading, lazyAttributesMetadata);
    }

    public BytecodeEnhancementMetadataPojoImpl(String entityName, Class entityClass, boolean enhancedForLazyLoading, LazyAttributesMetadata lazyAttributesMetadata) {
        this.entityName = entityName;
        this.entityClass = entityClass;
        this.enhancedForLazyLoading = enhancedForLazyLoading;
        this.lazyAttributesMetadata = lazyAttributesMetadata;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public boolean isEnhancedForLazyLoading() {
        return this.enhancedForLazyLoading;
    }

    @Override
    public LazyAttributesMetadata getLazyAttributesMetadata() {
        return this.lazyAttributesMetadata;
    }

    @Override
    public boolean hasUnFetchedAttributes(Object entity) {
        LazyAttributeLoadingInterceptor interceptor = this.enhancedForLazyLoading ? this.extractInterceptor(entity) : null;
        return interceptor != null && interceptor.hasAnyUninitializedAttributes();
    }

    @Override
    public boolean isAttributeLoaded(Object entity, String attributeName) {
        LazyAttributeLoadingInterceptor interceptor = this.enhancedForLazyLoading ? this.extractInterceptor(entity) : null;
        return interceptor == null || interceptor.isAttributeLoaded(attributeName);
    }

    @Override
    public LazyAttributeLoadingInterceptor extractInterceptor(Object entity) throws NotInstrumentedException {
        if (!this.enhancedForLazyLoading) {
            throw new NotInstrumentedException("Entity class [" + this.entityClass.getName() + "] is not enhanced for lazy loading");
        }
        if (!this.entityClass.isInstance(entity)) {
            throw new IllegalArgumentException(String.format("Passed entity instance [%s] is not of expected type [%s]", entity, this.getEntityName()));
        }
        PersistentAttributeInterceptor interceptor = ((PersistentAttributeInterceptable)entity).$$_hibernate_getInterceptor();
        if (interceptor == null) {
            return null;
        }
        return (LazyAttributeLoadingInterceptor)interceptor;
    }

    @Override
    public LazyAttributeLoadingInterceptor injectInterceptor(Object entity, SharedSessionContractImplementor session) {
        if (!this.enhancedForLazyLoading) {
            throw new NotInstrumentedException("Entity class [" + this.entityClass.getName() + "] is not enhanced for lazy loading");
        }
        if (!this.entityClass.isInstance(entity)) {
            throw new IllegalArgumentException(String.format("Passed entity instance [%s] is not of expected type [%s]", entity, this.getEntityName()));
        }
        LazyAttributeLoadingInterceptor interceptor = new LazyAttributeLoadingInterceptor(this.getEntityName(), this.lazyAttributesMetadata.getLazyAttributeNames(), session);
        ((PersistentAttributeInterceptable)entity).$$_hibernate_setInterceptor(interceptor);
        return interceptor;
    }
}

