/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import java.util.Objects;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

final class CacheKeyImplementation
implements Serializable {
    private final Object id;
    private final JavaTypeDescriptor idJavaTypeDescriptor;
    private final NavigableRole navigableRole;
    private final String tenantId;
    private final int hashCode;

    CacheKeyImplementation(Object id, JavaTypeDescriptor idJavaTypeDescriptor, NavigableRole entityOrRoleName, String tenantId) {
        this.id = id;
        this.idJavaTypeDescriptor = idJavaTypeDescriptor;
        this.navigableRole = entityOrRoleName;
        this.tenantId = tenantId;
        this.hashCode = CacheKeyImplementation.calculateHashCode(idJavaTypeDescriptor, id, tenantId);
    }

    private static int calculateHashCode(JavaTypeDescriptor typeDescriptor, Object value, String tenantId) {
        int result = typeDescriptor.extractHashCode(value);
        result = 31 * result + (tenantId != null ? tenantId.hashCode() : 0);
        return result;
    }

    public Object getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.hashCode != other.hashCode() || !(other instanceof CacheKeyImplementation)) {
            return false;
        }
        CacheKeyImplementation that = (CacheKeyImplementation)other;
        return Objects.equals(this.navigableRole, that.navigableRole) && this.idJavaTypeDescriptor.areEqual(this.id, that.id) && Objects.equals(this.tenantId, that.tenantId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.navigableRole.getFullPath() + '#' + this.id.toString();
    }
}

