/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.boot.Metadata;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.metamodel.model.domain.spi.CollectionElement;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jboss.logging.Logger;

public class CollectionCacheInvalidator
implements Integrator,
PostInsertEventListener,
PostDeleteEventListener,
PostUpdateEventListener {
    private static final Logger LOG = Logger.getLogger((String)CollectionCacheInvalidator.class.getName());
    public static boolean PROPAGATE_EXCEPTION = false;

    @Override
    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.integrate(serviceRegistry, sessionFactory);
    }

    @Override
    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    @Override
    public void onPostInsert(PostInsertEvent event) {
        this.evictCache(event.getEntity(), event.getDescriptor(), event.getSession(), null);
    }

    @Override
    public boolean requiresPostCommitHandling(EntityTypeDescriptor descriptor) {
        return true;
    }

    @Override
    public void onPostDelete(PostDeleteEvent event) {
        this.evictCache(event.getEntity(), event.getDescriptor(), event.getSession(), null);
    }

    @Override
    public void onPostUpdate(PostUpdateEvent event) {
        this.evictCache(event.getEntity(), event.getDescriptor(), event.getSession(), event.getOldState());
    }

    private void integrate(SessionFactoryServiceRegistry serviceRegistry, SessionFactoryImplementor sessionFactory) {
        if (!sessionFactory.getSessionFactoryOptions().isAutoEvictCollectionCache()) {
            return;
        }
        if (!sessionFactory.getSessionFactoryOptions().isSecondLevelCacheEnabled()) {
            return;
        }
        EventListenerRegistry eventListenerRegistry = serviceRegistry.getService(EventListenerRegistry.class);
        eventListenerRegistry.appendListeners(EventType.POST_INSERT, this);
        eventListenerRegistry.appendListeners(EventType.POST_DELETE, this);
        eventListenerRegistry.appendListeners(EventType.POST_UPDATE, this);
    }

    private void evictCache(Object entity, EntityTypeDescriptor entityDescriptor, EventSource session, Object[] oldState) {
        try {
            SessionFactoryImplementor factory = entityDescriptor.getFactory();
            for (PersistentCollectionDescriptor<?, ?, ?> collectionDescriptor : factory.getMetamodel().findCollectionsByEntityParticipant(entityDescriptor)) {
                CollectionDataAccess cacheAccess = collectionDescriptor.getCacheAccess();
                if (cacheAccess == null) continue;
                String mappedBy = collectionDescriptor.getMappedByProperty();
                if (collectionDescriptor.getElementDescriptor().getClassification() != CollectionElement.ElementClassification.MANY_TO_MANY && mappedBy != null && !mappedBy.isEmpty()) {
                    Object ref;
                    Object id;
                    NonIdPersistentAttribute attribute = entityDescriptor.findPersistentAttribute(mappedBy);
                    int i = attribute.getStateArrayPosition();
                    Object oldId = null;
                    if (oldState != null) {
                        oldId = this.getIdentifier(session, oldState[i]);
                    }
                    if (((id = this.getIdentifier(session, ref = entityDescriptor.getPropertyValue(entity, i))) == null || id.equals(oldId)) && (oldId == null || oldId.equals(id))) continue;
                    if (id != null) {
                        this.evict(id, collectionDescriptor, session);
                    }
                    if (oldId == null) continue;
                    this.evict(oldId, collectionDescriptor, session);
                    continue;
                }
                LOG.debug((Object)("Evict CollectionRegion " + collectionDescriptor.getNavigableRole().getFullPath()));
                SoftLock softLock = cacheAccess.lockRegion();
                session.getActionQueue().registerProcess((success, session1) -> cacheAccess.unlockRegion(softLock));
            }
        }
        catch (Exception e) {
            if (PROPAGATE_EXCEPTION) {
                throw new IllegalStateException(e);
            }
            LOG.error((Object)"", (Throwable)e);
        }
    }

    private Object getIdentifier(EventSource session, Object obj) {
        Object id = null;
        if (obj != null && (id = session.getContextEntityIdentifier(obj)) == null) {
            id = session.getSessionFactory().getMetamodel().getEntityDescriptor(obj.getClass()).getIdentifier(obj);
        }
        return id;
    }

    private void evict(Object id, PersistentCollectionDescriptor collectionDescriptor, EventSource session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Evict CollectionRegion " + collectionDescriptor.getNavigableRole().getFullPath() + " for id " + id));
        }
        AfterTransactionCompletionProcess afterTransactionProcess = new CollectionEvictCacheAction(collectionDescriptor, null, id, session).lockCache();
        session.getActionQueue().registerProcess(afterTransactionProcess);
    }

    private static final class CollectionEvictCacheAction
    extends CollectionAction {
        protected CollectionEvictCacheAction(PersistentCollectionDescriptor collectionDescriptor, PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
            super(collectionDescriptor, collection, key, session);
        }

        @Override
        public void execute() throws HibernateException {
        }

        public AfterTransactionCompletionProcess lockCache() {
            this.beforeExecutions();
            return this.getAfterTransactionCompletionProcess();
        }
    }
}

