/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import org.hibernate.cache.internal.CacheKeyImplementation;
import org.hibernate.cache.internal.NaturalIdCacheKey;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public class DefaultCacheKeysFactory
implements CacheKeysFactory {
    public static final String SHORT_NAME = "default";
    public static final DefaultCacheKeysFactory INSTANCE = new DefaultCacheKeysFactory();

    public static Object staticCreateEntityKey(Object id, EntityHierarchy entityHierarchy, SessionFactoryImplementor factory, String tenantIdentifier) {
        return new CacheKeyImplementation(id, entityHierarchy.getIdentifierDescriptor().getJavaTypeDescriptor(), entityHierarchy.getRootEntityType().getNavigableRole(), tenantIdentifier);
    }

    public static Object staticCreateCollectionKey(Object id, PersistentCollectionDescriptor descriptor, SessionFactoryImplementor factory, String tenantIdentifier) {
        return new CacheKeyImplementation(id, descriptor.getKeyJavaTypeDescriptor(), descriptor.getNavigableRole(), tenantIdentifier);
    }

    public static Object staticCreateNaturalIdKey(Object[] naturalIdValues, EntityHierarchy entityHierarchy, SharedSessionContractImplementor session) {
        return new NaturalIdCacheKey(naturalIdValues, entityHierarchy, session);
    }

    public static Object staticGetEntityId(Object cacheKey) {
        return ((CacheKeyImplementation)cacheKey).getId();
    }

    public static Object staticGetCollectionId(Object cacheKey) {
        return ((CacheKeyImplementation)cacheKey).getId();
    }

    public static Object[] staticGetNaturalIdValues(Object cacheKey) {
        return ((NaturalIdCacheKey)cacheKey).getNaturalIdValues();
    }

    @Override
    public Object createCollectionKey(Object id, PersistentCollectionDescriptor descriptor, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.staticCreateCollectionKey(id, descriptor, factory, tenantIdentifier);
    }

    @Override
    public Object createEntityKey(Object id, EntityHierarchy entityHierarchy, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.staticCreateEntityKey(id, entityHierarchy, factory, tenantIdentifier);
    }

    @Override
    public Object createNaturalIdKey(Object[] naturalIdValues, EntityHierarchy entityHierarchy, SharedSessionContractImplementor session) {
        return DefaultCacheKeysFactory.staticCreateNaturalIdKey(naturalIdValues, entityHierarchy, session);
    }

    @Override
    public Object getEntityId(Object cacheKey) {
        return DefaultCacheKeysFactory.staticGetEntityId(cacheKey);
    }

    @Override
    public Object getCollectionId(Object cacheKey) {
        return DefaultCacheKeysFactory.staticGetCollectionId(cacheKey);
    }

    @Override
    public Object[] getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.staticGetNaturalIdValues(cacheKey);
    }
}

