/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.NaturalIdDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.EntityJavaDescriptor;

public class NaturalIdCacheKey
implements Serializable {
    private final Serializable[] naturalIdValues;
    private final String entityName;
    private final String tenantId;
    private final int hashCode;
    private transient ValueHolder<String> toString;

    public NaturalIdCacheKey(Object[] naturalIdValues, EntityHierarchy entityHierarchy, SharedSessionContractImplementor session) {
        if (naturalIdValues.length != entityHierarchy.getNaturalIdDescriptor().getAttributeInfos().size()) {
            throw new HibernateException(String.format("Number of natural-id values [%s] did not match the number of mapped natural-id attributes [%s]", naturalIdValues.length, entityHierarchy.getNaturalIdDescriptor().getAttributeInfos().size()));
        }
        this.entityName = entityHierarchy.getRootEntityType().getEntityName();
        this.tenantId = session.getTenantIdentifier();
        this.naturalIdValues = new Serializable[naturalIdValues.length];
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entityName == null ? 0 : this.entityName.hashCode());
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        List<NaturalIdDescriptor.NaturalIdAttributeInfo> persistentAttributes = entityHierarchy.getNaturalIdDescriptor().getAttributeInfos();
        for (int i = 0; i < naturalIdValues.length; ++i) {
            Object value = naturalIdValues[i];
            JavaTypeDescriptor javaTypeDescriptor = persistentAttributes.get(i).getUnderlyingAttributeDescriptor().getJavaTypeDescriptor();
            result = 31 * result + (value != null ? javaTypeDescriptor.extractHashCode(value) : 0);
            this.naturalIdValues[i] = EntityJavaDescriptor.class.isInstance(javaTypeDescriptor) && !javaTypeDescriptor.getJavaType().isInstance(value) ? (Serializable)value : javaTypeDescriptor.getMutabilityPlan().disassemble(value);
        }
        this.hashCode = result;
        this.initTransients();
    }

    private void initTransients() {
        this.toString = new ValueHolder<1>(new ValueHolder.DeferredInitializer<String>(){

            @Override
            public String initialize() {
                StringBuilder toStringBuilder = new StringBuilder().append(NaturalIdCacheKey.this.entityName).append("##NaturalId[");
                for (int i = 0; i < NaturalIdCacheKey.this.naturalIdValues.length; ++i) {
                    toStringBuilder.append(NaturalIdCacheKey.this.naturalIdValues[i]);
                    if (i + 1 >= NaturalIdCacheKey.this.naturalIdValues.length) continue;
                    toStringBuilder.append(", ");
                }
                toStringBuilder.append("]");
                return toStringBuilder.toString();
            }
        });
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Serializable[] getNaturalIdValues() {
        return this.naturalIdValues;
    }

    public String toString() {
        return this.toString.getValue();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.hashCode != o.hashCode() || !(o instanceof NaturalIdCacheKey)) {
            return false;
        }
        NaturalIdCacheKey other = (NaturalIdCacheKey)o;
        return Objects.equals(this.entityName, other.entityName) && Objects.equals(this.tenantId, other.tenantId) && Arrays.deepEquals(this.naturalIdValues, other.naturalIdValues);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.initTransients();
    }
}

