/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.service.spi.ServiceException;
import org.jboss.logging.Logger;

public class StrategyCreatorRegionFactoryImpl<R extends RegionFactory>
implements Function<Class<R>, R> {
    private static final Logger log = Logger.getLogger(StrategyCreatorRegionFactoryImpl.class);
    private final Properties properties;

    public StrategyCreatorRegionFactoryImpl(Properties properties) {
        this.properties = properties;
    }

    @Override
    public R apply(Class<R> strategyClass) {
        assert (RegionFactory.class.isAssignableFrom(strategyClass));
        try {
            Constructor<R> ctor = strategyClass.getConstructor(Properties.class);
            return (R)((RegionFactory)ctor.newInstance(this.properties));
        }
        catch (NoSuchMethodException e) {
            log.debugf("RegionFactory impl [%s] did not provide constructor accepting Properties", (Object)strategyClass.getName());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ServiceException("Unable to call constructor of RegionFactory impl [" + strategyClass.getName() + "]", e);
        }
        try {
            Constructor<R> ctor = strategyClass.getConstructor(Map.class);
            return (R)((RegionFactory)ctor.newInstance(this.properties));
        }
        catch (NoSuchMethodException e) {
            log.debugf("RegionFactory impl [%s] did not provide constructor accepting Properties", (Object)strategyClass.getName());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ServiceException("Unable to call constructor of RegionFactory impl [" + strategyClass.getName() + "]", e);
        }
        try {
            return (R)((RegionFactory)strategyClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServiceException("Unable to call constructor of RegionFactory impl [" + strategyClass.getName() + "]", e);
        }
    }
}

