/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.CollectionDataCachingConfig;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.cfg.spi.EntityDataCachingConfig;
import org.hibernate.cache.cfg.spi.NaturalIdDataCachingConfig;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public abstract class AbstractDomainDataRegion
implements DomainDataRegion {
    private final String name;
    private final SessionFactoryImplementor sessionFactory;
    private final RegionFactory regionFactory;
    private final Map<NavigableRole, EntityDataAccess> entityDataAccessMap;
    private final Map<NavigableRole, NaturalIdDataAccess> naturalIdDataAccessMap;
    private final Map<NavigableRole, CollectionDataAccess> collectionDataAccessMap;

    public AbstractDomainDataRegion(DomainDataRegionConfig regionConfig, RegionFactory regionFactory, DomainDataRegionBuildingContext buildingContext) {
        this.name = regionConfig.getRegionName();
        this.sessionFactory = buildingContext.getSessionFactory();
        this.regionFactory = regionFactory;
        this.entityDataAccessMap = this.generateEntityDataAccessMap(regionConfig);
        this.naturalIdDataAccessMap = this.generateNaturalIdDataAccessMap(regionConfig);
        this.collectionDataAccessMap = this.generateCollectionDataAccessMap(regionConfig);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public RegionFactory getRegionFactory() {
        return this.regionFactory;
    }

    @Override
    public EntityDataAccess getEntityDataAccess(NavigableRole rootEntityRole) {
        EntityHierarchy entityHierarchy = this.sessionFactory.getMetamodel().findEntityDescriptor(rootEntityRole.getFullPath()).getHierarchy();
        EntityDataAccess access = this.entityDataAccessMap.get(entityHierarchy);
        if (access == null) {
            // empty if block
        }
        return access;
    }

    @Override
    public NaturalIdDataAccess getNaturalIdDataAccess(NavigableRole rootEntityRole) {
        EntityHierarchy entityHierarchy = this.sessionFactory.getMetamodel().findEntityDescriptor(rootEntityRole.getFullPath()).getHierarchy();
        NaturalIdDataAccess access = this.naturalIdDataAccessMap.get(entityHierarchy);
        if (access == null) {
            // empty if block
        }
        return access;
    }

    @Override
    public CollectionDataAccess getCollectionDataAccess(NavigableRole collectionRole) {
        PersistentCollectionDescriptor collectionDescriptor = this.sessionFactory.getMetamodel().findCollectionDescriptor(collectionRole.getFullPath());
        CollectionDataAccess access = this.collectionDataAccessMap.get(collectionDescriptor);
        if (access == null) {
            // empty if block
        }
        return access;
    }

    protected abstract EntityDataAccess generateEntityAccess(EntityDataCachingConfig var1);

    protected abstract CollectionDataAccess generateCollectionAccess(CollectionDataCachingConfig var1);

    protected abstract NaturalIdDataAccess generateNaturalIdAccess(NaturalIdDataCachingConfig var1);

    private Map<NavigableRole, EntityDataAccess> generateEntityDataAccessMap(DomainDataRegionConfig regionConfig) {
        if (regionConfig.getEntityCaching().isEmpty()) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<NavigableRole, EntityDataAccess> accessMap = new ConcurrentHashMap<NavigableRole, EntityDataAccess>();
        for (EntityDataCachingConfig entityAccessConfig : regionConfig.getEntityCaching()) {
            accessMap.computeIfAbsent(entityAccessConfig.getNavigableRole(), hierarchy -> this.generateEntityAccess(entityAccessConfig));
        }
        return Collections.unmodifiableMap(accessMap);
    }

    private Map<NavigableRole, NaturalIdDataAccess> generateNaturalIdDataAccessMap(DomainDataRegionConfig regionConfig) {
        if (regionConfig.getNaturalIdCaching().isEmpty()) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<NavigableRole, NaturalIdDataAccess> accessMap = new ConcurrentHashMap<NavigableRole, NaturalIdDataAccess>();
        for (NaturalIdDataCachingConfig naturalIdAccessConfig : regionConfig.getNaturalIdCaching()) {
            accessMap.computeIfAbsent(naturalIdAccessConfig.getNavigableRole(), hierarchy -> this.generateNaturalIdAccess(naturalIdAccessConfig));
        }
        return Collections.unmodifiableMap(accessMap);
    }

    private Map<NavigableRole, CollectionDataAccess> generateCollectionDataAccessMap(DomainDataRegionConfig regionConfig) {
        if (regionConfig.getNaturalIdCaching().isEmpty()) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<NavigableRole, CollectionDataAccess> accessMap = new ConcurrentHashMap<NavigableRole, CollectionDataAccess>();
        for (CollectionDataCachingConfig cachingConfig : regionConfig.getCollectionCaching()) {
            accessMap.computeIfAbsent(cachingConfig.getNavigableRole(), hierarchy -> this.generateCollectionAccess(cachingConfig));
        }
        return Collections.unmodifiableMap(accessMap);
    }

    protected void releaseDataAccess(EntityDataAccess cacheAccess) {
        if (Destructible.class.isInstance(cacheAccess)) {
            ((Destructible)((Object)cacheAccess)).destroy();
        }
    }

    protected void releaseDataAccess(NaturalIdDataAccess cacheAccess) {
        if (Destructible.class.isInstance(cacheAccess)) {
            ((Destructible)((Object)cacheAccess)).destroy();
        }
    }

    protected void releaseDataAccess(CollectionDataAccess cacheAccess) {
        if (Destructible.class.isInstance(cacheAccess)) {
            ((Destructible)((Object)cacheAccess)).destroy();
        }
    }

    @Override
    public void destroy() throws CacheException {
        for (EntityDataAccess entityDataAccess : this.entityDataAccessMap.values()) {
            this.releaseDataAccess(entityDataAccess);
        }
        for (NaturalIdDataAccess naturalIdDataAccess : this.naturalIdDataAccessMap.values()) {
            this.releaseDataAccess(naturalIdDataAccess);
        }
        for (CollectionDataAccess collectionDataAccess : this.collectionDataAccessMap.values()) {
            this.releaseDataAccess(collectionDataAccess);
        }
    }

    public static interface Destructible {
        public void destroy();
    }
}

