/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi.entry;

import java.io.Serializable;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public class CollectionCacheEntry
implements Serializable {
    private final Serializable state;

    public CollectionCacheEntry(PersistentCollection collection, PersistentCollectionDescriptor collectionDescriptor) {
        this.state = collection.disassemble(collectionDescriptor);
    }

    CollectionCacheEntry(Serializable state) {
        this.state = state;
    }

    public Serializable[] getState() {
        return (Serializable[])this.state;
    }

    public void assemble(PersistentCollection collection, PersistentCollectionDescriptor collectionDescriptor, Object owner) {
        collection.initializeFromCache(this.state, owner, collectionDescriptor);
        collection.afterInitialize();
    }

    public String toString() {
        return "CollectionCacheEntry" + ArrayHelper.toString(this.getState());
    }
}

