/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi.support;

import org.hibernate.cache.cfg.spi.CollectionDataCachingConfig;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.support.AbstractCachedDomainDataAccess;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public abstract class AbstractCollectionDataAccess
extends AbstractCachedDomainDataAccess
implements CollectionDataAccess {
    private final CacheKeysFactory keysFactory;

    public AbstractCollectionDataAccess(DomainDataRegion region, CacheKeysFactory keysFactory, DomainDataStorageAccess storageAccess, CollectionDataCachingConfig config) {
        super(region, storageAccess);
        this.keysFactory = keysFactory;
    }

    @Override
    public Object generateCacheKey(Object id, PersistentCollectionDescriptor descriptor, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.keysFactory.createCollectionKey(id, descriptor, factory, tenantIdentifier);
    }

    @Override
    public Object getCacheKeyId(Object cacheKey) {
        return this.keysFactory.getCollectionId(cacheKey);
    }

    @Override
    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) {
        return null;
    }

    @Override
    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) {
    }

    @Override
    public SoftLock lockRegion() {
        return null;
    }

    @Override
    public void unlockRegion(SoftLock lock) {
        this.clearCache();
    }
}

