/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.jboss.logging.Logger;

public class CopyIdentifierComponentSecondPass
implements SecondPass {
    private static final Logger log = Logger.getLogger(CopyIdentifierComponentSecondPass.class);
    private final String referencedEntityName;
    private final Component component;
    private final MetadataBuildingContext buildingContext;
    private final Ejb3JoinColumn[] joinColumns;

    public CopyIdentifierComponentSecondPass(Component comp, String referencedEntityName, Ejb3JoinColumn[] joinColumns, MetadataBuildingContext buildingContext) {
        this.component = comp;
        this.referencedEntityName = referencedEntityName;
        this.buildingContext = buildingContext;
        this.joinColumns = joinColumns;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        Ejb3JoinColumn joinColumn;
        String referencedColumnName;
        PersistentClass referencedPersistentClass = persistentClasses.get(this.referencedEntityName);
        if (referencedPersistentClass == null) {
            throw new AnnotationException("Unknown entity name: " + this.referencedEntityName);
        }
        if (!(referencedPersistentClass.getIdentifier() instanceof Component)) {
            throw new AssertionFailure("Unexpected identifier type on the referenced entity when mapping a @MapsId: " + this.referencedEntityName);
        }
        Component referencedComponent = (Component)referencedPersistentClass.getIdentifier();
        boolean isExplicitReference = true;
        HashMap<String, Ejb3JoinColumn> columnByReferencedName = new HashMap<String, Ejb3JoinColumn>(this.joinColumns.length);
        Ejb3JoinColumn[] ejb3JoinColumnArray = this.joinColumns;
        int n = ejb3JoinColumnArray.length;
        for (int i = 0; i < n && (referencedColumnName = (joinColumn = ejb3JoinColumnArray[i]).getReferencedColumn()) != null && !BinderHelper.isEmptyAnnotationValue(referencedColumnName); ++i) {
            columnByReferencedName.put(referencedColumnName.toLowerCase(Locale.ROOT), joinColumn);
        }
        AtomicInteger index = new AtomicInteger(0);
        if (columnByReferencedName.isEmpty()) {
            isExplicitReference = false;
            for (Ejb3JoinColumn joinColumn2 : this.joinColumns) {
                columnByReferencedName.put("" + index.get(), joinColumn2);
                index.getAndIncrement();
            }
            index.set(0);
        }
        List<PersistentAttributeMapping> declaredPersistentAttributes = referencedComponent.getDeclaredPersistentAttributes();
        for (PersistentAttributeMapping referencedMapping : declaredPersistentAttributes) {
            Property property;
            if (referencedMapping instanceof Component) {
                property = this.createComponentProperty(isExplicitReference, columnByReferencedName, index, referencedMapping);
                this.component.addDeclaredPersistentAttribute(property);
                continue;
            }
            property = this.createSimpleProperty(referencedPersistentClass, isExplicitReference, columnByReferencedName, index, referencedMapping);
            this.component.addDeclaredPersistentAttribute(property);
        }
    }

    private Property createComponentProperty(boolean isExplicitReference, Map<String, Ejb3JoinColumn> columnByReferencedName, AtomicInteger index, PersistentAttributeMapping referencedProperty) {
        Property property = new Property(this.buildingContext);
        property.setName(referencedProperty.getName());
        property.setPersistentClass(this.component.getOwner());
        property.setPropertyAccessorName(referencedProperty.getPropertyAccessorName());
        Component value = new Component(this.buildingContext, this.component.getOwner());
        property.setValue(value);
        Component referencedValue = (Component)referencedProperty.getValueMapping();
        value.setExplicitTypeName(referencedValue.getTypeName());
        value.setTypeParameters(referencedValue.getTypeParameters());
        value.setComponentClassName(referencedValue.getEmbeddableClassName());
        List<PersistentAttributeMapping> declaredPersistentAttributes = referencedValue.getDeclaredPersistentAttributes();
        for (PersistentAttributeMapping referencedComponentProperty : declaredPersistentAttributes) {
            Property componentProperty;
            if (referencedComponentProperty instanceof Component) {
                componentProperty = this.createComponentProperty(isExplicitReference, columnByReferencedName, index, referencedComponentProperty);
                value.addDeclaredPersistentAttribute(componentProperty);
                continue;
            }
            componentProperty = this.createSimpleProperty(referencedValue.getOwner(), isExplicitReference, columnByReferencedName, index, referencedComponentProperty);
            value.addDeclaredPersistentAttribute(componentProperty);
        }
        return property;
    }

    private Property createSimpleProperty(PersistentClass referencedPersistentClass, boolean isExplicitReference, Map<String, Ejb3JoinColumn> columnByReferencedName, AtomicInteger index, PersistentAttributeMapping referencedProperty) {
        Property property = new Property(this.buildingContext);
        property.setName(referencedProperty.getName());
        property.setPersistentClass(this.component.getOwner());
        property.setPropertyAccessorName(referencedProperty.getPropertyAccessorName());
        BasicValue referencedValue = (BasicValue)referencedProperty.getValueMapping();
        DependantValue value = new DependantValue(this.buildingContext, this.component.getMappedTable(), (KeyValue)referencedValue);
        property.setValue(value);
        value.setExplicitTypeName(referencedValue.getTypeName());
        value.setTypeParameters(referencedValue.getTypeParameters());
        List<MappedColumn> mappedColumns = referencedValue.getMappedColumns();
        if (this.joinColumns[0].isNameDeferred()) {
            this.joinColumns[0].copyReferencedStructureAndCreateDefaultJoinColumns(referencedPersistentClass, mappedColumns, (SimpleValue)value);
        } else {
            mappedColumns.forEach(selectable -> {
                if (Column.class.isInstance(selectable)) {
                    Ejb3JoinColumn joinColumn;
                    String columnName;
                    Column column = (Column)selectable;
                    String logicalColumnName = null;
                    if (isExplicitReference) {
                        columnName = column.getText();
                        joinColumn = (Ejb3JoinColumn)columnByReferencedName.get(columnName.toLowerCase(Locale.ROOT));
                    } else {
                        joinColumn = (Ejb3JoinColumn)columnByReferencedName.get("" + index.get());
                        index.getAndIncrement();
                    }
                    if (joinColumn == null && !this.joinColumns[0].isNameDeferred()) {
                        throw new AnnotationException(isExplicitReference ? "Unable to find column reference in the @MapsId mapping: " + logicalColumnName : "Implicit column reference in the @MapsId mapping fails, try to use explicit referenceColumnNames: " + this.referencedEntityName);
                    }
                    String string = columnName = joinColumn == null || joinColumn.isNameDeferred() ? "tata_" + column.getName() : joinColumn.getName();
                    if (joinColumn != null) {
                        this.applyComponentColumnValuesToJoinColumn(column, joinColumn);
                        joinColumn.linkWithValue(value);
                    } else {
                        Column valueColumn = new Column(value.getMappedTable().getNameIdentifier(), columnName, false);
                        value.addColumn(valueColumn);
                    }
                } else {
                    log.debug((Object)"Encountered formula definition; skipping");
                }
            });
        }
        return property;
    }

    private void applyComponentColumnValuesToJoinColumn(Column column, Ejb3JoinColumn joinColumn) {
        Column mappingColumn = joinColumn.getMappingColumn();
        mappingColumn.setLength(column.getLength());
        mappingColumn.setPrecision(column.getPrecision());
        mappingColumn.setScale(column.getScale());
        mappingColumn.setNullable(column.isNullable());
    }

    public boolean dependentUpon(CopyIdentifierComponentSecondPass other) {
        return this.referencedEntityName.equals(other.component.getOwner().getEntityName());
    }
}

