/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedIndex;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.model.relational.MappedUniqueKey;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.naming.Identifier;

public class IndexOrUniqueKeySecondPass
implements SecondPass {
    private MappedTable table;
    private final String indexName;
    private final String[] columns;
    private final MetadataBuildingContext buildingContext;
    private final Ejb3Column column;
    private final boolean unique;

    public IndexOrUniqueKeySecondPass(MappedTable table, String indexName, String[] columns, MetadataBuildingContext buildingContext) {
        this.table = table;
        this.indexName = indexName;
        this.columns = columns;
        this.buildingContext = buildingContext;
        this.column = null;
        this.unique = false;
    }

    public IndexOrUniqueKeySecondPass(String indexName, Ejb3Column column, MetadataBuildingContext buildingContext) {
        this(indexName, column, buildingContext, false);
    }

    public IndexOrUniqueKeySecondPass(String indexName, Ejb3Column column, MetadataBuildingContext buildingContext, boolean unique) {
        this.indexName = indexName;
        this.column = column;
        this.columns = null;
        this.buildingContext = buildingContext;
        this.unique = unique;
    }

    public void doSecondPass(Map persistentClasses) throws MappingException {
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.addConstraintToColumn(this.columns[i]);
            }
        }
        if (this.column != null) {
            this.table = this.column.getTable();
            PropertyHolder propertyHolder = this.column.getPropertyHolder();
            String entityName = propertyHolder.isComponent() ? propertyHolder.getPersistentClass().getEntityName() : propertyHolder.getEntityName();
            PersistentClass persistentClass = (PersistentClass)persistentClasses.get(entityName);
            Property property = persistentClass.getProperty(this.column.getPropertyName());
            if (property.getValue() instanceof Component) {
                Component component = (Component)property.getValue();
                List<Column> columns = component.getMappedColumns().stream().filter(Column.class::isInstance).map(Column.class::cast).collect(Collectors.toList());
                this.addConstraintToColumns(columns);
            } else {
                this.addConstraintToColumn(this.column.getMappingColumn().getQuotedName());
            }
        }
    }

    private void addConstraintToColumn(String columnName) {
        Object column = this.table.getColumn(Identifier.toIdentifier(columnName));
        if (column == null) {
            throw new AnnotationException("@Index references a unknown column: " + columnName);
        }
        if (this.unique) {
            this.table.getOrCreateUniqueKey(this.indexName).addColumn((MappedColumn)column);
        } else {
            this.table.getOrCreateIndex(this.indexName).addColumn((Column)column);
        }
    }

    private void addConstraintToColumns(List<Column> columns) {
        if (this.unique) {
            MappedUniqueKey uniqueKey = this.table.getOrCreateUniqueKey(this.indexName);
            for (Column column : columns) {
                uniqueKey.addColumn(column);
            }
        } else {
            MappedIndex index = this.table.getOrCreateIndex(this.indexName);
            for (Column column : columns) {
                index.addColumn(column);
            }
        }
    }
}

