/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import java.util.Optional;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.PrimaryKeyJoinColumn;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.LazyGroup;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.ToOneBinder;
import org.hibernate.cfg.ToOneFkSecondPass;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.type.ForeignKeyDirection;

public class OneToOneSecondPass
implements SecondPass {
    private MetadataBuildingContext buildingContext;
    private String mappedBy;
    private String ownerEntity;
    private String ownerProperty;
    private PropertyHolder propertyHolder;
    private boolean ignoreNotFound;
    private PropertyData inferredData;
    private XClass targetEntity;
    private boolean cascadeOnDelete;
    private boolean optional;
    private String cascadeStrategy;
    private Ejb3JoinColumn[] joinColumns;

    public OneToOneSecondPass(String mappedBy, String ownerEntity, String ownerProperty, PropertyHolder propertyHolder, PropertyData inferredData, XClass targetEntity, boolean ignoreNotFound, boolean cascadeOnDelete, boolean optional, String cascadeStrategy, Ejb3JoinColumn[] columns, MetadataBuildingContext buildingContext) {
        this.ownerEntity = ownerEntity;
        this.ownerProperty = ownerProperty;
        this.mappedBy = mappedBy;
        this.propertyHolder = propertyHolder;
        this.buildingContext = buildingContext;
        this.ignoreNotFound = ignoreNotFound;
        this.inferredData = inferredData;
        this.targetEntity = targetEntity;
        this.cascadeOnDelete = cascadeOnDelete;
        this.optional = optional;
        this.cascadeStrategy = cascadeStrategy;
        this.joinColumns = columns;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        OneToOne value = new OneToOne(this.buildingContext, this.propertyHolder.getMappedTable(), this.propertyHolder.getPersistentClass());
        String propertyName = this.inferredData.getPropertyName();
        value.setPropertyName(propertyName);
        String referencedEntityName = ToOneBinder.getReferenceEntityName(this.inferredData, this.targetEntity, this.buildingContext);
        value.setReferencedEntityName(referencedEntityName);
        AnnotationBinder.defineFetchingStrategy(value, this.inferredData.getProperty());
        value.setCascadeDeleteEnabled(this.cascadeOnDelete);
        value.setConstrained(!this.optional);
        ForeignKeyDirection foreignKeyDirection = !BinderHelper.isEmptyAnnotationValue(this.mappedBy) ? ForeignKeyDirection.TO_PARENT : ForeignKeyDirection.FROM_PARENT;
        value.setForeignKeyType(foreignKeyDirection);
        PrimaryKeyJoinColumn primaryKeyJoinColumn = (PrimaryKeyJoinColumn)this.inferredData.getProperty().getAnnotation(PrimaryKeyJoinColumn.class);
        if (primaryKeyJoinColumn != null) {
            value.setConstrained(true);
            PersistentClass otherSide = persistentClasses.get(value.getReferencedEntityName());
            value.setReferencedPropertyName(otherSide.getRootClass().getIdentifierAttributeMapping().getName());
        }
        AnnotationBinder.bindForeignKeyNameAndDefinition(value, this.inferredData.getProperty(), (ForeignKey)this.inferredData.getProperty().getAnnotation(ForeignKey.class), (JoinColumn)this.inferredData.getProperty().getAnnotation(JoinColumn.class), (JoinColumns)this.inferredData.getProperty().getAnnotation(JoinColumns.class));
        PropertyBinder binder = new PropertyBinder();
        binder.setName(propertyName);
        binder.setValue(value);
        binder.setCascade(this.cascadeStrategy);
        binder.setAccessType(this.inferredData.getDefaultAccess());
        LazyGroup lazyGroupAnnotation = (LazyGroup)this.inferredData.getProperty().getAnnotation(LazyGroup.class);
        if (lazyGroupAnnotation != null) {
            binder.setLazyGroup(lazyGroupAnnotation.value());
        }
        Property prop = binder.makeProperty();
        prop.setOptional(this.optional);
        if (BinderHelper.isEmptyAnnotationValue(this.mappedBy)) {
            boolean rightOrder = true;
            if (rightOrder) {
                String path = StringHelper.qualify(this.propertyHolder.getPath(), propertyName);
                ToOneFkSecondPass secondPass = new ToOneFkSecondPass(value, this.joinColumns, !this.optional, this.propertyHolder.getEntityOwnerClassName(), path, this.buildingContext);
                secondPass.doSecondPass((Map)persistentClasses);
                this.propertyHolder.addProperty(prop, this.inferredData.getDeclaringClass());
            }
        } else {
            Property otherSideProperty;
            PersistentClass otherSide = persistentClasses.get(value.getReferencedEntityName());
            try {
                if (otherSide == null) {
                    throw new MappingException("Unable to find entity: " + value.getReferencedEntityName());
                }
                otherSideProperty = BinderHelper.findPropertyByName(otherSide, this.mappedBy);
            }
            catch (MappingException e) {
                throw new AnnotationException("Unknown mappedBy in: " + StringHelper.qualify(this.ownerEntity, this.ownerProperty) + ", referenced property unknown: " + StringHelper.qualify(value.getReferencedEntityName(), this.mappedBy));
            }
            if (otherSideProperty == null) {
                throw new AnnotationException("Unknown mappedBy in: " + StringHelper.qualify(this.ownerEntity, this.ownerProperty) + ", referenced property unknown: " + StringHelper.qualify(value.getReferencedEntityName(), this.mappedBy));
            }
            prop.setMappedBy(this.mappedBy);
            if (otherSideProperty.getValue() instanceof OneToOne) {
                this.propertyHolder.addProperty(prop, this.inferredData.getDeclaringClass());
            } else if (otherSideProperty.getValue() instanceof ManyToOne) {
                String propertyRef;
                Optional<Join> otherSideJoin = otherSide.getJoins().stream().filter(otherSideJoinValue -> otherSideJoinValue.containsPersistentAttributeMapping(otherSideProperty)).findFirst();
                if (otherSideJoin.isPresent()) {
                    Join mappedByJoin = this.buildJoinFromMappedBySide(persistentClasses.get(this.ownerEntity), otherSideProperty, otherSideJoin.get());
                    ManyToOne manyToOne = new ManyToOne(this.buildingContext, mappedByJoin.getMappedTable());
                    manyToOne.setIgnoreNotFound(this.ignoreNotFound);
                    manyToOne.setCascadeDeleteEnabled(value.isCascadeDeleteEnabled());
                    manyToOne.setFetchMode(value.getFetchMode());
                    manyToOne.setLazy(value.isLazy());
                    manyToOne.setReferencedEntityName(value.getReferencedEntityName());
                    manyToOne.setUnwrapProxy(value.isUnwrapProxy());
                    prop.setValue(manyToOne);
                    otherSideJoin.get().getKey().getMappedColumns().forEach(column -> manyToOne.addColumn(((Column)column).clone()));
                    manyToOne.createForeignKey();
                    mappedByJoin.addProperty(prop);
                } else {
                    this.propertyHolder.addProperty(prop, this.inferredData.getDeclaringClass());
                }
                value.setReferencedPropertyName(this.mappedBy);
                boolean referencesDerivedId = false;
                try {
                    referencesDerivedId = otherSide.getIdentifier() instanceof Component && ((Component)otherSide.getIdentifier()).getDeclaredPersistentAttribute(this.mappedBy) != null;
                }
                catch (MappingException manyToOne) {
                    // empty catch block
                }
                boolean referenceToPrimaryKey = referencesDerivedId || this.mappedBy == null;
                value.setReferenceToPrimaryKey(referenceToPrimaryKey);
                if (referencesDerivedId) {
                    ((ManyToOne)otherSideProperty.getValue()).setReferenceToPrimaryKey(false);
                }
                if ((propertyRef = value.getReferencedPropertyName()) != null) {
                    this.buildingContext.getMetadataCollector().addUniquePropertyReference(value.getReferencedEntityName(), propertyRef);
                }
            } else {
                throw new AnnotationException("Referenced property not a (One|Many)ToOne: " + StringHelper.qualify(otherSide.getEntityName(), this.mappedBy) + " in mappedBy of " + StringHelper.qualify(this.ownerEntity, this.ownerProperty));
            }
        }
    }

    private Join buildJoinFromMappedBySide(PersistentClass persistentClass, Property otherSideProperty, Join originalJoin) {
        Join join = new Join();
        join.setPersistentClass(persistentClass);
        join.setTable(originalJoin.getMappedTable());
        join.setInverse(true);
        DependantValue key = new DependantValue(this.buildingContext, join.getMappedTable(), persistentClass.getIdentifier());
        join.setKey(key);
        join.setSequentialSelect(false);
        join.setOptional(true);
        key.setCascadeDeleteEnabled(false);
        otherSideProperty.getValue().getMappedColumns().forEach(column -> key.addColumn(((Column)column).clone()));
        persistentClass.addJoin(join);
        join.createForeignKey();
        return join;
    }
}

