/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyTemporal;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.AssertionFailure;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.annotations.JavaTypeDescriptor;
import org.hibernate.annotations.MapKeyType;
import org.hibernate.annotations.Nationalized;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SqlType;
import org.hibernate.annotations.SqlTypeDescriptor;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.cfg.SetSimpleValueTypeSecondPass;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Table;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class BasicValueBinder<T>
implements SqlTypeDescriptorIndicators {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BasicValueBinder.class.getName());
    private final Kind kind;
    private final MetadataBuildingContext buildingContext;
    private String explicitBasicTypeName;
    private Map explicitLocalTypeParams;
    private Function<TypeConfiguration, org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor> explicitSqlTypeAccess;
    private Function<TypeConfiguration, BasicJavaDescriptor<T>> explicitJavaTypeAccess;
    private Class<T> explicitJavaClass;
    private BasicJavaDescriptor<T> javaDescriptor;
    private ConverterDescriptor converterDescriptor;
    private boolean isNationalized;
    private boolean isLob;
    private EnumType enumType;
    private TemporalType temporalPrecision;
    private BasicValue basicValue;
    private Table table;
    private Ejb3Column[] columns;
    private String referencedEntityName;
    private String propertyName;
    private String returnedClassName;
    private String persistentClassName;
    private String defaultType = "";
    private Properties typeParameters = new Properties();

    public BasicValueBinder(Kind kind, MetadataBuildingContext buildingContext) {
        assert (kind != null);
        assert (buildingContext != null);
        this.kind = kind;
        this.buildingContext = buildingContext;
    }

    @Override
    public EnumType getEnumeratedType() {
        return this.enumType;
    }

    @Override
    public boolean isLob() {
        return this.isLob;
    }

    @Override
    public TemporalType getTemporalPrecision() {
        return this.temporalPrecision;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.buildingContext.getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public boolean isNationalized() {
        return this.isNationalized;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.buildingContext.getBootstrapContext().getTypeConfiguration();
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public void setTimestampVersionType(String versionType) {
        throw new NotYetImplementedFor6Exception();
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
        if (this.defaultType.length() == 0) {
            this.defaultType = returnedClassName;
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Ejb3Column[] columns) {
        this.columns = columns;
    }

    public void setPersistentClassName(String persistentClassName) {
        this.persistentClassName = persistentClassName;
    }

    public void setType(XProperty navigableXProperty, XClass navigableXClass, String declaringClassName, ConverterDescriptor converterDescriptor) {
        boolean key;
        Class navigableJavaType;
        if (navigableXClass == null) {
            return;
        }
        if (this.columns == null) {
            throw new AssertionFailure("SimpleValueBinder.setColumns should be set before SimpleValueBinder.setType");
        }
        XClass returnedClassOrElement = navigableXClass;
        if (navigableXProperty.isArray()) {
            returnedClassOrElement = navigableXProperty.getElementClass();
        }
        if ((navigableJavaType = BasicValueBinder.resolveJavaType(returnedClassOrElement, this.buildingContext)) == null) {
            throw new IllegalStateException("BasicType requires Java type");
        }
        Properties typeParameters = this.typeParameters;
        typeParameters.clear();
        boolean isMap = Map.class.isAssignableFrom(this.buildingContext.getBootstrapContext().getReflectionManager().toClass(navigableXProperty.getType()));
        boolean bl = key = this.kind == Kind.COLLECTION_INDEX;
        if (!key) {
            this.isLob = navigableXProperty.isAnnotationPresent(Lob.class);
        }
        if (this.getDialect().supportsNationalizedTypes()) {
            this.isNationalized = navigableXProperty.isAnnotationPresent(Nationalized.class) || this.buildingContext.getBuildingOptions().useNationalizedCharacterData();
        }
        this.applyAttributeConverter(navigableXProperty, converterDescriptor, key);
        Type explicitTypeAnn = null;
        if (key) {
            MapKeyType mapKeyTypeAnn = (MapKeyType)navigableXProperty.getAnnotation(MapKeyType.class);
            if (mapKeyTypeAnn != null) {
                explicitTypeAnn = mapKeyTypeAnn.value();
            }
        } else {
            explicitTypeAnn = (Type)navigableXProperty.getAnnotation(Type.class);
        }
        if (explicitTypeAnn != null) {
            this.setExplicitType(explicitTypeAnn);
        } else {
            switch (this.kind) {
                case COLLECTION_ID: {
                    XClass valueClass = navigableXProperty.getClassOrElementClass();
                    this.explicitJavaClass = this.buildingContext.getBootstrapContext().getReflectionManager().toClass(valueClass);
                    break;
                }
                case COLLECTION_INDEX: {
                    if (isMap) {
                        this.prepareMapKey(navigableXProperty);
                        break;
                    }
                    this.prepareListIndex(navigableXProperty);
                    break;
                }
                case COLLECTION_ELEMENT: {
                    this.prepareCollectionElement(navigableXProperty, navigableXClass);
                    break;
                }
                default: {
                    assert (this.kind == Kind.ATTRIBUTE);
                    this.prepareBasicAttribute(navigableXProperty, navigableXClass);
                }
            }
        }
        this.typeParameters = typeParameters;
    }

    private void prepareMapKey(XProperty mapAttribute) {
        Class javaType;
        this.explicitJavaClass = javaType = this.buildingContext.getBootstrapContext().getReflectionManager().toClass(mapAttribute.getMapKey());
        this.javaDescriptor = (BasicJavaDescriptor)this.buildingContext.getBootstrapContext().getTypeConfiguration().getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(javaType);
        MapKeyType mapKeyTypeAnn = (MapKeyType)mapAttribute.getAnnotation(MapKeyType.class);
        if (mapKeyTypeAnn != null) {
            throw new NotYetImplementedException("see comment at throw site");
        }
        MapKeyTemporal mapKeyTemporalAnn = (MapKeyTemporal)mapAttribute.getAnnotation(MapKeyTemporal.class);
        this.temporalPrecision = mapKeyTemporalAnn != null ? mapKeyTemporalAnn.value() : null;
        if (javaType.isEnum()) {
            MapKeyEnumerated enumeratedAnn = (MapKeyEnumerated)mapAttribute.getAnnotation(MapKeyEnumerated.class);
            if (enumeratedAnn == null) {
                this.enumType = EnumType.ORDINAL;
            } else {
                this.enumType = enumeratedAnn.value();
                if (this.enumType == null) {
                    throw new IllegalStateException("javax.persistence.EnumType was null on @javax.persistence.MapKeyEnumerated  associated with attribute " + mapAttribute.getDeclaringClass().getName() + '.' + mapAttribute.getName());
                }
            }
        } else {
            this.enumType = null;
        }
        this.mapKeySupplementalDetails(mapAttribute, this.buildingContext);
    }

    private void prepareListIndex(XProperty listAttribute) {
        this.javaDescriptor = (BasicJavaDescriptor)this.buildingContext.getBootstrapContext().getTypeConfiguration().getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(Integer.class);
        this.explicitSqlTypeAccess = typeConfiguration -> this.javaDescriptor.getJdbcRecommendedSqlType(this);
    }

    private void prepareCollectionElement(XProperty attributeDescriptor, XClass elementJavaType) {
        Class javaClass;
        this.explicitJavaClass = javaClass = this.buildingContext.getBootstrapContext().getReflectionManager().toClass(elementJavaType);
        this.javaDescriptor = (BasicJavaDescriptor)this.buildingContext.getBootstrapContext().getTypeConfiguration().getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(javaClass);
        Temporal temporalAnn = (Temporal)attributeDescriptor.getAnnotation(Temporal.class);
        if (temporalAnn != null) {
            this.temporalPrecision = temporalAnn.value();
            if (this.temporalPrecision == null) {
                throw new IllegalStateException("No javax.persistence.TemporalType defined for @javax.persistence.Temporal associated with attribute " + attributeDescriptor.getDeclaringClass().getName() + '.' + attributeDescriptor.getName());
            }
        } else {
            this.temporalPrecision = null;
        }
        if (javaClass.isEnum()) {
            Enumerated enumeratedAnn = (Enumerated)attributeDescriptor.getAnnotation(Enumerated.class);
            if (enumeratedAnn == null) {
                this.enumType = EnumType.ORDINAL;
            } else {
                this.enumType = enumeratedAnn.value();
                if (this.enumType == null) {
                    throw new IllegalStateException("javax.persistence.EnumType was null on @javax.persistence.Enumerated  associated with attribute " + attributeDescriptor.getDeclaringClass().getName() + '.' + attributeDescriptor.getName());
                }
            }
        } else {
            this.enumType = null;
        }
        this.normalSupplementalDetails(attributeDescriptor, this.buildingContext);
    }

    private void prepareBasicAttribute(XProperty attributeDescriptor, XClass attributeType) {
        Class javaType = this.buildingContext.getBootstrapContext().getReflectionManager().toClass(attributeType);
        this.javaDescriptor = (BasicJavaDescriptor)this.buildingContext.getBootstrapContext().getTypeConfiguration().getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(javaType);
        Temporal temporalAnn = (Temporal)attributeDescriptor.getAnnotation(Temporal.class);
        if (temporalAnn != null) {
            this.temporalPrecision = temporalAnn.value();
            if (this.temporalPrecision == null) {
                throw new IllegalStateException("No javax.persistence.TemporalType defined for @javax.persistence.Temporal associated with attribute " + attributeDescriptor.getDeclaringClass().getName() + '.' + attributeDescriptor.getName());
            }
        } else {
            this.temporalPrecision = null;
        }
        if (javaType.isEnum()) {
            Enumerated enumeratedAnn = (Enumerated)attributeDescriptor.getAnnotation(Enumerated.class);
            if (enumeratedAnn == null) {
                this.enumType = EnumType.ORDINAL;
            } else {
                this.enumType = enumeratedAnn.value();
                if (this.enumType == null) {
                    throw new IllegalStateException("javax.persistence.EnumType was null on @javax.persistence.Enumerated  associated with attribute " + attributeDescriptor.getDeclaringClass().getName() + '.' + attributeDescriptor.getName());
                }
            }
        } else {
            this.enumType = null;
        }
        this.explicitSqlTypeAccess = typeConfiguration -> {
            SqlType sqlTypeAnn = (SqlType)attributeDescriptor.getAnnotation(SqlType.class);
            SqlTypeDescriptor sqlTypeDescriptorAnn = (SqlTypeDescriptor)attributeDescriptor.getAnnotation(SqlTypeDescriptor.class);
            if (sqlTypeAnn != null) {
                org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor descriptor = typeConfiguration.getSqlTypeDescriptorRegistry().getDescriptor(sqlTypeAnn.value());
                if (descriptor == null) {
                    // empty if block
                }
                return descriptor;
            }
            if (sqlTypeDescriptorAnn != null) {
                return typeConfiguration.getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(sqlTypeDescriptorAnn.value()).getBeanInstance();
            }
            return null;
        };
        this.explicitJavaTypeAccess = typeConfiguration -> {
            JavaTypeDescriptor jtdAnn = (JavaTypeDescriptor)attributeDescriptor.getAnnotation(JavaTypeDescriptor.class);
            if (jtdAnn == null) {
                return null;
            }
            return typeConfiguration.getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(jtdAnn.value()).getBeanInstance();
        };
        this.normalSupplementalDetails(attributeDescriptor, this.buildingContext);
    }

    private void mapKeySupplementalDetails(XProperty navigableXProperty, MetadataBuildingContext buildingContext) {
        MapKeyTemporal mapKeyTemporalAnn;
        MapKeyEnumerated mapKeyEnumeratedAnn = (MapKeyEnumerated)navigableXProperty.getAnnotation(MapKeyEnumerated.class);
        if (mapKeyEnumeratedAnn != null) {
            this.enumType = mapKeyEnumeratedAnn.value();
        }
        if ((mapKeyTemporalAnn = (MapKeyTemporal)navigableXProperty.getAnnotation(MapKeyTemporal.class)) != null) {
            this.temporalPrecision = mapKeyTemporalAnn.value();
        }
    }

    private void normalSupplementalDetails(XProperty navigableXProperty, MetadataBuildingContext buildingContext) {
        Temporal mapKeyTemporalAnn;
        Enumerated mapKeyEnumeratedAnn = (Enumerated)navigableXProperty.getAnnotation(Enumerated.class);
        if (mapKeyEnumeratedAnn != null) {
            this.enumType = mapKeyEnumeratedAnn.value();
        }
        if ((mapKeyTemporalAnn = (Temporal)navigableXProperty.getAnnotation(Temporal.class)) != null) {
            this.temporalPrecision = mapKeyTemporalAnn.value();
        }
    }

    private static Class resolveJavaType(XClass returnedClassOrElement, MetadataBuildingContext buildingContext) {
        return buildingContext.getBootstrapContext().getReflectionManager().toClass(returnedClassOrElement);
    }

    private Dialect getDialect() {
        return this.buildingContext.getBuildingOptions().getServiceRegistry().getService(JdbcServices.class).getJdbcEnvironment().getDialect();
    }

    private void applyAttributeConverter(XProperty property, ConverterDescriptor attributeConverterDescriptor, boolean key) {
        if (attributeConverterDescriptor == null) {
            return;
        }
        LOG.debugf("Starting applyAttributeConverter [%s:%s]", this.persistentClassName, property.getName());
        if (property.isAnnotationPresent(Id.class)) {
            LOG.debugf("Skipping AttributeConverter checks for Id attribute [%s]", property.getName());
            return;
        }
        if (property.isAnnotationPresent(Version.class)) {
            LOG.debugf("Skipping AttributeConverter checks for version attribute [%s]", property.getName());
            return;
        }
        if (!key && property.isAnnotationPresent(Temporal.class)) {
            LOG.debugf("Skipping AttributeConverter checks for Temporal attribute [%s]", property.getName());
            return;
        }
        if (key && property.isAnnotationPresent(MapKeyTemporal.class)) {
            LOG.debugf("Skipping AttributeConverter checks for map-key annotated as MapKeyTemporal [%s]", property.getName());
            return;
        }
        if (!key && property.isAnnotationPresent(Enumerated.class)) {
            LOG.debugf("Skipping AttributeConverter checks for Enumerated attribute [%s]", property.getName());
            return;
        }
        if (key && property.isAnnotationPresent(MapKeyEnumerated.class)) {
            LOG.debugf("Skipping AttributeConverter checks for map-key annotated as MapKeyEnumerated [%s]", property.getName());
            return;
        }
        if (this.isAssociation()) {
            LOG.debugf("Skipping AttributeConverter checks for association attribute [%s]", property.getName());
            return;
        }
        this.converterDescriptor = attributeConverterDescriptor;
    }

    private boolean isAssociation() {
        return this.referencedEntityName != null;
    }

    public void setExplicitType(String explicitType) {
        this.explicitBasicTypeName = explicitType;
    }

    public void setExplicitType(Type typeAnn) {
        this.setExplicitType(typeAnn.type());
        this.explicitLocalTypeParams = this.extractTypeParams(typeAnn.parameters());
    }

    private Map extractTypeParams(Parameter[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return Collections.emptyMap();
        }
        if (parameters.length == 1) {
            return Collections.singletonMap(parameters[0].name(), parameters[0].value());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter parameter : parameters) {
            map.put(parameter.name(), parameter.value());
        }
        return map;
    }

    private void validate() {
        Ejb3Column.checkPropertyConsistency(this.columns, this.propertyName);
    }

    public BasicValue make() {
        this.validate();
        LOG.debugf("building SimpleValue for %s", this.propertyName);
        if (this.table == null) {
            this.table = this.columns[0].getTable();
        }
        this.basicValue = new BasicValue(this.buildingContext, this.table);
        if (this.isNationalized) {
            this.basicValue.makeNationalized();
        }
        if (this.isLob) {
            this.basicValue.makeLob();
        }
        if (this.enumType != null) {
            this.basicValue.setEnumType(this.enumType);
        }
        if (this.temporalPrecision != null) {
            this.basicValue.setTemporalPrecision(this.temporalPrecision);
        }
        this.linkWithValue();
        boolean isInSecondPass = this.buildingContext.getMetadataCollector().isInSecondPass();
        if (!isInSecondPass) {
            this.buildingContext.getMetadataCollector().addSecondPass(new SetSimpleValueTypeSecondPass(this));
        } else {
            this.fillSimpleValue();
        }
        return this.basicValue;
    }

    public void linkWithValue() {
        if (this.columns[0].isNameDeferred() && !this.buildingContext.getMetadataCollector().isInSecondPass() && this.referencedEntityName != null) {
            this.buildingContext.getMetadataCollector().addSecondPass(new PkDrivenByDefaultMapsIdSecondPass(this.referencedEntityName, (Ejb3JoinColumn[])this.columns, this.basicValue));
        } else {
            for (Ejb3Column column : this.columns) {
                column.linkWithValue(this.basicValue);
            }
        }
    }

    public void fillSimpleValue() {
        LOG.debugf("Starting fillSimpleValue for %s", this.propertyName);
        if (this.enumType == null) {
            this.basicValue.setExplicitTypeName(this.explicitBasicTypeName);
        }
        this.basicValue.setExplicitTypeParams(this.explicitLocalTypeParams);
        this.basicValue.setEnumType(this.enumType);
        this.basicValue.setTemporalPrecision(this.temporalPrecision);
        if (this.isLob) {
            this.basicValue.makeLob();
        }
        if (this.isNationalized) {
            this.basicValue.makeNationalized();
        }
        this.basicValue.setExplicitJavaTypeAccess(this.explicitJavaTypeAccess);
        this.basicValue.setExplicitSqlTypeAccess(this.explicitSqlTypeAccess);
        this.basicValue.setJavaTypeDescriptor(this.javaDescriptor);
        this.basicValue.setTypeUsingReflection(this.persistentClassName, this.propertyName);
        this.basicValue.setJpaAttributeConverterDescriptor(this.converterDescriptor);
        this.basicValue.setJavaClass(this.explicitJavaClass);
    }

    public static enum Kind {
        ATTRIBUTE,
        COLLECTION_ID,
        COLLECTION_ELEMENT,
        COLLECTION_INDEX;

    }
}

