/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.ConstraintMode;
import javax.persistence.ForeignKey;
import javax.persistence.InheritanceType;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.MapKeyJoinColumns;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ClassLoadingException;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CollectionPropertyHolder;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.BasicValueBinder;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.sql.Template;

public class MapBinder
extends CollectionBinder {
    public MapBinder(boolean sorted) {
        super(sorted);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    protected Collection createCollection(PersistentClass persistentClass) {
        return new Map(this.getBuildingContext(), persistentClass);
    }

    @Override
    public SecondPass getSecondPass(final Ejb3JoinColumn[] fkJoinColumns, final Ejb3JoinColumn[] keyColumns, final Ejb3JoinColumn[] inverseColumns, final Ejb3Column[] elementColumns, final Ejb3Column[] mapKeyColumns, final Ejb3JoinColumn[] mapKeyManyToManyColumns, final boolean isEmbedded, final XProperty property, final XClass collType, final boolean ignoreNotFound, final boolean unique, final TableBinder assocTableBinder, final MetadataBuildingContext buildingContext) {
        return new CollectionSecondPass(buildingContext, this.collection){

            @Override
            public void secondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
                MapBinder.this.bindStarToManySecondPass(persistentClasses, collType, fkJoinColumns, keyColumns, inverseColumns, elementColumns, isEmbedded, property, unique, assocTableBinder, ignoreNotFound, buildingContext);
                MapBinder.this.bindKeyFromAssociationTable(collType, persistentClasses, MapBinder.this.mapKeyPropertyName, property, isEmbedded, buildingContext, mapKeyColumns, mapKeyManyToManyColumns, inverseColumns != null ? inverseColumns[0].getPropertyName() : null);
                MapBinder.this.makeOneToManyMapKeyColumnNullableIfNotInProperty(property);
            }
        };
    }

    private void makeOneToManyMapKeyColumnNullableIfNotInProperty(XProperty property) {
        Map map = (Map)this.collection;
        if (map.isOneToMany() && property.isAnnotationPresent(MapKeyColumn.class)) {
            PersistentClass persistentClass;
            Value indexValue = map.getIndex();
            if (indexValue.getColumnSpan() != 1) {
                throw new AssertionFailure("Map key mapped by @MapKeyColumn does not have 1 column");
            }
            MappedColumn mappedColumn = indexValue.getMappedColumns().get(0);
            if (mappedColumn.isFormula()) {
                throw new AssertionFailure("Map key mapped by @MapKeyColumn is a Formula");
            }
            Column column = (Column)map.getIndex().getMappedColumns().get(0);
            if (!column.isNullable() && !this.propertyIteratorContainsColumn((persistentClass = ((OneToMany)map.getElement()).getAssociatedClass()).getUnjoinedPropertyIterator(), column)) {
                column.setNullable(true);
            }
        }
    }

    private boolean propertyIteratorContainsColumn(Iterator propertyIterator, Column column) {
        while (propertyIterator.hasNext()) {
            Property property = (Property)propertyIterator.next();
            for (MappedColumn mappedColumn : property.getMappedColumns()) {
                if (!column.equals(mappedColumn)) continue;
                Column iteratedColumn = (Column)mappedColumn;
                if (!column.getTableName().equals(iteratedColumn.getTableName())) continue;
                return true;
            }
        }
        return false;
    }

    private void bindKeyFromAssociationTable(XClass collType, java.util.Map persistentClasses, String mapKeyPropertyName, XProperty property, boolean isEmbedded, MetadataBuildingContext buildingContext, Ejb3Column[] mapKeyColumns, Ejb3JoinColumn[] mapKeyManyToManyColumns, String targetPropertyName) {
        if (mapKeyPropertyName != null) {
            PersistentClass associatedClass = (PersistentClass)persistentClasses.get(collType.getName());
            if (associatedClass == null) {
                throw new AnnotationException("Associated class not found: " + collType);
            }
            Property mapProperty = BinderHelper.findPropertyByName(associatedClass, mapKeyPropertyName);
            if (mapProperty == null) {
                throw new AnnotationException("Map key property not found: " + collType + "." + mapKeyPropertyName);
            }
            Map map = (Map)this.collection;
            InheritanceState inheritanceState = (InheritanceState)this.inheritanceStatePerClass.get(collType);
            PersistentClass targetPropertyPersistentClass = InheritanceType.JOINED.equals((Object)inheritanceState.getType()) ? mapProperty.getPersistentClass() : associatedClass;
            Value indexValue = this.createFormulatedValue(mapProperty.getValue(), map, associatedClass, targetPropertyPersistentClass);
            map.setIndex(indexValue);
        } else {
            ForeignKey foreignKey;
            Class target = Void.TYPE;
            if (property.isAnnotationPresent(MapKeyClass.class)) {
                target = ((MapKeyClass)property.getAnnotation(MapKeyClass.class)).value();
            }
            String mapKeyType = !Void.TYPE.equals(target) ? target.getName() : property.getMapKey().getName();
            PersistentClass collectionEntity = (PersistentClass)persistentClasses.get(mapKeyType);
            boolean isIndexOfEntities = collectionEntity != null;
            ManyToOne element = null;
            Map mapValue = (Map)this.collection;
            if (isIndexOfEntities) {
                element = new ManyToOne(buildingContext, mapValue.getMappedTable());
                mapValue.setIndex(element);
                element.setReferencedEntityName(mapKeyType);
                element.setFetchMode(FetchMode.JOIN);
                element.setLazy(false);
            } else {
                AccessType accessType;
                Ejb3JoinColumn[] keyXClass;
                AnnotatedClassType classType;
                if (BinderHelper.PRIMITIVE_NAMES.contains(mapKeyType)) {
                    classType = AnnotatedClassType.NONE;
                    keyXClass = null;
                } else {
                    try {
                        keyXClass = buildingContext.getBootstrapContext().getReflectionManager().classForName(mapKeyType);
                    }
                    catch (ClassLoadingException e) {
                        throw new AnnotationException("Unable to find class: " + mapKeyType, e);
                    }
                    classType = buildingContext.getMetadataCollector().getClassType((XClass)keyXClass);
                    if (isEmbedded || this.mappingDefinedAttributeOverrideOnMapKey(property)) {
                        classType = AnnotatedClassType.EMBEDDABLE;
                    }
                }
                CollectionPropertyHolder holder = PropertyHolderBuilder.buildPropertyHolder(mapValue, StringHelper.qualify(mapValue.getRole(), "mapkey"), (XClass)keyXClass, property, this.propertyHolder, buildingContext);
                this.propertyHolder.startingProperty(property);
                holder.prepare(property);
                PersistentClass owner = mapValue.getOwner();
                if (owner.getIdentifierAttributeMapping() != null) {
                    accessType = owner.getIdentifierAttributeMapping().getPropertyAccessorName().equals("property") ? AccessType.PROPERTY : AccessType.FIELD;
                } else if (owner.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping() != null && owner.getEntityMappingHierarchy().hasEmbeddedIdentifier()) {
                    PersistentAttributeMapping prop = owner.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping().getDeclaredPersistentAttributes().get(0);
                    accessType = prop.getPropertyAccessorName().equals("property") ? AccessType.PROPERTY : AccessType.FIELD;
                } else {
                    throw new AssertionFailure("Unable to guess collection property accessor name");
                }
                if (AnnotatedClassType.EMBEDDABLE.equals((Object)classType)) {
                    EntityBinder entityBinder = new EntityBinder();
                    PropertyPreloadedData inferredData = this.isHibernateExtensionMapping() ? new PropertyPreloadedData(AccessType.PROPERTY, "index", (XClass)keyXClass) : new PropertyPreloadedData(AccessType.PROPERTY, "key", (XClass)keyXClass);
                    Component component = AnnotationBinder.fillComponent(holder, inferredData, accessType, true, entityBinder, false, false, true, buildingContext, this.inheritanceStatePerClass);
                    mapValue.setIndex(component);
                } else {
                    BasicValueBinder elementBinder = new BasicValueBinder(BasicValueBinder.Kind.COLLECTION_INDEX, buildingContext);
                    elementBinder.setReturnedClassName(mapKeyType);
                    Ejb3Column[] elementColumns = mapKeyColumns;
                    if (elementColumns == null || elementColumns.length == 0) {
                        elementColumns = new Ejb3Column[1];
                        Ejb3Column column = new Ejb3Column(buildingContext);
                        column.setImplicit(false);
                        column.setNullable(true);
                        column.setLength(255L);
                        column.setLogicalColumnName("id");
                        column.setJoins(new HashMap<String, Join>());
                        column.bind();
                        elementColumns[0] = column;
                    }
                    for (Ejb3Column column : elementColumns) {
                        column.setTable(mapValue.getMappedTable());
                    }
                    elementBinder.setColumns(elementColumns);
                    elementBinder.setType(property, (XClass)keyXClass, this.collection.getOwnerEntityName(), holder.mapKeyAttributeConverterDescriptor(property, (XClass)keyXClass));
                    elementBinder.setPersistentClassName(this.propertyHolder.getEntityName());
                    mapValue.setIndex(elementBinder.make());
                }
            }
            if (!this.collection.isOneToMany()) {
                for (Ejb3JoinColumn col : mapKeyManyToManyColumns) {
                    col.forceNotNull();
                }
            }
            if (element != null && (foreignKey = this.getMapKeyForeignKey(property)) != null) {
                if (foreignKey.value() == ConstraintMode.NO_CONSTRAINT) {
                    element.setForeignKeyName("none");
                } else {
                    element.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.name()));
                    element.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.foreignKeyDefinition()));
                }
            }
            if (isIndexOfEntities) {
                MapBinder.bindManytoManyInverseFk(collectionEntity, mapKeyManyToManyColumns, element, false, buildingContext);
            }
        }
    }

    private ForeignKey getMapKeyForeignKey(XProperty property) {
        MapKeyJoinColumns mapKeyJoinColumns = (MapKeyJoinColumns)property.getAnnotation(MapKeyJoinColumns.class);
        if (mapKeyJoinColumns != null) {
            return mapKeyJoinColumns.foreignKey();
        }
        MapKeyJoinColumn mapKeyJoinColumn = (MapKeyJoinColumn)property.getAnnotation(MapKeyJoinColumn.class);
        if (mapKeyJoinColumn != null) {
            return mapKeyJoinColumn.foreignKey();
        }
        return null;
    }

    private boolean mappingDefinedAttributeOverrideOnMapKey(XProperty property) {
        if (property.isAnnotationPresent(AttributeOverride.class)) {
            return this.namedMapKey((AttributeOverride)property.getAnnotation(AttributeOverride.class));
        }
        if (property.isAnnotationPresent(AttributeOverrides.class)) {
            AttributeOverrides annotations = (AttributeOverrides)property.getAnnotation(AttributeOverrides.class);
            for (AttributeOverride attributeOverride : annotations.value()) {
                if (!this.namedMapKey(attributeOverride)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean namedMapKey(AttributeOverride annotation) {
        return annotation.name().startsWith("key.");
    }

    protected Value createFormulatedValue(Value value, Collection collection, PersistentClass associatedClass, PersistentClass targetPropertyPersistentClass) {
        Value<?> element = collection.getElement();
        String fromAndWhere = null;
        if (!(element instanceof OneToMany)) {
            List<MappedColumn> referencedEntityColumns;
            String referencedPropertyName = null;
            if (element instanceof ToOne) {
                referencedPropertyName = ((ToOne)element).getReferencedPropertyName();
            } else if (element instanceof DependantValue) {
                if (this.propertyName != null) {
                    referencedPropertyName = collection.getReferencedPropertyName();
                } else {
                    throw new AnnotationException("SecondaryTable JoinColumn cannot reference a non primary key");
                }
            }
            if (referencedPropertyName == null) {
                referencedEntityColumns = associatedClass.getIdentifier().getMappedColumns();
            } else {
                Property referencedProperty = associatedClass.getRecursiveProperty(referencedPropertyName);
                referencedEntityColumns = referencedProperty.getMappedColumns();
            }
            fromAndWhere = this.getFromAndWhereFormula(associatedClass.getMappedTable().getName(), element.getMappedColumns(), referencedEntityColumns);
        } else if (!associatedClass.equals(targetPropertyPersistentClass)) {
            fromAndWhere = this.getFromAndWhereFormula(targetPropertyPersistentClass.getMappedTable().getQualifiedTableName().toString(), element.getMappedColumns(), associatedClass.getIdentifier().getMappedColumns());
        }
        if (value instanceof Component) {
            Component component = (Component)value;
            List<PersistentAttributeMapping> attributes = component.getDeclaredPersistentAttributes();
            Component indexComponent = new Component(this.getBuildingContext(), collection);
            indexComponent.setComponentClassName(component.getEmbeddableClassName());
            attributes.stream().map(Property.class::cast).forEach(current -> {
                Property newProperty = new Property(this.getBuildingContext());
                newProperty.setCascade(current.getCascade());
                newProperty.setValueGenerationStrategy(current.getValueGenerationStrategy());
                newProperty.setInsertable(false);
                newProperty.setUpdateable(false);
                newProperty.setMetaAttributes(current.getMetaAttributes());
                newProperty.setName(current.getName());
                newProperty.setNaturalIdentifier(false);
                newProperty.setOptional(false);
                newProperty.setPersistentClass((PersistentClass)current.getEntity());
                newProperty.setPropertyAccessorName(current.getPropertyAccessorName());
                newProperty.setSelectable(current.isSelectable());
                newProperty.setValue(this.createFormulatedValue(current.getValue(), collection, associatedClass, associatedClass));
                indexComponent.addDeclaredPersistentAttribute(newProperty);
            });
            return indexComponent;
        }
        if (value instanceof SimpleValue) {
            SimpleValue targetValue;
            SimpleValue sourceValue = (SimpleValue)value;
            if (value instanceof ManyToOne) {
                ManyToOne sourceManyToOne = (ManyToOne)sourceValue;
                ManyToOne targetManyToOne = new ManyToOne(this.getBuildingContext(), collection.getMappedTable());
                targetManyToOne.setFetchMode(FetchMode.DEFAULT);
                targetManyToOne.setLazy(true);
                targetManyToOne.setReferencedEntityName(sourceManyToOne.getReferencedEntityName());
                targetValue = targetManyToOne;
            } else if (value instanceof BasicValue) {
                targetValue = new BasicValue(this.getBuildingContext(), collection.getMappedTable(), (BasicValue)sourceValue);
            } else {
                throw new AssertionFailure("Unknown type encounters for map key: " + value.getClass());
            }
            Random random = new Random();
            for (MappedColumn current2 : sourceValue.getMappedColumns()) {
                String formulaString;
                if (current2 instanceof Column) {
                    formulaString = ((Column)current2).getQuotedName();
                } else if (current2 instanceof Formula) {
                    formulaString = ((Formula)current2).getFormula();
                } else {
                    throw new AssertionFailure("Unknown element in column iterator: " + current2.getClass());
                }
                Formula formula = new Formula(formulaString);
                if (fromAndWhere != null) {
                    formulaString = Template.renderWhereStringTemplate(formulaString, "$alias$", new HSQLDialect());
                    formulaString = "(select " + formulaString + fromAndWhere + ")";
                    formulaString = StringHelper.replace(formulaString, "$alias$", "a" + random.nextInt(16));
                }
                formula.setFormula(formulaString);
                targetValue.addFormula(formula);
            }
            return targetValue;
        }
        throw new AssertionFailure("Unknown type encounters for map key: " + value.getClass());
    }

    private String getFromAndWhereFormula(String tableName, List<MappedColumn> collectionTableColumns, List<MappedColumn> referencedEntityColumns) {
        String alias = "$alias$";
        StringBuilder fromAndWhereSb = new StringBuilder(" from ").append(tableName).append(" ").append(alias).append(" where ");
        for (int i = 0; i < collectionTableColumns.size(); ++i) {
            Column colColumn = (Column)collectionTableColumns.get(i);
            Column refColumn = (Column)referencedEntityColumns.get(i);
            fromAndWhereSb.append(alias).append('.').append(refColumn.getQuotedName()).append('=').append(colColumn.getQuotedName()).append(" and ");
        }
        return fromAndWhereSb.substring(0, fromAndWhereSb.length() - 5);
    }
}

