/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.FlushModeType;
import javax.persistence.NamedStoredProcedureQuery;
import javax.persistence.ParameterMode;
import javax.persistence.StoredProcedureParameter;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.cfg.annotations.QueryHintDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.procedure.internal.ProcedureParameterImpl;
import org.hibernate.procedure.internal.Util;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.query.named.internal.NamedCallableQueryMementoImpl;
import org.hibernate.query.named.spi.NamedCallableQueryMemento;
import org.hibernate.query.named.spi.ParameterMemento;

public class NamedProcedureCallDefinition {
    private final String registeredName;
    private final String procedureName;
    private final Class[] resultClasses;
    private final String[] resultSetMappings;
    private final ParameterDefinitions parameterDefinitions;
    private final Map<String, Object> hints;

    NamedProcedureCallDefinition(NamedStoredProcedureQuery annotation) {
        boolean specifiesResultSetMappings;
        this.registeredName = annotation.name();
        this.procedureName = annotation.procedureName();
        this.hints = new QueryHintDefinition(annotation.hints()).getHintsMap();
        this.resultClasses = annotation.resultClasses();
        this.resultSetMappings = annotation.resultSetMappings();
        this.parameterDefinitions = new ParameterDefinitions(annotation.parameters(), this.hints);
        boolean specifiesResultClasses = this.resultClasses != null && this.resultClasses.length > 0;
        boolean bl = specifiesResultSetMappings = this.resultSetMappings != null && this.resultSetMappings.length > 0;
        if (specifiesResultClasses && specifiesResultSetMappings) {
            throw new MappingException(String.format("NamedStoredProcedureQuery [%s] specified both resultClasses and resultSetMappings", this.registeredName));
        }
    }

    public String getRegisteredName() {
        return this.registeredName;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public NamedCallableQueryMemento toMemento(SessionFactoryImplementor sessionFactory) {
        boolean isCacheable = this.isCacheable(this.hints, sessionFactory);
        return new NamedCallableQueryMementoImpl(this.registeredName, this.procedureName, this.parameterDefinitions.getParameterStrategy(), this.parameterDefinitions.toMementos(sessionFactory), this.resultClasses, this.resultSetMappings, Collections.emptySet(), isCacheable, isCacheable ? this.determineCacheRegion(this.hints, sessionFactory) : null, isCacheable ? this.determineCacheMode(this.hints, sessionFactory) : null, this.determineFlushMode(this.hints, sessionFactory), ConfigurationHelper.getBoolean("org.hibernate.readOnly", this.hints, false), LockOptions.NONE, ConfigurationHelper.getInt("javax.persistence.query.timeout", this.hints, ConfigurationHelper.getInt("org.hibernate.timeout", this.hints, 0) * 1000) / 1000, 0, null, Util.copy(this.hints));
    }

    private boolean isCacheable(Map<String, Object> hints, SessionFactoryImplementor sessionFactory) {
        return sessionFactory.getSessionFactoryOptions().isQueryCacheEnabled() && ConfigurationHelper.getBoolean("org.hibernate.cacheable", hints, false);
    }

    private String determineCacheRegion(Map<String, Object> hints, SessionFactoryImplementor sessionFactory) {
        assert (sessionFactory.getSessionFactoryOptions().isQueryCacheEnabled());
        return ConfigurationHelper.getString("org.hibernate.cacheRegion", hints, null);
    }

    private CacheMode determineCacheMode(Map<String, Object> hints, SessionFactoryImplementor sessionFactory) {
        assert (sessionFactory.getSessionFactoryOptions().isQueryCacheEnabled());
        Object setting = hints.get("org.hibernate.cacheMode");
        if (setting != null) {
            if (CacheMode.class.isInstance(setting)) {
                return (CacheMode)((Object)setting);
            }
            CacheMode cacheMode = CacheMode.interpretExternalSetting(setting.toString());
            if (cacheMode != null) {
                return cacheMode;
            }
        }
        return CacheMode.NORMAL;
    }

    private FlushMode determineFlushMode(Map<String, Object> hints, SessionFactoryImplementor sessionFactory) {
        Object setting = hints.get("org.hibernate.flushMode");
        if (setting != null) {
            if (FlushMode.class.isInstance(setting)) {
                return (FlushMode)((Object)setting);
            }
            if (FlushModeType.class.isInstance(setting)) {
                return FlushModeTypeHelper.getFlushMode((FlushModeType)FlushModeType.class.cast(setting));
            }
            FlushMode mode = FlushMode.interpretExternalSetting(setting.toString());
            if (mode != null) {
                return mode;
            }
        }
        return FlushMode.AUTO;
    }

    private static String normalize(String name) {
        return StringHelper.isNotEmpty(name) ? name : null;
    }

    static class ParameterDefinition {
        private final Integer position;
        private final String name;
        private final ParameterMode parameterMode;
        private final Class type;
        private final Boolean explicitPassNullSetting;

        static ParameterDefinition from(ParameterStrategy parameterStrategy, StoredProcedureParameter parameterAnnotation, int adjustedPosition, Map<String, Object> queryHintMap) {
            Object explicitNullPassingHint = parameterStrategy == ParameterStrategy.NAMED ? queryHintMap.get("hibernate.proc.param_null_passing." + parameterAnnotation.name()) : queryHintMap.get("hibernate.proc.param_null_passing." + adjustedPosition);
            return new ParameterDefinition(adjustedPosition, parameterAnnotation, ParameterDefinition.interpretBoolean(explicitNullPassingHint));
        }

        private static Boolean interpretBoolean(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return Boolean.valueOf(value.toString());
        }

        ParameterDefinition(int position, StoredProcedureParameter annotation, Boolean explicitPassNullSetting) {
            this.position = position;
            this.name = NamedProcedureCallDefinition.normalize(annotation.name());
            this.parameterMode = annotation.mode();
            this.type = annotation.type();
            this.explicitPassNullSetting = explicitPassNullSetting;
        }

        public ParameterMemento toMemento(SessionFactoryImplementor sessionFactory) {
            boolean initialPassNullSetting = this.explicitPassNullSetting != null ? this.explicitPassNullSetting.booleanValue() : sessionFactory.getSessionFactoryOptions().isProcedureParameterNullPassingEnabled();
            return session -> {
                if (this.name != null) {
                    return new ProcedureParameterImpl(this.name, this.parameterMode, this.type, null, initialPassNullSetting);
                }
                return new ProcedureParameterImpl(this.position, this.parameterMode, this.type, null, initialPassNullSetting);
            };
        }
    }

    static class ParameterDefinitions {
        private final ParameterStrategy parameterStrategy;
        private final ParameterDefinition[] parameterDefinitions;

        ParameterDefinitions(StoredProcedureParameter[] parameters, Map<String, Object> queryHintMap) {
            if (parameters == null || parameters.length == 0) {
                this.parameterStrategy = ParameterStrategy.POSITIONAL;
                this.parameterDefinitions = new ParameterDefinition[0];
            } else {
                this.parameterStrategy = StringHelper.isNotEmpty(parameters[0].name()) ? ParameterStrategy.NAMED : ParameterStrategy.POSITIONAL;
                this.parameterDefinitions = new ParameterDefinition[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    this.parameterDefinitions[i] = ParameterDefinition.from(this.parameterStrategy, parameters[i], i + 1, queryHintMap);
                }
            }
        }

        public ParameterStrategy getParameterStrategy() {
            return this.parameterStrategy;
        }

        public List<ParameterMemento> toMementos(SessionFactoryImplementor sessionFactory) {
            ArrayList<ParameterMemento> mementos = new ArrayList<ParameterMemento>();
            for (ParameterDefinition definition : this.parameterDefinitions) {
                mementos.add(definition.toMemento(sessionFactory));
            }
            return mementos;
        }
    }
}

