/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import javax.persistence.ColumnResult;
import javax.persistence.ConstructorResult;
import javax.persistence.EntityResult;
import javax.persistence.NamedStoredProcedureQuery;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.annotations.CacheModeType;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.boot.model.query.internal.NamedHqlQueryDefinitionImpl;
import org.hibernate.boot.model.query.internal.NamedNativeQueryDefinitionImpl;
import org.hibernate.boot.model.resultset.internal.EntityResultDefinitionImpl;
import org.hibernate.boot.model.resultset.internal.InstantiationResultDefinitionImpl;
import org.hibernate.boot.model.resultset.internal.ResultSetMappingDefinitionImpl;
import org.hibernate.boot.model.resultset.internal.ScalarResultDefinitionImpl;
import org.hibernate.boot.model.resultset.spi.ResultSetMappingDefinition;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.annotations.NamedProcedureCallDefinition;
import org.hibernate.cfg.annotations.QueryHintDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public abstract class QueryBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)QueryBinder.class.getName());
    private static int inlineResultMappingCount = 0;

    public static void bindQuery(javax.persistence.NamedQuery queryAnn, MetadataBuildingContext context, boolean isDefault) {
        if (queryAnn == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(queryAnn.name())) {
            throw new AnnotationException("A named HQL/JPQL query must have a name when used in class or package level");
        }
        QueryHintDefinition hints = new QueryHintDefinition(queryAnn.hints());
        String queryName = queryAnn.name();
        String hqlString = queryAnn.query();
        NamedHqlQueryDefinitionImpl queryDefinition = ((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)new NamedHqlQueryDefinitionImpl.Builder(queryName, hqlString).setLockOptions(hints.determineLockOptions(queryAnn))).setCacheable(hints.getBoolean(queryName, "org.hibernate.cacheable"))).setCacheRegion(hints.getString(queryName, "org.hibernate.cacheRegion"))).setTimeout(hints.getTimeout(queryName))).setFetchSize(hints.getInteger(queryName, "org.hibernate.fetchSize"))).setFlushMode(hints.getFlushMode(queryName))).setCacheMode(hints.getCacheMode(queryName))).setReadOnly(hints.getBoolean(queryName, "org.hibernate.readOnly"))).setComment(hints.getString(queryName, "org.hibernate.comment"))).build();
        if (isDefault) {
            context.getMetadataCollector().addDefaultNamedHqlQuery(queryDefinition);
        } else {
            context.getMetadataCollector().addNamedHqlQuery(queryDefinition);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Generated and registered NamedHqlQueryDefinition : `%s` => `%s`", queryDefinition.getName(), queryDefinition.getQueryString());
        }
    }

    public static void bindNativeQuery(javax.persistence.NamedNativeQuery queryAnn, MetadataBuildingContext context, boolean isDefault) {
        if (queryAnn == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(queryAnn.name())) {
            throw new AnnotationException("A named native query must have a name when used in class or package level");
        }
        String queryName = queryAnn.name();
        String sqlString = queryAnn.query();
        QueryHintDefinition hints = new QueryHintDefinition(queryAnn.hints());
        if (hints.getBoolean(sqlString, "org.hibernate.callable")) {
            LOG.warnNativeQueryAsCallable();
        }
        NamedNativeQueryDefinitionImpl.Builder builder = (NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)new NamedNativeQueryDefinitionImpl.Builder(queryName).setSqlString(sqlString).setCacheable(hints.getBoolean(sqlString, "org.hibernate.cacheable"))).setCacheRegion(hints.getString(sqlString, "org.hibernate.cacheRegion"))).setTimeout(hints.getTimeout(sqlString))).setFetchSize(hints.getInteger(sqlString, "org.hibernate.fetchSize"))).setFlushMode(hints.getFlushMode(sqlString))).setCacheMode(hints.getCacheMode(sqlString))).setReadOnly(hints.getBoolean(sqlString, "org.hibernate.readOnly"))).setComment(hints.getString(sqlString, "org.hibernate.comment"));
        String resultSetMappingName = queryAnn.resultSetMapping();
        if (!BinderHelper.isEmptyAnnotationValue(resultSetMappingName)) {
            builder.setResultSetMapping(resultSetMappingName);
        } else if (!Void.TYPE.equals(queryAnn.resultClass())) {
            ResultSetMappingDefinitionImpl inLineResultMapping = new ResultSetMappingDefinitionImpl("inline-result-mapping:" + ++inlineResultMappingCount);
            EntityResultDefinitionImpl entityResultDefinition = new EntityResultDefinitionImpl(null, queryAnn.resultClass().getName(), "alias1");
            entityResultDefinition.setLockMode(LockMode.READ);
            inLineResultMapping.addResult(entityResultDefinition);
            context.getMetadataCollector().addResultSetMapping(inLineResultMapping);
            builder.setResultSetMapping(inLineResultMapping.getName());
        }
        NamedNativeQueryDefinitionImpl queryDefinition = builder.build();
        if (isDefault) {
            context.getMetadataCollector().addDefaultNamedNativeQuery(queryDefinition);
        } else {
            context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Generated and registered NamedHqlQueryDefinition : `%s` => `%s`", queryDefinition.getName(), queryDefinition.getQueryString());
        }
    }

    public static void bindNativeQuery(NamedNativeQuery queryAnn, MetadataBuildingContext context) {
        if (queryAnn == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(queryAnn.name())) {
            throw new AnnotationException("A named native query must have a name when used in class or package level");
        }
        String queryName = queryAnn.name();
        String sqlString = queryAnn.query();
        NamedNativeQueryDefinitionImpl.Builder builder = (NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)((NamedNativeQueryDefinitionImpl.Builder)new NamedNativeQueryDefinitionImpl.Builder(queryName).setSqlString(sqlString).setCacheable(queryAnn.cacheable())).setCacheRegion(BinderHelper.isEmptyAnnotationValue(queryAnn.cacheRegion()) ? null : queryAnn.cacheRegion())).setTimeout(queryAnn.timeout() < 0 ? null : Integer.valueOf(queryAnn.timeout()))).setFetchSize(queryAnn.fetchSize() < 0 ? null : Integer.valueOf(queryAnn.fetchSize()))).setFlushMode(QueryBinder.getFlushMode(queryAnn.flushMode()))).setCacheMode(QueryBinder.getCacheMode(queryAnn.cacheMode()))).setReadOnly(queryAnn.readOnly())).setComment(BinderHelper.isEmptyAnnotationValue(queryAnn.comment()) ? null : queryAnn.comment());
        String resultSetMappingName = queryAnn.resultSetMapping();
        if (!BinderHelper.isEmptyAnnotationValue(resultSetMappingName)) {
            builder.setResultSetMapping(resultSetMappingName);
        } else if (!Void.TYPE.equals(queryAnn.resultClass())) {
            ResultSetMappingDefinitionImpl resultSetMappingDefinition = new ResultSetMappingDefinitionImpl("inline-result-mapping:" + ++inlineResultMappingCount);
            String entityClassName = queryAnn.resultClass().getName();
            resultSetMappingDefinition.addResult(new EntityResultDefinitionImpl(null, entityClassName, "alias1"));
            context.getMetadataCollector().addResultSetMapping(resultSetMappingDefinition);
            builder.setResultSetMapping(resultSetMappingDefinition.getName());
        } else {
            throw new NotYetImplementedException("Pure native scalar queries are not yet supported");
        }
        context.getMetadataCollector().addNamedNativeQuery(builder.build());
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named native query: %s => %s", queryAnn.name(), queryAnn.query());
        }
    }

    public static void bindQueries(javax.persistence.NamedQueries queriesAnn, MetadataBuildingContext context, boolean isDefault) {
        if (queriesAnn == null) {
            return;
        }
        for (javax.persistence.NamedQuery q : queriesAnn.value()) {
            QueryBinder.bindQuery(q, context, isDefault);
        }
    }

    public static void bindNativeQueries(javax.persistence.NamedNativeQueries queriesAnn, MetadataBuildingContext context, boolean isDefault) {
        if (queriesAnn == null) {
            return;
        }
        for (javax.persistence.NamedNativeQuery q : queriesAnn.value()) {
            QueryBinder.bindNativeQuery(q, context, isDefault);
        }
    }

    public static void bindNativeQueries(NamedNativeQueries queriesAnn, MetadataBuildingContext context) {
        if (queriesAnn == null) {
            return;
        }
        for (NamedNativeQuery q : queriesAnn.value()) {
            QueryBinder.bindNativeQuery(q, context);
        }
    }

    public static void bindQuery(NamedQuery queryAnn, MetadataBuildingContext context) {
        if (queryAnn == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String queryName = queryAnn.name();
        String hqlString = queryAnn.query();
        FlushMode flushMode = QueryBinder.getFlushMode(queryAnn.flushMode());
        NamedHqlQueryDefinitionImpl.Builder builder = (NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)((NamedHqlQueryDefinitionImpl.Builder)new NamedHqlQueryDefinitionImpl.Builder(queryName, hqlString).setCacheable(queryAnn.cacheable())).setCacheRegion(BinderHelper.isEmptyAnnotationValue(queryAnn.cacheRegion()) ? null : queryAnn.cacheRegion())).setTimeout(queryAnn.timeout() < 0 ? null : Integer.valueOf(queryAnn.timeout()))).setFetchSize(queryAnn.fetchSize() < 0 ? null : Integer.valueOf(queryAnn.fetchSize()))).setFlushMode(flushMode)).setCacheMode(QueryBinder.getCacheMode(queryAnn.cacheMode()))).setReadOnly(queryAnn.readOnly())).setComment(BinderHelper.isEmptyAnnotationValue(queryAnn.comment()) ? null : queryAnn.comment());
        context.getMetadataCollector().addNamedHqlQuery(builder.build());
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named HQL/JPQL query: %s => %s", queryName, hqlString);
        }
    }

    private static FlushMode getFlushMode(FlushModeType flushModeType) {
        FlushMode flushMode;
        switch (flushModeType) {
            case ALWAYS: {
                flushMode = FlushMode.ALWAYS;
                break;
            }
            case AUTO: {
                flushMode = FlushMode.AUTO;
                break;
            }
            case COMMIT: {
                flushMode = FlushMode.COMMIT;
                break;
            }
            case NEVER: {
                flushMode = FlushMode.MANUAL;
                break;
            }
            case MANUAL: {
                flushMode = FlushMode.MANUAL;
                break;
            }
            case PERSISTENCE_CONTEXT: {
                flushMode = null;
                break;
            }
            default: {
                throw new AssertionFailure("Unknown flushModeType: " + (Object)((Object)flushModeType));
            }
        }
        return flushMode;
    }

    private static CacheMode getCacheMode(CacheModeType cacheModeType) {
        switch (cacheModeType) {
            case GET: {
                return CacheMode.GET;
            }
            case IGNORE: {
                return CacheMode.IGNORE;
            }
            case NORMAL: {
                return CacheMode.NORMAL;
            }
            case PUT: {
                return CacheMode.PUT;
            }
            case REFRESH: {
                return CacheMode.REFRESH;
            }
        }
        throw new AssertionFailure("Unknown cacheModeType: " + (Object)((Object)cacheModeType));
    }

    public static void bindQueries(NamedQueries queriesAnn, MetadataBuildingContext context) {
        if (queriesAnn == null) {
            return;
        }
        for (NamedQuery q : queriesAnn.value()) {
            QueryBinder.bindQuery(q, context);
        }
    }

    public static void bindNamedStoredProcedureQuery(NamedStoredProcedureQuery annotation, MetadataBuildingContext context, boolean isDefault) {
        if (annotation == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(annotation.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        NamedProcedureCallDefinition def = new NamedProcedureCallDefinition(annotation);
        if (isDefault) {
            context.getMetadataCollector().addDefaultNamedProcedureCallDefinition(def);
        } else {
            context.getMetadataCollector().addNamedProcedureCallDefinition(def);
        }
        LOG.debugf("Bound named stored procedure query : %s => %s", def.getRegisteredName(), def.getProcedureName());
    }

    public static void bindSqlResultSetMappings(SqlResultSetMappings ann, MetadataBuildingContext context) {
        if (ann == null) {
            return;
        }
        for (SqlResultSetMapping rs : ann.value()) {
            QueryBinder.bindSqlResultSetMapping(rs, context, true);
        }
    }

    public static void bindSqlResultSetMapping(SqlResultSetMapping ann, MetadataBuildingContext context, boolean isDefault) {
        ResultSetMappingDefinition resultSetMapping = QueryBinder.extractMapping(ann, context);
        if (isDefault) {
            context.getMetadataCollector().addDefaultResultSetMapping(resultSetMapping);
        } else {
            context.getMetadataCollector().addResultSetMapping(resultSetMapping);
        }
    }

    private static ResultSetMappingDefinition extractMapping(SqlResultSetMapping ann, MetadataBuildingContext context) {
        ResultSetMappingDefinitionImpl mapping = new ResultSetMappingDefinitionImpl(ann.name());
        LOG.debugf("Binding @SqlResultSetMapping( name=\"" + ann.name() + "\")", new Object[0]);
        int entityAliasIndex = 0;
        for (EntityResult entityResult : ann.entities()) {
            mapping.addResult(QueryBinder.extractEntityResult(entityResult, entityAliasIndex, context));
        }
        for (EntityResult entityResult : ann.columns()) {
            mapping.addResult(QueryBinder.extractScalarResult((ColumnResult)entityResult, context));
        }
        for (EntityResult entityResult : ann.classes()) {
            mapping.addResult(QueryBinder.extractInstantiationResult((ConstructorResult)entityResult, context));
        }
        return mapping;
    }

    private static ResultSetMappingDefinition.InstantiationResult extractInstantiationResult(ConstructorResult constructorResult, MetadataBuildingContext context) {
        InstantiationResultDefinitionImpl instantiation = new InstantiationResultDefinitionImpl(constructorResult.targetClass().getName());
        for (ColumnResult columnResult : constructorResult.columns()) {
            instantiation.addArgument(new InstantiationResultDefinitionImpl.ArgumentImpl(QueryBinder.extractScalarResult(columnResult, context), columnResult.name()));
        }
        return instantiation;
    }

    private static ResultSetMappingDefinition.Result extractEntityResult(EntityResult entity, int entityAliasIndex, MetadataBuildingContext context) {
        return new EntityResultDefinitionImpl(entity.entityClass().getName(), null, null);
    }

    private static ResultSetMappingDefinition.Result extractScalarResult(ColumnResult column, MetadataBuildingContext context) {
        return new ScalarResultDefinitionImpl(column.name(), column.type().getName());
    }
}

