/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.lang.annotation.ElementType;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import org.hibernate.Hibernate;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEmbedded;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEntity;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;

public class HibernateTraversableResolver
implements TraversableResolver {
    private Set<String> associations;

    public HibernateTraversableResolver(EntityTypeDescriptor entityDescriptor, ConcurrentHashMap<EntityTypeDescriptor, Set<String>> associationsPerEntityDescriptor) {
        this.associations = associationsPerEntityDescriptor.get(entityDescriptor);
        if (this.associations == null) {
            this.associations = new HashSet<String>();
            this.addAssociationsToTheSetForAllProperties(entityDescriptor);
            associationsPerEntityDescriptor.put(entityDescriptor, this.associations);
        }
    }

    private void addAssociationsToTheSetForAllProperties(ManagedTypeDescriptor<?> managedTypeDescriptor) {
        for (PersistentAttributeDescriptor persistentAttributeDescriptor : managedTypeDescriptor.getPersistentAttributes()) {
            this.addAssociationsToTheSetForOneProperty(persistentAttributeDescriptor);
        }
    }

    private void addAssociationsToTheSetForOneProperty(PersistentAttributeDescriptor attribute) {
        if (attribute instanceof PluralPersistentAttribute || attribute instanceof SingularPersistentAttributeEntity) {
            this.associations.add(attribute.getNavigableRole().getFullPath());
        } else if (attribute instanceof SingularPersistentAttributeEmbedded) {
            this.addAssociationsToTheSetForAllProperties(((SingularPersistentAttributeEmbedded)attribute).getEmbeddedDescriptor());
        }
    }

    private String getStringBasedPath(Path.Node traversableProperty, Path pathToTraversableObject) {
        StringBuilder path = new StringBuilder();
        for (Path.Node node : pathToTraversableObject) {
            if (node.getName() == null) continue;
            path.append(node.getName()).append(".");
        }
        if (traversableProperty.getName() == null) {
            throw new AssertionFailure("TraversableResolver being passed a traversableProperty with null name. pathToTraversableObject: " + path.toString());
        }
        path.append(traversableProperty.getName());
        return path.toString();
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return Hibernate.isInitialized(traversableObject) && Hibernate.isPropertyInitialized(traversableObject, traversableProperty.getName());
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        String path = this.getStringBasedPath(traversableProperty, pathToTraversableObject);
        return !this.associations.contains(path);
    }
}

