/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.boot.model.domain.spi.EntityMappingImplementor;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.ClassLoaderAccess;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cfg.beanvalidation.ActivationContext;
import org.hibernate.cfg.beanvalidation.BeanValidationEventListener;
import org.hibernate.cfg.beanvalidation.DuplicationStrategyImpl;
import org.hibernate.cfg.beanvalidation.GroupsPerOperation;
import org.hibernate.cfg.beanvalidation.IntegrationException;
import org.hibernate.cfg.beanvalidation.ValidationMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JavaTypeHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.jboss.logging.Logger;

class TypeSafeActivator {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)TypeSafeActivator.class.getName());
    private static final String FACTORY_PROPERTY = "javax.persistence.validation.factory";

    TypeSafeActivator() {
    }

    public static void validateSuppliedFactory(Object object) {
        if (!ValidatorFactory.class.isInstance(object)) {
            throw new IntegrationException("Given object was not an instance of " + ValidatorFactory.class.getName() + "[" + object.getClass().getName() + "]");
        }
    }

    public static void activate(ActivationContext activationContext) {
        ValidatorFactory factory;
        try {
            factory = TypeSafeActivator.getValidatorFactory(activationContext);
        }
        catch (IntegrationException e) {
            if (activationContext.getValidationModes().contains((Object)ValidationMode.CALLBACK)) {
                throw new IntegrationException("Bean Validation provider was not available, but 'callback' validation was requested", (Throwable)((Object)e));
            }
            if (activationContext.getValidationModes().contains((Object)ValidationMode.DDL)) {
                throw new IntegrationException("Bean Validation provider was not available, but 'ddl' validation was requested", (Throwable)((Object)e));
            }
            LOG.debug("Unable to acquire Bean Validation ValidatorFactory, skipping activation");
            return;
        }
        TypeSafeActivator.applyRelationalConstraints(factory, activationContext);
        TypeSafeActivator.applyCallbackListeners(factory, activationContext);
    }

    public static void applyCallbackListeners(ValidatorFactory validatorFactory, ActivationContext activationContext) {
        Set<ValidationMode> modes = activationContext.getValidationModes();
        if (!modes.contains((Object)ValidationMode.CALLBACK) && !modes.contains((Object)ValidationMode.AUTO)) {
            return;
        }
        ConfigurationService cfgService = activationContext.getServiceRegistry().getService(ConfigurationService.class);
        ClassLoaderService classLoaderService = activationContext.getServiceRegistry().getService(ClassLoaderService.class);
        if (cfgService.getSettings().get("hibernate.check_nullability") == null) {
            activationContext.getSessionFactory().getSessionFactoryOptions().setCheckNullability(false);
        }
        BeanValidationEventListener listener = new BeanValidationEventListener(validatorFactory, cfgService.getSettings(), classLoaderService);
        EventListenerRegistry listenerRegistry = activationContext.getServiceRegistry().getService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy(DuplicationStrategyImpl.INSTANCE);
        listenerRegistry.appendListeners(EventType.PRE_INSERT, listener);
        listenerRegistry.appendListeners(EventType.PRE_UPDATE, listener);
        listenerRegistry.appendListeners(EventType.PRE_DELETE, listener);
        listener.initialize(cfgService.getSettings(), classLoaderService);
    }

    private static void applyRelationalConstraints(ValidatorFactory factory, ActivationContext activationContext) {
        ConfigurationService cfgService = activationContext.getServiceRegistry().getService(ConfigurationService.class);
        if (!cfgService.getSetting("hibernate.validator.apply_to_ddl", StandardConverters.BOOLEAN, Boolean.valueOf(true)).booleanValue()) {
            LOG.debug("Skipping application of relational constraints from legacy Hibernate Validator");
            return;
        }
        Set<ValidationMode> modes = activationContext.getValidationModes();
        if (!modes.contains((Object)ValidationMode.DDL) && !modes.contains((Object)ValidationMode.AUTO)) {
            return;
        }
        TypeSafeActivator.applyRelationalConstraints(factory, (Collection)JavaTypeHelper.cast(activationContext.getMetadata().getEntityMappings()), cfgService.getSettings(), activationContext.getServiceRegistry().getService(JdbcServices.class).getDialect(), new ClassLoaderAccessImpl(null, activationContext.getServiceRegistry().getService(ClassLoaderService.class)));
    }

    public static void applyRelationalConstraints(ValidatorFactory factory, Collection<EntityMappingImplementor> entityMappings, Map settings, Dialect dialect, ClassLoaderAccess classLoaderAccess) {
        Class<?>[] groupsArray = GroupsPerOperation.buildGroupsForOperation(GroupsPerOperation.Operation.DDL, settings, classLoaderAccess);
        HashSet groups = new HashSet(Arrays.asList(groupsArray));
        for (EntityMappingImplementor entityMapping : entityMappings) {
            Class clazz;
            String className;
            if (entityMapping.getExplicitRepresentationMode().equals((Object)RepresentationMode.MAP) || (className = entityMapping.getEntityName()) == null || className.length() == 0) continue;
            try {
                clazz = classLoaderAccess.classForName(className);
            }
            catch (ClassLoadingException e) {
                throw new AssertionFailure("Entity class not found", (Throwable)((Object)e));
            }
            try {
                TypeSafeActivator.applyDDL("", entityMapping, clazz, factory, groups, true, dialect);
            }
            catch (Exception e) {
                LOG.unableToApplyConstraints(className, e);
            }
        }
    }

    private static void applyDDL(String prefix, EntityMappingImplementor persistentClass, Class<?> clazz, ValidatorFactory factory, Set<Class<?>> groups, boolean activateNotNull, Dialect dialect) {
        BeanDescriptor descriptor = factory.getValidator().getConstraintsForClass(clazz);
        for (PropertyDescriptor propertyDesc : descriptor.getConstrainedProperties()) {
            PersistentAttributeMapping property = TypeSafeActivator.findPropertyByName(persistentClass, prefix + propertyDesc.getPropertyName());
            if (property == null) continue;
            boolean hasNotNull = TypeSafeActivator.applyConstraints(propertyDesc.getConstraintDescriptors(), property, propertyDesc, groups, activateNotNull, dialect);
            if (!TypeSafeActivator.isComposite(property) || !propertyDesc.isCascaded()) continue;
            Class componentClass = ((Component)property.getValueMapping()).getComponentClass();
            boolean canSetNotNullOnColumns = activateNotNull && hasNotNull;
            TypeSafeActivator.applyDDL(prefix + propertyDesc.getPropertyName() + ".", persistentClass, componentClass, factory, groups, canSetNotNullOnColumns, dialect);
        }
    }

    private static boolean applyConstraints(Set<ConstraintDescriptor<?>> constraintDescriptors, PersistentAttributeMapping property, PropertyDescriptor propertyDesc, Set<Class<?>> groups, boolean canApplyNotNull, Dialect dialect) {
        boolean hasNotNull = false;
        for (ConstraintDescriptor<?> descriptor : constraintDescriptors) {
            if (groups != null && Collections.disjoint(descriptor.getGroups(), groups)) continue;
            if (canApplyNotNull) {
                hasNotNull = hasNotNull || TypeSafeActivator.applyNotNull(property, descriptor);
            }
            TypeSafeActivator.applyDigits(property, descriptor);
            TypeSafeActivator.applySize(property, descriptor, propertyDesc);
            TypeSafeActivator.applyMin(property, descriptor, dialect);
            TypeSafeActivator.applyMax(property, descriptor, dialect);
            TypeSafeActivator.applyLength(property, descriptor, propertyDesc);
            boolean hasNotNullFromComposingConstraints = TypeSafeActivator.applyConstraints(descriptor.getComposingConstraints(), property, propertyDesc, null, canApplyNotNull, dialect);
            hasNotNull = hasNotNull || hasNotNullFromComposingConstraints;
        }
        return hasNotNull;
    }

    private static void applyMin(PersistentAttributeMapping property, ConstraintDescriptor<?> descriptor, Dialect dialect) {
        if (Min.class.equals(descriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> minConstraint = descriptor;
            long min = ((Min)minConstraint.getAnnotation()).value();
            Column col = TypeSafeActivator.getColumn(property);
            String checkConstraint = col.getQuotedName(dialect) + ">=" + min;
            TypeSafeActivator.applySQLCheck(col, checkConstraint);
        }
    }

    private static void applyMax(PersistentAttributeMapping property, ConstraintDescriptor<?> descriptor, Dialect dialect) {
        if (Max.class.equals(descriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> maxConstraint = descriptor;
            long max = ((Max)maxConstraint.getAnnotation()).value();
            Column col = TypeSafeActivator.getColumn(property);
            String checkConstraint = col.getQuotedName(dialect) + "<=" + max;
            TypeSafeActivator.applySQLCheck(col, checkConstraint);
        }
    }

    private static void applySQLCheck(Column col, String checkConstraint) {
        String existingCheck = col.getCheckConstraint();
        if (StringHelper.isNotEmpty(existingCheck) && !existingCheck.contains(checkConstraint)) {
            checkConstraint = col.getCheckConstraint() + " AND " + checkConstraint;
        }
        col.setCheckConstraint(checkConstraint);
    }

    private static boolean applyNotNull(PersistentAttributeMapping property, ConstraintDescriptor<?> descriptor) {
        boolean hasNotNull = false;
        if (NotNull.class.equals(descriptor.getAnnotation().annotationType())) {
            if (!(property.getEntity() instanceof SingleTableSubclass) && !TypeSafeActivator.isComposite(property)) {
                List<MappedColumn> mappedColumns = property.getValueMapping().getMappedColumns();
                mappedColumns.forEach(mappedColumn -> {
                    if (Column.class.isInstance(mappedColumn)) {
                        ((Column)Column.class.cast(mappedColumn)).setNullable(false);
                    } else {
                        LOG.debugf("@NotNull was applied to attribute [%s] which is defined (at least partially) by formula(s); formula portions will be skipped", property.getName());
                    }
                });
            }
            hasNotNull = true;
        }
        return hasNotNull;
    }

    private static void applyDigits(PersistentAttributeMapping property, ConstraintDescriptor<?> descriptor) {
        if (Digits.class.equals(descriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> digitsConstraint = descriptor;
            int integerDigits = ((Digits)digitsConstraint.getAnnotation()).integer();
            int fractionalDigits = ((Digits)digitsConstraint.getAnnotation()).fraction();
            Column col = TypeSafeActivator.getColumn(property);
            col.setPrecision(integerDigits + fractionalDigits);
            col.setScale(fractionalDigits);
        }
    }

    private static void applySize(PersistentAttributeMapping property, ConstraintDescriptor<?> descriptor, PropertyDescriptor propertyDescriptor) {
        if (Size.class.equals(descriptor.getAnnotation().annotationType()) && String.class.equals((Object)propertyDescriptor.getElementClass())) {
            ConstraintDescriptor<?> sizeConstraint = descriptor;
            int max = ((Size)sizeConstraint.getAnnotation()).max();
            Column col = TypeSafeActivator.getColumn(property);
            if (max < Integer.MAX_VALUE) {
                col.setLength(Long.valueOf(max));
            }
        }
    }

    private static void applyLength(PersistentAttributeMapping property, ConstraintDescriptor<?> descriptor, PropertyDescriptor propertyDescriptor) {
        if ("org.hibernate.validator.constraints.Length".equals(descriptor.getAnnotation().annotationType().getName()) && String.class.equals((Object)propertyDescriptor.getElementClass())) {
            int max = (Integer)descriptor.getAttributes().get("max");
            Column col = TypeSafeActivator.getColumn(property);
            if (max < Integer.MAX_VALUE) {
                col.setLength(Long.valueOf(max));
            }
        }
    }

    private static PersistentAttributeMapping findPropertyByName(EntityMappingImplementor associatedClass, String propertyName) {
        PersistentAttributeMapping property = null;
        PersistentAttributeMapping idProperty = associatedClass.getIdentifierAttributeMapping();
        String idName = idProperty != null ? idProperty.getName() : null;
        try {
            if (propertyName == null || propertyName.length() == 0 || propertyName.equals(idName)) {
                property = idProperty;
            } else {
                if (propertyName.indexOf(idName + ".") == 0) {
                    property = idProperty;
                    propertyName = propertyName.substring(idName.length() + 1);
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getDeclaredPersistentAttribute(element);
                        continue;
                    }
                    if (!TypeSafeActivator.isComposite(property)) {
                        return null;
                    }
                    property = ((Component)property.getValueMapping()).getProperty(element);
                }
            }
        }
        catch (MappingException e) {
            try {
                if (associatedClass.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping().getDeclaredPersistentAttribute(element);
                        continue;
                    }
                    if (!TypeSafeActivator.isComposite(property)) {
                        return null;
                    }
                    property = ((Component)property.getValueMapping()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    private static ValidatorFactory getValidatorFactory(ActivationContext activationContext) {
        ValidatorFactory factory = TypeSafeActivator.resolveProvidedFactory(activationContext.getSessionFactory().getSessionFactoryOptions());
        if (factory != null) {
            return factory;
        }
        factory = TypeSafeActivator.resolveProvidedFactory(activationContext.getServiceRegistry().getService(ConfigurationService.class));
        if (factory != null) {
            return factory;
        }
        try {
            return Validation.buildDefaultValidatorFactory();
        }
        catch (Exception e) {
            throw new IntegrationException("Unable to build the default ValidatorFactory", e);
        }
    }

    private static ValidatorFactory resolveProvidedFactory(SessionFactoryOptions options) {
        Object validatorFactoryReference = options.getValidatorFactoryReference();
        if (validatorFactoryReference == null) {
            return null;
        }
        try {
            return (ValidatorFactory)ValidatorFactory.class.cast(validatorFactoryReference);
        }
        catch (ClassCastException e) {
            throw new IntegrationException(String.format(Locale.ENGLISH, "ValidatorFactory reference (provided via %s) was not castable to %s : %s", SessionFactoryOptions.class.getName(), ValidatorFactory.class.getName(), validatorFactoryReference.getClass().getName()));
        }
    }

    private static ValidatorFactory resolveProvidedFactory(ConfigurationService cfgService) {
        return cfgService.getSetting(FACTORY_PROPERTY, new ConfigurationService.Converter<ValidatorFactory>(){

            @Override
            public ValidatorFactory convert(Object value) {
                try {
                    return (ValidatorFactory)ValidatorFactory.class.cast(value);
                }
                catch (ClassCastException e) {
                    throw new IntegrationException(String.format(Locale.ENGLISH, "ValidatorFactory reference (provided via `%s` setting) was not castable to %s : %s", TypeSafeActivator.FACTORY_PROPERTY, ValidatorFactory.class.getName(), value.getClass().getName()));
                }
            }
        }, null);
    }

    private static boolean isComposite(PersistentAttributeMapping property) {
        return Component.class.isInstance(property);
    }

    private static Column getColumn(PersistentAttributeMapping property) {
        return (Column)property.getValueMapping().getMappedColumns().get(0);
    }
}

