/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.CollectionElement;
import org.hibernate.metamodel.model.domain.spi.CollectionElementEmbedded;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.CollectionIndexEmbedded;
import org.hibernate.metamodel.model.domain.spi.DomainTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public abstract class AbstractPersistentCollection<E>
implements Serializable,
PersistentCollection<E> {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AbstractPersistentCollection.class);
    private transient SharedSessionContractImplementor session;
    private transient PersistentCollectionDescriptor<?, ?, E> collectionDescriptor;
    private NavigableRole role;
    private Object key;
    private boolean isTempSession = false;
    private boolean initialized;
    private transient List<DelayedOperation> operationQueue;
    private transient boolean directlyAccessible;
    private transient boolean initializing;
    private Object owner;
    private int cachedSize = -1;
    private boolean dirty;
    protected boolean elementRemoved;
    private Serializable storedSnapshot;
    private String sessionFactoryUuid;
    private boolean allowLoadOutsideTransaction;
    protected static final Object UNKNOWN = new MarkerObject("UNKNOWN");

    public AbstractPersistentCollection() {
    }

    protected AbstractPersistentCollection(SharedSessionContractImplementor session, PersistentCollectionDescriptor<?, ?, E> collectionDescriptor) {
        this.session = session;
        this.collectionDescriptor = collectionDescriptor;
        this.role = collectionDescriptor.getNavigableRole();
    }

    public AbstractPersistentCollection(SharedSessionContractImplementor session, PersistentCollectionDescriptor<?, ?, E> collectionDescriptor, Object key) {
        this(session, collectionDescriptor);
        this.key = key;
    }

    @Override
    public String getRole() {
        if (this.role == null) {
            return null;
        }
        return this.role.getFullPath();
    }

    @Override
    public PersistentCollectionDescriptor<?, ?, E> getCollectionDescriptor() {
        if (this.collectionDescriptor == null) {
            throw new HibernateException("Collection metadata is not available while disconnected");
        }
        return this.collectionDescriptor;
    }

    @Override
    public final Object getKey() {
        return this.key;
    }

    @Override
    public final boolean isUnreferenced() {
        return this.role == null;
    }

    @Override
    public final boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isElementRemoved() {
        return this.elementRemoved;
    }

    @Override
    public final void clearDirty() {
        this.dirty = false;
        this.elementRemoved = false;
    }

    @Override
    public final void dirty() {
        this.dirty = true;
    }

    @Override
    public final Serializable getStoredSnapshot() {
        return this.storedSnapshot;
    }

    @Override
    public abstract boolean empty();

    protected final void read() {
        this.initialize(false);
    }

    protected boolean readSize() {
        if (!this.initialized) {
            if (this.cachedSize != -1 && !this.hasQueuedOperations()) {
                return true;
            }
            boolean isExtraLazy = this.withTemporarySessionIfNeeded(new LazyInitializationWork<Boolean>(){

                @Override
                public Boolean doWork() {
                    CollectionEntry entry = AbstractPersistentCollection.this.session.getPersistenceContext().getCollectionEntry(AbstractPersistentCollection.this);
                    if (entry != null) {
                        PersistentCollectionDescriptor collectionDescriptor = entry.getLoadedCollectionDescriptor();
                        if (collectionDescriptor.isExtraLazy()) {
                            if (AbstractPersistentCollection.this.hasQueuedOperations()) {
                                AbstractPersistentCollection.this.session.flush();
                            }
                            AbstractPersistentCollection.this.cachedSize = collectionDescriptor.getSize(entry.getLoadedKey(), AbstractPersistentCollection.this.session);
                            return true;
                        }
                        AbstractPersistentCollection.this.read();
                    } else {
                        AbstractPersistentCollection.this.throwLazyInitializationExceptionIfNotConnected();
                    }
                    return false;
                }
            });
            if (isExtraLazy) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withTemporarySessionIfNeeded(LazyInitializationWork<T> lazyInitializationWork) {
        SharedSessionContractImplementor tempSession = null;
        if (this.session == null) {
            if (this.allowLoadOutsideTransaction) {
                tempSession = this.openTemporarySessionForLoading();
            } else {
                this.throwLazyInitializationException("could not initialize proxy - no Session");
            }
        } else if (!this.session.isOpenOrWaitingForAutoClose()) {
            if (this.allowLoadOutsideTransaction) {
                tempSession = this.openTemporarySessionForLoading();
            } else {
                this.throwLazyInitializationException("could not initialize proxy - the owning Session was closed");
            }
        } else if (!this.session.isConnected()) {
            if (this.allowLoadOutsideTransaction) {
                tempSession = this.openTemporarySessionForLoading();
            } else {
                this.throwLazyInitializationException("could not initialize proxy - the owning Session is disconnected");
            }
        }
        SharedSessionContractImplementor originalSession = null;
        boolean isJTA = false;
        if (tempSession != null) {
            this.isTempSession = true;
            originalSession = this.session;
            this.session = tempSession;
            isJTA = this.session.getTransactionCoordinator().getTransactionCoordinatorBuilder().isJta();
            if (!isJTA) {
                this.session.beginTransaction();
            }
            this.session.getPersistenceContext().addUninitializedDetachedCollection(this.session.getFactory().getMetamodel().findCollectionDescriptor(this.getRole()), this);
        }
        try {
            T t = lazyInitializationWork.doWork();
            return t;
        }
        finally {
            if (tempSession != null) {
                this.isTempSession = false;
                this.session = originalSession;
                try {
                    if (!isJTA) {
                        tempSession.getTransaction().commit();
                    }
                    tempSession.close();
                }
                catch (Exception e) {
                    LOG.warn("Unable to close temporary session used to load lazy collection associated to no session");
                }
            }
        }
    }

    private SharedSessionContractImplementor openTemporarySessionForLoading() {
        if (this.sessionFactoryUuid == null) {
            this.throwLazyInitializationException("SessionFactory UUID not known to create temporary Session for loading");
        }
        SessionFactoryImplementor sf = (SessionFactoryImplementor)SessionFactoryRegistry.INSTANCE.getSessionFactory(this.sessionFactoryUuid);
        SharedSessionContractImplementor session = (SharedSessionContractImplementor)((Object)sf.openSession());
        session.getPersistenceContext().setDefaultReadOnly(true);
        session.setFlushMode(FlushMode.MANUAL);
        return session;
    }

    protected Boolean readIndexExistence(final Object index) {
        Boolean extraLazyExistenceCheck;
        if (!this.initialized && (extraLazyExistenceCheck = this.withTemporarySessionIfNeeded(new LazyInitializationWork<Boolean>(){

            @Override
            public Boolean doWork() {
                CollectionEntry entry = AbstractPersistentCollection.this.session.getPersistenceContext().getCollectionEntry(AbstractPersistentCollection.this);
                PersistentCollectionDescriptor collectionDescriptor = entry.getLoadedCollectionDescriptor();
                if (collectionDescriptor.isExtraLazy()) {
                    if (AbstractPersistentCollection.this.hasQueuedOperations()) {
                        AbstractPersistentCollection.this.session.flush();
                    }
                    return collectionDescriptor.indexExists(entry.getLoadedKey(), index, AbstractPersistentCollection.this.session);
                }
                AbstractPersistentCollection.this.read();
                return null;
            }
        })) != null) {
            return extraLazyExistenceCheck;
        }
        return null;
    }

    protected Boolean readElementExistence(final Object element) {
        Boolean extraLazyExistenceCheck;
        if (!this.initialized && (extraLazyExistenceCheck = this.withTemporarySessionIfNeeded(new LazyInitializationWork<Boolean>(){

            @Override
            public Boolean doWork() {
                CollectionEntry entry = AbstractPersistentCollection.this.session.getPersistenceContext().getCollectionEntry(AbstractPersistentCollection.this);
                PersistentCollectionDescriptor collectionDescriptor = entry.getLoadedCollectionDescriptor();
                if (collectionDescriptor.isExtraLazy()) {
                    if (AbstractPersistentCollection.this.hasQueuedOperations()) {
                        AbstractPersistentCollection.this.session.flush();
                    }
                    return collectionDescriptor.elementExists(entry.getLoadedKey(), element, AbstractPersistentCollection.this, AbstractPersistentCollection.this.session);
                }
                AbstractPersistentCollection.this.read();
                return null;
            }
        })) != null) {
            return extraLazyExistenceCheck;
        }
        return null;
    }

    protected E readElementByIndex(final Object index) {
        if (!this.initialized) {
            class ExtraLazyElementByIndexReader<E>
            implements LazyInitializationWork {
                private boolean isExtraLazy;
                private E element;

                ExtraLazyElementByIndexReader() {
                }

                public E doWork() {
                    CollectionEntry entry = AbstractPersistentCollection.this.session.getPersistenceContext().getCollectionEntry(AbstractPersistentCollection.this);
                    PersistentCollectionDescriptor collectionDescriptor = entry.getLoadedCollectionDescriptor();
                    this.isExtraLazy = collectionDescriptor.isExtraLazy();
                    if (this.isExtraLazy) {
                        if (AbstractPersistentCollection.this.hasQueuedOperations()) {
                            AbstractPersistentCollection.this.session.flush();
                        }
                        this.element = collectionDescriptor.getElementByIndex(entry.getLoadedKey(), index, AbstractPersistentCollection.this.session, AbstractPersistentCollection.this.owner);
                    } else {
                        AbstractPersistentCollection.this.read();
                    }
                    return null;
                }
            }
            ExtraLazyElementByIndexReader reader = new ExtraLazyElementByIndexReader();
            this.withTemporarySessionIfNeeded(reader);
            if (reader.isExtraLazy) {
                return (E)reader.element;
            }
        }
        return (E)UNKNOWN;
    }

    protected int getCachedSize() {
        return this.cachedSize;
    }

    protected boolean isConnectedToSession() {
        return this.session != null && this.session.isOpen() && this.session.getPersistenceContext().containsCollection(this);
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected boolean isInitializing() {
        return this.initializing;
    }

    protected final void write() {
        this.initialize(true);
        this.dirty();
    }

    protected boolean isOperationQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseCollection();
    }

    protected boolean isPutQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseOneToManyOrNoOrphanDelete();
    }

    protected boolean isClearQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseCollectionNoOrphanDelete();
    }

    protected boolean isInverseCollection() {
        CollectionEntry ce = this.session.getPersistenceContext().getCollectionEntry(this);
        return ce != null && ce.getLoadedCollectionDescriptor().isInverse();
    }

    protected boolean isInverseCollectionNoOrphanDelete() {
        CollectionEntry ce = this.session.getPersistenceContext().getCollectionEntry(this);
        return ce != null && ce.getLoadedCollectionDescriptor().isInverse() && !ce.getLoadedCollectionDescriptor().hasOrphanDelete();
    }

    protected boolean isInverseOneToManyOrNoOrphanDelete() {
        CollectionEntry ce = this.session.getPersistenceContext().getCollectionEntry(this);
        return ce != null && ce.getLoadedCollectionDescriptor().isInverse() && (ce.getLoadedCollectionDescriptor().isOneToMany() || !ce.getLoadedCollectionDescriptor().hasOrphanDelete());
    }

    protected final void queueOperation(DelayedOperation operation) {
        if (this.operationQueue == null) {
            this.operationQueue = new ArrayList<DelayedOperation>(10);
        }
        this.operationQueue.add(operation);
        this.dirty = true;
    }

    public final void replaceQueuedOperationValues(PersistentCollectionDescriptor descriptor, Map copyCache) {
        for (DelayedOperation operation : this.operationQueue) {
            if (!ValueDelayedOperation.class.isInstance(operation)) continue;
            ((ValueDelayedOperation)operation).replace(descriptor, copyCache);
        }
    }

    protected final void performQueuedOperations() {
        for (DelayedOperation operation : this.operationQueue) {
            operation.operate();
        }
        this.clearOperationQueue();
    }

    @Override
    public void setSnapshot(Object key, NavigableRole role, Serializable snapshot) {
        this.key = key;
        this.role = role;
        this.storedSnapshot = snapshot;
    }

    @Override
    public void postAction() {
        this.clearOperationQueue();
        this.cachedSize = -1;
        this.clearDirty();
    }

    public final void clearOperationQueue() {
        this.operationQueue = null;
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public void beginRead() {
        this.initializing = true;
    }

    @Override
    public boolean endRead() {
        return this.afterInitialize();
    }

    @Override
    public boolean afterInitialize() {
        this.setInitialized();
        if (this.hasQueuedOperations()) {
            this.performQueuedOperations();
            this.cachedSize = -1;
            return false;
        }
        return true;
    }

    protected final void initialize(final boolean writing) {
        if (this.initialized) {
            return;
        }
        this.withTemporarySessionIfNeeded(new LazyInitializationWork<Object>(){

            @Override
            public Object doWork() {
                AbstractPersistentCollection.this.session.initializeCollection(AbstractPersistentCollection.this, writing);
                return null;
            }
        });
    }

    private void throwLazyInitializationExceptionIfNotConnected() {
        if (!this.isConnectedToSession()) {
            this.throwLazyInitializationException("no session or session was closed");
        }
        if (!this.session.isConnected()) {
            this.throwLazyInitializationException("session is disconnected");
        }
    }

    private void throwLazyInitializationException(String message) {
        throw new LazyInitializationException("failed to lazily initialize a collection" + (this.role == null ? "" : " of role: " + this.role) + ", " + message);
    }

    protected final void setInitialized() {
        this.initializing = false;
        this.initialized = true;
    }

    protected final void setDirectlyAccessible(boolean directlyAccessible) {
        this.directlyAccessible = directlyAccessible;
    }

    @Override
    public boolean isDirectlyAccessible() {
        return this.directlyAccessible;
    }

    @Override
    public final boolean unsetSession(SharedSessionContractImplementor currentSession) {
        this.prepareForPossibleLoadingOutsideTransaction();
        if (currentSession == this.session) {
            if (!this.isTempSession) {
                if (this.hasQueuedOperations()) {
                    String collectionInfoString = MessageHelper.collectionInfoString(this.getRole(), this.getKey());
                    try {
                        TransactionStatus transactionStatus = this.session.getTransactionCoordinator().getTransactionDriverControl().getStatus();
                        if (transactionStatus.isOneOf(TransactionStatus.ROLLED_BACK, TransactionStatus.MARKED_ROLLBACK, TransactionStatus.FAILED_COMMIT, TransactionStatus.FAILED_ROLLBACK, TransactionStatus.ROLLING_BACK)) {
                            LOG.queuedOperationWhenDetachFromSessionOnRollback(collectionInfoString);
                        } else {
                            LOG.queuedOperationWhenDetachFromSession(collectionInfoString);
                        }
                    }
                    catch (Exception e) {
                        LOG.queuedOperationWhenDetachFromSession(collectionInfoString);
                    }
                }
                this.session = null;
            }
            return true;
        }
        if (this.session != null) {
            LOG.logCannotUnsetUnexpectedSessionInCollection(this.generateUnexpectedSessionStateMessage(currentSession));
        }
        return false;
    }

    protected void prepareForPossibleLoadingOutsideTransaction() {
        if (this.session != null) {
            this.allowLoadOutsideTransaction = this.session.getFactory().getSessionFactoryOptions().isInitializeLazyStateOutsideTransactionsEnabled();
            if (this.allowLoadOutsideTransaction && this.sessionFactoryUuid == null) {
                this.sessionFactoryUuid = this.session.getFactory().getUuid();
            }
        }
    }

    @Override
    public final boolean setCurrentSession(SharedSessionContractImplementor session) throws HibernateException {
        if (session == this.session) {
            if (this.collectionDescriptor == null) {
                this.collectionDescriptor = session.getFactory().getMetamodel().findCollectionDescriptor(this.getRole());
            }
            return false;
        }
        if (this.session != null) {
            assert (this.collectionDescriptor != null);
            String msg = this.generateUnexpectedSessionStateMessage(session);
            if (this.isConnectedToSession()) {
                throw new HibernateException("Illegal attempt to associate a collection with two open sessions. " + msg);
            }
            LOG.logUnexpectedSessionInCollectionNotConnected(msg);
        }
        if (this.hasQueuedOperations()) {
            LOG.queuedOperationWhenAttachToSession(MessageHelper.collectionInfoString(this.getRole(), this.getKey()));
        }
        this.session = session;
        return true;
    }

    private String generateUnexpectedSessionStateMessage(SharedSessionContractImplementor session) {
        NavigableRole roleCurrent = this.role;
        Object keyCurrent = this.key;
        StringBuilder sb = new StringBuilder("Collection : ");
        if (roleCurrent != null) {
            sb.append(MessageHelper.collectionInfoString(roleCurrent.getFullPath(), keyCurrent));
        } else {
            CollectionEntry ce = session.getPersistenceContext().getCollectionEntry(this);
            if (ce != null) {
                sb.append(MessageHelper.collectionInfoString(ce.getLoadedCollectionDescriptor(), (PersistentCollection)this, ce.getLoadedKey(), session));
            } else {
                sb.append("<unknown>");
            }
        }
        if (LOG.isDebugEnabled()) {
            String collectionContents = this.wasInitialized() ? this.toString() : "<uninitialized>";
            sb.append("\nCollection contents: [").append(collectionContents).append("]");
        }
        return sb.toString();
    }

    @Override
    public boolean needsRecreate(PersistentCollectionDescriptor collectionDescriptor) {
        CollectionIndex indexDescriptor = this.getCollectionDescriptor().getIndexDescriptor();
        if (indexDescriptor != null) {
            if (indexDescriptor instanceof CollectionIndexEmbedded) {
                return !indexDescriptor.hasNotNullColumns();
            }
        } else {
            CollectionDomainType.Element elementDescriptor = this.getCollectionDescriptor().getElementDescriptor();
            if (elementDescriptor instanceof CollectionElementEmbedded) {
                return !elementDescriptor.hasNotNullColumns();
            }
        }
        return false;
    }

    @Override
    public final void forceInitialization() throws HibernateException {
        if (!this.initialized) {
            if (this.initializing) {
                throw new AssertionFailure("force initialize loading collection");
            }
            this.initialize(false);
        }
    }

    protected final Serializable getSnapshot() {
        return this.session.getPersistenceContext().getSnapshot(this);
    }

    @Override
    public final boolean wasInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isRowUpdatePossible() {
        return true;
    }

    @Override
    public final boolean hasQueuedOperations() {
        return this.operationQueue != null;
    }

    @Override
    public final Iterator queuedAdditionIterator() {
        if (this.hasQueuedOperations()) {
            return new Iterator(){
                private int index;

                public Object next() {
                    return ((DelayedOperation)AbstractPersistentCollection.this.operationQueue.get(this.index++)).getAddedInstance();
                }

                @Override
                public boolean hasNext() {
                    return this.index < AbstractPersistentCollection.this.operationQueue.size();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return Collections.emptyIterator();
    }

    @Override
    public final Collection getQueuedOrphans(String entityName) {
        if (this.hasQueuedOperations()) {
            ArrayList<Object> additions = new ArrayList<Object>(this.operationQueue.size());
            ArrayList<Object> removals = new ArrayList<Object>(this.operationQueue.size());
            for (DelayedOperation operation : this.operationQueue) {
                additions.add(operation.getAddedInstance());
                removals.add(operation.getOrphan());
            }
            return AbstractPersistentCollection.getOrphans(removals, additions, entityName, this.session);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void preInsert(PersistentCollectionDescriptor descriptor) throws HibernateException {
    }

    @Override
    public void afterRowInsert(PersistentCollectionDescriptor descriptor, Object entry, int i) throws HibernateException {
    }

    @Override
    public abstract Collection getOrphans(Serializable var1, String var2) throws HibernateException;

    public final SharedSessionContractImplementor getSession() {
        return this.session;
    }

    protected static Collection getOrphans(Collection oldElements, Collection currentElements, String entityName, SharedSessionContractImplementor session) throws HibernateException {
        if (currentElements.size() == 0) {
            return oldElements;
        }
        if (oldElements.size() == 0) {
            return oldElements;
        }
        EntityTypeDescriptor entityDescriptor = session.getFactory().getMetamodel().getEntityDescriptor(entityName);
        DomainTypeDescriptor idType = entityDescriptor.getIdentifierDescriptor().getNavigableType();
        boolean useIdDirect = AbstractPersistentCollection.mayUseIdDirect((SimpleTypeDescriptor)idType);
        ArrayList res = new ArrayList();
        HashSet<Object> currentIds = new HashSet<Object>();
        IdentitySet currentSaving = new IdentitySet();
        for (Object current : currentElements) {
            if (current == null || !ForeignKeys.isNotTransient(entityName, current, null, session)) continue;
            EntityEntry ee = session.getPersistenceContext().getEntry(current);
            if (ee != null && ee.getStatus() == Status.SAVING) {
                currentSaving.add(current);
                continue;
            }
            Object currentId = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, current, session);
            currentIds.add(useIdDirect ? currentId : new TypedValue((JavaTypeDescriptor)idType.getJavaTypeDescriptor(), currentId));
        }
        for (Object old : oldElements) {
            if (currentSaving.contains(old)) continue;
            Object oldId = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, old, session);
            if (currentIds.contains(useIdDirect ? oldId : new TypedValue((JavaTypeDescriptor)idType.getJavaTypeDescriptor(), oldId))) continue;
            res.add(old);
        }
        return res;
    }

    private static boolean mayUseIdDirect(SimpleTypeDescriptor idType) {
        return idType == StandardSpiBasicTypes.STRING || idType == StandardSpiBasicTypes.INTEGER || idType == StandardSpiBasicTypes.LONG || idType == StandardSpiBasicTypes.UUID_BINARY || idType == StandardSpiBasicTypes.UUID_CHAR;
    }

    public static void identityRemove(Collection list, Object entityInstance, String entityName, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception();
    }

    @Deprecated
    public static void identityRemove(Collection list, Object entityInstance, String entityName, SessionImplementor session) {
        AbstractPersistentCollection.identityRemove(list, entityInstance, entityName, (SharedSessionContractImplementor)session);
    }

    @Override
    public Object getIdentifier(Object entry, int assumedIdentifier, PersistentCollectionDescriptor collectionDescriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Object owner) {
        this.owner = owner;
    }

    protected abstract class AbstractValueDelayedOperation
    implements ValueDelayedOperation {
        private E addedValue;
        private Object orphan;

        protected AbstractValueDelayedOperation(E addedValue, Object orphan) {
            this.addedValue = addedValue;
            this.orphan = orphan;
        }

        @Override
        public void replace(PersistentCollectionDescriptor descriptor, Map copyCache) {
            if (this.addedValue != null) {
                this.addedValue = this.getReplacement((CollectionElement)descriptor.getElementDescriptor(), this.addedValue, copyCache);
            }
        }

        protected final E getReplacement(CollectionElement elementDescriptor, E current, Map copyCache) {
            return elementDescriptor.replace(current, null, AbstractPersistentCollection.this.owner, copyCache, (SessionImplementor)AbstractPersistentCollection.this.session);
        }

        public final E getAddedInstance() {
            return this.addedValue;
        }

        @Override
        public final Object getOrphan() {
            return this.orphan;
        }
    }

    protected static interface ValueDelayedOperation
    extends DelayedOperation {
        public void replace(PersistentCollectionDescriptor var1, Map var2);
    }

    protected static interface DelayedOperation {
        public void operate();

        public Object getAddedInstance();

        public Object getOrphan();
    }

    protected final class ListProxy
    implements List<E> {
        protected final List<E> list;

        public ListProxy(List<E> list) {
            this.list = list;
        }

        @Override
        public void add(int index, E value) {
            AbstractPersistentCollection.this.write();
            this.list.add(index, value);
        }

        @Override
        public boolean add(E o) {
            AbstractPersistentCollection.this.write();
            return this.list.add(o);
        }

        @Override
        public boolean addAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.list.addAll(c);
        }

        @Override
        public boolean addAll(int i, Collection c) {
            AbstractPersistentCollection.this.write();
            return this.list.addAll(i, c);
        }

        @Override
        public void clear() {
            AbstractPersistentCollection.this.write();
            this.list.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.list.containsAll(c);
        }

        @Override
        public E get(int i) {
            return this.list.get(i);
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new IteratorProxy(this.list.iterator());
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return new ListIteratorProxy(this.list.listIterator());
        }

        @Override
        public ListIterator listIterator(int i) {
            return new ListIteratorProxy(this.list.listIterator(i));
        }

        @Override
        public E remove(int i) {
            AbstractPersistentCollection.this.write();
            return this.list.remove(i);
        }

        @Override
        public boolean remove(Object o) {
            AbstractPersistentCollection.this.write();
            return this.list.remove(o);
        }

        @Override
        public boolean removeAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.list.retainAll(c);
        }

        @Override
        public E set(int i, E o) {
            AbstractPersistentCollection.this.write();
            return this.list.set(i, o);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public List subList(int i, int j) {
            return this.list.subList(i, j);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public Object[] toArray(Object[] array) {
            return this.list.toArray(array);
        }
    }

    protected class SetProxy
    implements Set {
        protected final Collection set;

        public SetProxy(Collection set) {
            this.set = set;
        }

        @Override
        public boolean add(Object o) {
            AbstractPersistentCollection.this.write();
            return this.set.add(o);
        }

        @Override
        public boolean addAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.set.addAll(c);
        }

        @Override
        public void clear() {
            AbstractPersistentCollection.this.write();
            this.set.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.set.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new IteratorProxy(this.set.iterator());
        }

        @Override
        public boolean remove(Object o) {
            AbstractPersistentCollection.this.write();
            return this.set.remove(o);
        }

        @Override
        public boolean removeAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.set.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.set.retainAll(c);
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public Object[] toArray(Object[] array) {
            return this.set.toArray(array);
        }
    }

    protected final class ListIteratorProxy
    implements ListIterator {
        protected final ListIterator itr;

        public ListIteratorProxy(ListIterator itr) {
            this.itr = itr;
        }

        public void add(Object o) {
            AbstractPersistentCollection.this.write();
            this.itr.add(o);
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.itr.hasPrevious();
        }

        @Override
        public Object next() {
            return this.itr.next();
        }

        @Override
        public int nextIndex() {
            return this.itr.nextIndex();
        }

        public Object previous() {
            return this.itr.previous();
        }

        @Override
        public int previousIndex() {
            return this.itr.previousIndex();
        }

        @Override
        public void remove() {
            AbstractPersistentCollection.this.write();
            this.itr.remove();
        }

        public void set(Object o) {
            AbstractPersistentCollection.this.write();
            this.itr.set(o);
        }
    }

    protected final class IteratorProxy
    implements Iterator<E> {
        protected final Iterator<E> itr;

        public IteratorProxy(Iterator<E> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public E next() {
            return this.itr.next();
        }

        @Override
        public void remove() {
            AbstractPersistentCollection.this.write();
            this.itr.remove();
        }
    }

    public static interface LazyInitializationWork<T> {
        public T doWork();
    }
}

