/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.jboss.logging.Logger;

public class PersistentArrayHolder
extends AbstractPersistentCollection {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)PersistentArrayHolder.class.getName());
    protected Object array;
    private transient List tempList;

    public PersistentArrayHolder(SharedSessionContractImplementor session, PersistentCollectionDescriptor collectionDescriptor) {
        super(session, collectionDescriptor);
    }

    public PersistentArrayHolder(SharedSessionContractImplementor session, PersistentCollectionDescriptor descriptor, Object array) {
        this(session, descriptor);
        this.setArray(array);
    }

    private void setArray(Object array) {
        this.array = array;
        this.setInitialized();
    }

    public PersistentArrayHolder(Object key, SharedSessionContractImplementor session, PersistentCollectionDescriptor descriptor) {
        super(session, descriptor, key);
    }

    @Override
    public Serializable getSnapshot(PersistentCollectionDescriptor descriptor) {
        int length = Array.getLength(this.array);
        Serializable result = (Serializable)Array.newInstance(descriptor.getElementDescriptor().getJavaType(), length);
        for (int i = 0; i < length; ++i) {
            Object elt = Array.get(this.array, i);
            try {
                Array.set(result, i, descriptor.getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().deepCopy(elt));
                continue;
            }
            catch (IllegalArgumentException iae) {
                LOG.invalidArrayElementType(iae.getMessage());
                throw new HibernateException("Array element type error", iae);
            }
        }
        return result;
    }

    @Override
    public boolean isSnapshotEmpty(Serializable snapshot) {
        return Array.getLength(snapshot) == 0;
    }

    @Override
    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        Object[] sn = (Object[])snapshot;
        Object[] arr = (Object[])this.array;
        ArrayList result = new ArrayList();
        Collections.addAll(result, sn);
        for (int i = 0; i < sn.length; ++i) {
            PersistentArrayHolder.identityRemove(result, arr[i], entityName, this.getSession());
        }
        return result;
    }

    public Object getArray() {
        return this.array;
    }

    @Override
    public boolean isWrapper(Object collection) {
        return this.array == collection;
    }

    @Override
    public boolean equalsSnapshot(PersistentCollectionDescriptor collectionDescriptor) throws HibernateException {
        Serializable snapshot = this.getSnapshot();
        int xlen = Array.getLength(snapshot);
        if (xlen != Array.getLength(this.array)) {
            return false;
        }
        for (int i = 0; i < xlen; ++i) {
            if (!collectionDescriptor.isDirty(Array.get(snapshot, i), Array.get(this.array, i), this.getSession())) continue;
            return false;
        }
        return true;
    }

    public Iterator elements() {
        int length = Array.getLength(this.array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(this.array, i));
        }
        return list.iterator();
    }

    @Override
    public boolean empty() {
        return false;
    }

    public void load(int index, Object element) {
        assert (this.isInitializing());
        for (int i = this.tempList.size(); i <= index; ++i) {
            this.tempList.add(i, null);
        }
        this.tempList.set(index, element);
    }

    @Override
    public Iterator entries(PersistentCollectionDescriptor descriptor) {
        return this.elements();
    }

    @Override
    public void beginRead() {
        super.beginRead();
        this.tempList = new ArrayList();
    }

    @Override
    public boolean endRead() {
        this.setInitialized();
        this.createArray();
        this.tempList = null;
        return true;
    }

    private void createArray() {
        this.array = Array.newInstance(this.getCollectionDescriptor().getElementClass(), this.tempList.size());
        for (int i = 0; i < this.tempList.size(); ++i) {
            Array.set(this.array, i, this.tempList.get(i));
        }
    }

    @Override
    public void beforeInitialize(int anticipatedSize, PersistentCollectionDescriptor collectionDescriptor) {
    }

    @Override
    public boolean isDirectlyAccessible() {
        return true;
    }

    @Override
    public void initializeFromCache(Serializable disassembled, Object owner, PersistentCollectionDescriptor collectionDescriptor) {
        Serializable[] cached = (Serializable[])disassembled;
        this.array = Array.newInstance(this.getCollectionDescriptor().getElementDescriptor().getJavaType(), cached.length);
        for (int i = 0; i < cached.length; ++i) {
            Array.set(this.array, i, this.getCollectionDescriptor().getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().assemble(cached[i]));
        }
    }

    @Override
    public Serializable disassemble(PersistentCollectionDescriptor collectionDescriptor) throws HibernateException {
        int length = Array.getLength(this.array);
        Serializable[] result = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            result[i] = collectionDescriptor.getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().disassemble(Array.get(this.array, i));
        }
        return result;
    }

    @Override
    public Object getValue() {
        if (this.tempList != null) {
            this.createArray();
        }
        return this.array;
    }

    @Override
    public Iterator getDeletes(PersistentCollectionDescriptor descriptor, boolean indexIsFormula) throws HibernateException {
        int end;
        int i;
        int arraySize;
        ArrayList<Integer> deletes = new ArrayList<Integer>();
        Serializable sn = this.getSnapshot();
        int snSize = Array.getLength(sn);
        if (snSize > (arraySize = Array.getLength(this.array))) {
            for (i = arraySize; i < snSize; ++i) {
                deletes.add(i);
            }
            end = arraySize;
        } else {
            end = snSize;
        }
        for (i = 0; i < end; ++i) {
            if (Array.get(this.array, i) != null || Array.get(sn, i) == null) continue;
            deletes.add(i);
        }
        return deletes.iterator();
    }

    @Override
    public boolean needsInserting(Object entry, int i) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return Array.get(this.array, i) != null && (i >= Array.getLength(sn) || Array.get(sn, i) == null);
    }

    @Override
    public boolean needsUpdating(Object entry, int i) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return i < Array.getLength(sn) && Array.get(sn, i) != null && Array.get(this.array, i) != null && this.getCollectionDescriptor().isDirty(Array.get(this.array, i), Array.get(sn, i), this.getSession());
    }

    @Override
    public Object getIndex(Object entry, int assumedIndex, PersistentCollectionDescriptor collectionDescriptor) {
        return assumedIndex;
    }

    @Override
    public Object getElement(Object entry, PersistentCollectionDescriptor collectionDescriptor) {
        return entry;
    }

    @Override
    public Object getSnapshotElement(Object entry, int index) {
        Serializable sn = this.getSnapshot();
        return Array.get(sn, index);
    }

    @Override
    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }
}

