/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public class PersistentBag<E>
extends AbstractPersistentCollection<E>
implements List<E> {
    private List<E> bag;

    public PersistentBag() {
    }

    public PersistentBag(SharedSessionContractImplementor session, PersistentCollectionDescriptor collectionDescriptor) {
        super(session, collectionDescriptor);
    }

    public PersistentBag(SharedSessionContractImplementor session, PersistentCollectionDescriptor<?, Collection<E>, E> descriptor, Collection coll) {
        this(session, (PersistentCollectionDescriptor)descriptor);
        super.setRawCollection(coll);
    }

    private void setRawCollection(Collection coll) {
        if (coll instanceof List) {
            this.bag = (List)coll;
        } else {
            this.bag = new ArrayList();
            this.bag.addAll(coll);
        }
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    public PersistentBag(SharedSessionContractImplementor session, PersistentCollectionDescriptor descriptor, Object key) {
        super(session, descriptor, key);
    }

    @Override
    public boolean isWrapper(Object collection) {
        return this.bag == collection;
    }

    @Override
    public boolean empty() {
        return this.bag.isEmpty();
    }

    @Override
    public Iterator entries(PersistentCollectionDescriptor descriptor) {
        return this.bag.iterator();
    }

    @Override
    public void beforeInitialize(int anticipatedSize, PersistentCollectionDescriptor collectionDescriptor) {
        this.bag = (List)this.getCollectionDescriptor().instantiateRaw(anticipatedSize);
    }

    @Override
    public boolean equalsSnapshot(PersistentCollectionDescriptor collectionDescriptor) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() != this.bag.size()) {
            return false;
        }
        for (E elt : this.bag) {
            boolean unequal = this.countOccurrences(elt, this.bag) != this.countOccurrences(elt, sn);
            if (!unequal) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSnapshotEmpty(Serializable snapshot) {
        return ((Collection)((Object)snapshot)).isEmpty();
    }

    private int countOccurrences(Object element, List list) {
        Iterator iter = list.iterator();
        int result = 0;
        while (iter.hasNext()) {
            if (!this.getCollectionDescriptor().getElementDescriptor().getJavaTypeDescriptor().areEqual(element, iter.next())) continue;
            ++result;
        }
        return result;
    }

    @Override
    public Serializable getSnapshot(PersistentCollectionDescriptor descriptor) throws HibernateException {
        ArrayList clonedList = new ArrayList(this.bag.size());
        for (E item : this.bag) {
            clonedList.add(this.getCollectionDescriptor().getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().deepCopy(item));
        }
        return clonedList;
    }

    @Override
    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        List sn = (List)((Object)snapshot);
        return PersistentBag.getOrphans(sn, this.bag, entityName, this.getSession());
    }

    @Override
    public Serializable disassemble(PersistentCollectionDescriptor collectionDescriptor) throws HibernateException {
        int length = this.bag.size();
        Serializable[] result = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getCollectionDescriptor().getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().disassemble(this.bag.get(i));
        }
        return result;
    }

    @Override
    public void initializeFromCache(Serializable disassembled, Object owner, PersistentCollectionDescriptor collectionDescriptor) throws HibernateException {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean needsRecreate(PersistentCollectionDescriptor collectionDescriptor) {
        return !collectionDescriptor.isOneToMany();
    }

    @Override
    public Iterator getDeletes(PersistentCollectionDescriptor descriptor, boolean indexIsFormula) throws HibernateException {
        ArrayList deletes = new ArrayList();
        List sn = (List)((Object)this.getSnapshot());
        int i = 0;
        for (Object old : sn) {
            boolean found = false;
            if (this.bag.size() > i && this.getCollectionDescriptor().getElementDescriptor().getJavaTypeDescriptor().areEqual(old, this.bag.get(i++))) {
                found = true;
            } else {
                for (E aBag : this.bag) {
                    if (!this.getCollectionDescriptor().getElementDescriptor().getJavaTypeDescriptor().areEqual(old, aBag)) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            deletes.add(old);
        }
        return deletes.iterator();
    }

    @Override
    public boolean needsInserting(Object entry, int i) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() > i && this.getCollectionDescriptor().getElementDescriptor().getJavaTypeDescriptor().areEqual(sn.get(i), entry)) {
            return false;
        }
        for (Object old : sn) {
            if (!this.getCollectionDescriptor().getElementDescriptor().getJavaTypeDescriptor().areEqual(old, entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRowUpdatePossible() {
        return false;
    }

    @Override
    public boolean needsUpdating(Object entry, int i) {
        return false;
    }

    @Override
    public int size() {
        return this.readSize() ? this.getCachedSize() : this.bag.size();
    }

    @Override
    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.bag.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        Boolean exists = this.readElementExistence(object);
        return exists == null ? this.bag.contains(object) : exists.booleanValue();
    }

    @Override
    public Iterator<E> iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy(this.bag.iterator());
    }

    @Override
    public Object[] toArray() {
        this.read();
        return this.bag.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        this.read();
        return this.bag.toArray(a);
    }

    @Override
    public boolean add(E object) {
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.bag.add(object);
        }
        this.queueOperation(new SimpleAdd(object));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.initialize(true);
        if (this.bag.remove(o)) {
            this.elementRemoved = true;
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection c) {
        this.read();
        return this.bag.containsAll(c);
    }

    @Override
    public boolean addAll(Collection values) {
        if (values.size() == 0) {
            return false;
        }
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.bag.addAll(values);
        }
        for (Object value : values) {
            this.queueOperation(new SimpleAdd(value));
        }
        return values.size() > 0;
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c.size() > 0) {
            this.initialize(true);
            if (this.bag.removeAll(c)) {
                this.elementRemoved = true;
                this.dirty();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection c) {
        this.initialize(true);
        if (this.bag.retainAll(c)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.isClearQueueEnabled()) {
            this.queueOperation(new Clear());
        } else {
            this.initialize(true);
            if (!this.bag.isEmpty()) {
                this.bag.clear();
                this.dirty();
            }
        }
    }

    @Override
    public Object getIndex(Object entry, int assumedIndex, PersistentCollectionDescriptor collectionDescriptor) {
        throw new UnsupportedOperationException("Bags don't have indexes");
    }

    @Override
    public E getElement(Object entry, PersistentCollectionDescriptor collectionDescriptor) {
        return (E)entry;
    }

    @Override
    public E getSnapshotElement(Object entry, int index) {
        List sn = (List)((Object)this.getSnapshot());
        return sn.get(index);
    }

    public int occurrences(Object o) {
        this.read();
        Iterator<E> itr = this.bag.iterator();
        int result = 0;
        while (itr.hasNext()) {
            if (!o.equals(itr.next())) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void add(int i, E o) {
        this.write();
        this.bag.add(i, o);
    }

    @Override
    public boolean addAll(int i, Collection c) {
        if (c.size() > 0) {
            this.write();
            return this.bag.addAll(i, c);
        }
        return false;
    }

    @Override
    public E get(int i) {
        this.read();
        return this.bag.get(i);
    }

    @Override
    public int indexOf(Object o) {
        this.read();
        return this.bag.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.read();
        return this.bag.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.bag.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int i) {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.bag.listIterator(i));
    }

    @Override
    public E remove(int i) {
        this.write();
        return this.bag.remove(i);
    }

    @Override
    public E set(int i, E o) {
        this.write();
        return this.bag.set(i, o);
    }

    @Override
    public List<E> subList(int start, int end) {
        this.read();
        return new AbstractPersistentCollection.ListProxy(this.bag.subList(start, end));
    }

    @Override
    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }

    public String toString() {
        this.read();
        return this.bag.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public void load(E element) {
        assert (this.isInitializing());
        this.bag.add(element);
    }

    final class SimpleAdd
    extends AbstractPersistentCollection.AbstractValueDelayedOperation {
        public SimpleAdd(E addedValue) {
            super(addedValue, null);
        }

        @Override
        public void operate() {
            PersistentBag.this.bag.add(this.getAddedInstance());
        }
    }

    final class Clear
    implements AbstractPersistentCollection.DelayedOperation {
        Clear() {
        }

        @Override
        public void operate() {
            PersistentBag.this.bag.clear();
        }

        @Override
        public Object getAddedInstance() {
            return null;
        }

        @Override
        public Object getOrphan() {
            throw new UnsupportedOperationException("queued clear cannot be used with orphan delete");
        }
    }
}

