/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public class PersistentIdentifierBag<E>
extends AbstractPersistentCollection<E>
implements List<E> {
    protected List<E> values;
    protected Map<Integer, Object> identifiers;

    public PersistentIdentifierBag() {
    }

    public PersistentIdentifierBag(SharedSessionContractImplementor session, PersistentCollectionDescriptor<?, ?, E> collectionDescriptor) {
        super(session, collectionDescriptor);
    }

    public PersistentIdentifierBag(SharedSessionContractImplementor session, PersistentCollectionDescriptor<?, ?, E> collectionDescriptor, Object key) {
        super(session, collectionDescriptor, key);
    }

    public PersistentIdentifierBag(SharedSessionContractImplementor session, PersistentCollectionDescriptor<?, ?, E> collectionDescriptor, Collection<E> rawCollection) {
        super(session, collectionDescriptor);
        this.values = rawCollection instanceof List ? (List)rawCollection : new ArrayList<E>(rawCollection);
        this.setInitialized();
        this.setDirectlyAccessible(true);
        this.identifiers = new HashMap<Integer, Object>();
    }

    @Override
    public void initializeFromCache(Serializable disassembled, Object owner, PersistentCollectionDescriptor<?, ?, E> collectionDescriptor) {
        Serializable[] array = (Serializable[])disassembled;
        int size = array.length;
        this.beforeInitialize(size, (PersistentCollectionDescriptor)collectionDescriptor);
        for (int i = 0; i < size; i += 2) {
            this.identifiers.put(i / 2, this.getCollectionDescriptor().getIdDescriptor().getJavaTypeDescriptor().getMutabilityPlan().assemble(array[i]));
            this.values.add(this.getCollectionDescriptor().getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().assemble(array[i + 1]));
        }
    }

    @Override
    public Object getIdentifier(Object entry, int assumedIdentifier, PersistentCollectionDescriptor collectionDescriptor) {
        return this.identifiers.get(assumedIdentifier);
    }

    @Override
    public boolean isWrapper(Object collection) {
        return this.values == collection;
    }

    @Override
    public boolean add(E o) {
        this.write();
        this.values.add(o);
        return true;
    }

    @Override
    public void clear() {
        this.initialize(true);
        if (!this.values.isEmpty() || !this.identifiers.isEmpty()) {
            this.values.clear();
            this.identifiers.clear();
            this.dirty();
        }
    }

    @Override
    public boolean contains(Object o) {
        this.read();
        return this.values.contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        this.read();
        return this.values.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.values.isEmpty();
    }

    @Override
    public Iterator iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy(this.values.iterator());
    }

    @Override
    public boolean remove(Object o) {
        this.initialize(true);
        int index = this.values.indexOf(o);
        if (index >= 0) {
            this.beforeRemove(index);
            this.values.remove(index);
            this.elementRemoved = true;
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c.size() > 0) {
            boolean result = false;
            for (Object element : c) {
                if (!this.remove(element)) continue;
                result = true;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection c) {
        this.initialize(true);
        if (this.values.retainAll(c)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.readSize() ? this.getCachedSize() : this.values.size();
    }

    @Override
    public Object[] toArray() {
        this.read();
        return this.values.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        this.read();
        return this.values.toArray(a);
    }

    @Override
    public void beforeInitialize(int anticipatedSize, PersistentCollectionDescriptor collectionDescriptor) {
        this.identifiers = anticipatedSize <= 0 ? new HashMap<Integer, Object>() : new HashMap(anticipatedSize + 1 + (int)((float)anticipatedSize * 0.75f), 0.75f);
        this.values = anticipatedSize <= 0 ? new ArrayList() : new ArrayList(anticipatedSize);
    }

    @Override
    public Serializable disassemble(PersistentCollectionDescriptor<?, ?, E> collectionDescriptor) throws HibernateException {
        Serializable[] result = new Serializable[this.values.size() * 2];
        int i = 0;
        for (int j = 0; j < this.values.size(); ++j) {
            E value = this.values.get(j);
            result[i++] = collectionDescriptor.getIdDescriptor().getJavaTypeDescriptor().getMutabilityPlan().disassemble(this.identifiers.get(j));
            result[i++] = collectionDescriptor.getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().disassemble(value);
        }
        return result;
    }

    @Override
    public boolean empty() {
        return this.values.isEmpty();
    }

    @Override
    public Iterator<E> entries(PersistentCollectionDescriptor<?, ?, E> descriptor) {
        return this.values.iterator();
    }

    @Override
    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }

    @Override
    public boolean equalsSnapshot(PersistentCollectionDescriptor<?, ?, E> collectionDescriptor) throws HibernateException {
        Map snap = (Map)((Object)this.getSnapshot());
        if (snap.size() != this.values.size()) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            E value = this.values.get(i);
            Object id = this.identifiers.get(i);
            if (id == null) {
                return false;
            }
            Object old = snap.get(id);
            if (!collectionDescriptor.isDirty(old, value, this.getSession())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSnapshotEmpty(Serializable snapshot) {
        return ((Map)((Object)snapshot)).isEmpty();
    }

    @Override
    public Iterator getDeletes(PersistentCollectionDescriptor descriptor, boolean indexIsFormula) throws HibernateException {
        Map snap = (Map)((Object)this.getSnapshot());
        ArrayList deletes = new ArrayList(snap.keySet());
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.values.get(i) == null) continue;
            deletes.remove(this.identifiers.get(i));
        }
        return deletes.iterator();
    }

    @Override
    public Object getIndex(Object entry, int assumedIndex, PersistentCollectionDescriptor collectionDescriptor) {
        throw new UnsupportedOperationException("Bags don't have indexes");
    }

    @Override
    public E getElement(Object entry, PersistentCollectionDescriptor<?, ?, E> collectionDescriptor) {
        return (E)entry;
    }

    @Override
    public E getSnapshotElement(Object entry, int index) {
        Map snap = (Map)((Object)this.getSnapshot());
        Object id = this.identifiers.get(index);
        return (E)snap.get(id);
    }

    @Override
    public boolean needsInserting(Object entry, int i) throws HibernateException {
        Map snap = (Map)((Object)this.getSnapshot());
        Object id = this.identifiers.get(i);
        return entry != null && (id == null || snap.get(id) == null);
    }

    @Override
    public boolean needsUpdating(Object entry, int i) throws HibernateException {
        if (entry == null) {
            return false;
        }
        Map snap = (Map)((Object)this.getSnapshot());
        Object id = this.identifiers.get(i);
        if (id == null) {
            return false;
        }
        Object old = snap.get(id);
        return old != null && this.getCollectionDescriptor().isDirty(old, entry, this.getSession());
    }

    @Override
    public Serializable getSnapshot(PersistentCollectionDescriptor descriptor) throws HibernateException {
        HashMap map = new HashMap(this.values.size());
        Iterator<E> iter = this.values.iterator();
        int i = 0;
        while (iter.hasNext()) {
            E value = iter.next();
            map.put(this.identifiers.get(i++), descriptor.getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().deepCopy(value));
        }
        return map;
    }

    @Override
    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        Map sn = (Map)((Object)snapshot);
        return PersistentIdentifierBag.getOrphans(sn.values(), this.values, entityName, this.getSession());
    }

    @Override
    public void preInsert(PersistentCollectionDescriptor descriptor) throws HibernateException {
        Iterator<E> itr = this.values.iterator();
        int i = 0;
        while (itr.hasNext()) {
            Integer loc;
            E entry = itr.next();
            if (this.identifiers.containsKey(loc = Integer.valueOf(i++))) continue;
            Object id = descriptor.getIdDescriptor().getGenerator().generate(this.getSession(), entry);
            this.identifiers.put(loc, id);
        }
    }

    @Override
    public void add(int index, E element) {
        this.write();
        this.beforeAdd(index);
        this.values.add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c.size() > 0) {
            for (E element : c) {
                this.add(index++, element);
            }
            return true;
        }
        return false;
    }

    @Override
    public E get(int index) {
        this.read();
        return this.values.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.read();
        return this.values.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.read();
        return this.values.lastIndexOf(o);
    }

    @Override
    public ListIterator listIterator() {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.values.listIterator());
    }

    @Override
    public ListIterator listIterator(int index) {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.values.listIterator(index));
    }

    private void beforeRemove(int index) {
        Object removedId = this.identifiers.get(index);
        int last = this.values.size() - 1;
        for (int i = index; i < last; ++i) {
            Object id = this.identifiers.get(i + 1);
            if (id == null) {
                this.identifiers.remove(i);
                continue;
            }
            this.identifiers.put(i, id);
        }
        this.identifiers.put(last, removedId);
    }

    private void beforeAdd(int index) {
        for (int i = index; i < this.values.size(); ++i) {
            this.identifiers.put(i + 1, this.identifiers.get(i));
        }
        this.identifiers.remove(index);
    }

    @Override
    public E remove(int index) {
        this.write();
        this.beforeRemove(index);
        return this.values.remove(index);
    }

    @Override
    public E set(int index, E element) {
        this.write();
        return this.values.set(index, element);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.read();
        return new AbstractPersistentCollection.ListProxy(this.values.subList(fromIndex, toIndex));
    }

    @Override
    public boolean addAll(Collection c) {
        if (c.size() > 0) {
            this.write();
            return this.values.addAll(c);
        }
        return false;
    }

    @Override
    public void afterRowInsert(PersistentCollectionDescriptor descriptor, Object entry, int i) throws HibernateException {
    }

    public void load(Object idValue, E element) {
        assert (this.isInitializing());
        Object old = this.identifiers.put(this.values.size(), idValue);
        if (old == null) {
            this.values.add(element);
        }
    }
}

