/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public class PersistentList<E>
extends AbstractPersistentCollection<E>
implements List<E> {
    private List<E> list;

    public PersistentList(SharedSessionContractImplementor session, PersistentCollectionDescriptor<?, List<E>, E> descriptor, List<E> list) {
        super(session, descriptor);
        this.setList(list);
        this.setDirectlyAccessible(true);
    }

    private void setList(List<E> list) {
        this.list = list;
        this.setInitialized();
    }

    public PersistentList(SharedSessionContractImplementor session, PersistentCollectionDescriptor<?, List<E>, E> collectionDescriptor, Object key) {
        super(session, collectionDescriptor, key);
    }

    protected List list() {
        return this.list;
    }

    @Override
    public Serializable getSnapshot(PersistentCollectionDescriptor descriptor) throws HibernateException {
        ArrayList<Object> clonedList = new ArrayList<Object>(this.list.size());
        for (E element : this.list) {
            if (element != null) {
                Object deepCopy = descriptor.getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().deepCopy(element);
                clonedList.add(deepCopy);
                continue;
            }
            clonedList.add(element);
        }
        return clonedList;
    }

    @Override
    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        List sn = (List)((Object)snapshot);
        return PersistentList.getOrphans(sn, this.list, entityName, this.getSession());
    }

    @Override
    public boolean equalsSnapshot(PersistentCollectionDescriptor collectionDescriptor) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() != this.list.size()) {
            return false;
        }
        Iterator<E> itr = this.list.iterator();
        Iterator snapshotItr = sn.iterator();
        while (itr.hasNext()) {
            if (!collectionDescriptor.isDirty(itr.next(), snapshotItr.next(), this.getSession())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSnapshotEmpty(Serializable snapshot) {
        return ((Collection)((Object)snapshot)).isEmpty();
    }

    @Override
    public void beforeInitialize(int anticipatedSize, PersistentCollectionDescriptor collectionDescriptor) {
        this.list = (List)this.getCollectionDescriptor().instantiateRaw(anticipatedSize);
    }

    @Override
    public boolean isWrapper(Object collection) {
        return this.list == collection;
    }

    @Override
    public int size() {
        return this.readSize() ? this.getCachedSize() : this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.list.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        Boolean exists = this.readElementExistence(object);
        return exists == null ? this.list.contains(object) : exists.booleanValue();
    }

    @Override
    public Iterator<E> iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy(this.list.iterator());
    }

    @Override
    public Object[] toArray() {
        this.read();
        return this.list.toArray();
    }

    @Override
    public Object[] toArray(Object[] array) {
        this.read();
        return this.list.toArray(array);
    }

    @Override
    public boolean add(E object) {
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.list.add(object);
        }
        this.queueOperation(new SimpleAdd(object));
        return true;
    }

    @Override
    public boolean remove(Object value) {
        Boolean exists;
        Boolean bl = exists = this.isPutQueueEnabled() ? this.readElementExistence(value) : null;
        if (exists == null) {
            this.initialize(true);
            if (this.list.remove(value)) {
                this.elementRemoved = true;
                this.dirty();
                return true;
            }
            return false;
        }
        if (exists.booleanValue()) {
            this.elementRemoved = true;
            this.queueOperation(new SimpleRemove(value));
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection coll) {
        this.read();
        return this.list.containsAll(coll);
    }

    @Override
    public boolean addAll(Collection<? extends E> values) {
        if (values.size() == 0) {
            return false;
        }
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.list.addAll(values);
        }
        values.forEach(e -> this.queueOperation(new SimpleAdd(e)));
        return values.size() > 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> coll) {
        if (coll.size() > 0) {
            this.write();
            return this.list.addAll(index, coll);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection coll) {
        if (coll.size() > 0) {
            this.initialize(true);
            if (this.list.removeAll(coll)) {
                this.elementRemoved = true;
                this.dirty();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection coll) {
        this.initialize(true);
        if (this.list.retainAll(coll)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.isClearQueueEnabled()) {
            this.queueOperation(new Clear());
        } else {
            this.initialize(true);
            if (!this.list.isEmpty()) {
                this.list.clear();
                this.dirty();
            }
        }
    }

    @Override
    public E get(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("negative index");
        }
        Object result = this.readElementByIndex(index);
        return result == UNKNOWN ? this.list.get(index) : result;
    }

    @Override
    public E set(int index, E value) {
        Object old;
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("negative index");
        }
        Object object = old = this.isPutQueueEnabled() ? this.readElementByIndex(index) : UNKNOWN;
        if (old == UNKNOWN) {
            this.write();
            return this.list.set(index, value);
        }
        this.queueOperation(new Set(index, value, old));
        return (E)old;
    }

    @Override
    public E remove(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("negative index");
        }
        Object old = this.isPutQueueEnabled() ? this.readElementByIndex(index) : UNKNOWN;
        this.elementRemoved = true;
        if (old == UNKNOWN) {
            this.write();
            this.dirty();
            return this.list.remove(index);
        }
        this.queueOperation(new Remove(index, old));
        return (E)old;
    }

    @Override
    public void add(int index, E value) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("negative index");
        }
        this.write();
        this.list.add(index, value);
    }

    @Override
    public int indexOf(Object value) {
        this.read();
        return this.list.indexOf(value);
    }

    @Override
    public int lastIndexOf(Object value) {
        this.read();
        return this.list.lastIndexOf(value);
    }

    @Override
    public ListIterator listIterator() {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.list.listIterator());
    }

    @Override
    public ListIterator listIterator(int index) {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.list.listIterator(index));
    }

    @Override
    public List subList(int from, int to) {
        this.read();
        return new AbstractPersistentCollection.ListProxy(this.list.subList(from, to));
    }

    @Override
    public boolean empty() {
        return this.list.isEmpty();
    }

    public String toString() {
        this.read();
        return this.list.toString();
    }

    @Override
    public Iterator<E> entries(PersistentCollectionDescriptor descriptor) {
        return this.list.iterator();
    }

    @Override
    public void initializeFromCache(Serializable disassembled, Object owner, PersistentCollectionDescriptor<?, ?, E> collectionDescriptor) throws HibernateException {
        Serializable[] array = (Serializable[])disassembled;
        int size = array.length;
        this.beforeInitialize(size, (PersistentCollectionDescriptor)collectionDescriptor);
        for (Serializable arrayElement : array) {
            this.list.add(this.getCollectionDescriptor().getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().assemble(arrayElement));
        }
    }

    @Override
    public Serializable disassemble(PersistentCollectionDescriptor collectionDescriptor) throws HibernateException {
        int length = this.list.size();
        Serializable[] result = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getCollectionDescriptor().getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().disassemble(this.list.get(i));
        }
        return result;
    }

    @Override
    public Iterator getDeletes(PersistentCollectionDescriptor descriptor, boolean indexIsFormula) throws HibernateException {
        int end;
        int i;
        ArrayList<Integer> deletes = new ArrayList<Integer>();
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() > this.list.size()) {
            for (i = this.list.size(); i < sn.size(); ++i) {
                deletes.add((Integer)(indexIsFormula ? sn.get(i) : Integer.valueOf(i)));
            }
            end = this.list.size();
        } else {
            end = sn.size();
        }
        for (i = 0; i < end; ++i) {
            E item = this.list.get(i);
            Object snapshotItem = sn.get(i);
            if (item != null || snapshotItem == null) continue;
            deletes.add((Integer)(indexIsFormula ? snapshotItem : Integer.valueOf(i)));
        }
        return deletes.iterator();
    }

    @Override
    public boolean needsInserting(Object entry, int i) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        return this.list.get(i) != null && (i >= sn.size() || sn.get(i) == null);
    }

    @Override
    public boolean needsUpdating(Object entry, int i) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        return i < sn.size() && sn.get(i) != null && this.list.get(i) != null && this.getCollectionDescriptor().isDirty(this.list.get(i), sn.get(i), this.getSession());
    }

    @Override
    public Object getIndex(Object entry, int assumedIndex, PersistentCollectionDescriptor collectionDescriptor) {
        return assumedIndex;
    }

    @Override
    public Object getElement(Object entry, PersistentCollectionDescriptor collectionDescriptor) {
        return entry;
    }

    @Override
    public E getSnapshotElement(Object entry, int index) {
        List sn = (List)((Object)this.getSnapshot());
        return sn.get(index);
    }

    @Override
    public boolean equals(Object other) {
        this.read();
        return this.list.equals(other);
    }

    @Override
    public int hashCode() {
        this.read();
        return this.list.hashCode();
    }

    @Override
    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }

    public void load(int index, E element) {
        assert (this.isInitializing());
        for (int i = this.list.size(); i <= index; ++i) {
            this.list.add(i, null);
        }
        this.list.set(index, element);
    }

    final class SimpleRemove
    extends AbstractPersistentCollection.AbstractValueDelayedOperation {
        public SimpleRemove(Object orphan) {
            super(null, orphan);
        }

        @Override
        public void operate() {
            PersistentList.this.list.remove(this.getOrphan());
        }
    }

    final class Remove
    extends AbstractListValueDelayedOperation {
        public Remove(int index, Object orphan) {
            super(index, null, orphan);
        }

        @Override
        public void operate() {
            PersistentList.this.list.remove(this.getIndex());
        }
    }

    final class Set
    extends AbstractListValueDelayedOperation {
        public Set(int index, E addedValue, Object orphan) {
            super(index, addedValue, orphan);
        }

        @Override
        public void operate() {
            PersistentList.this.list.set(this.getIndex(), this.getAddedInstance());
        }
    }

    final class Add
    extends AbstractListValueDelayedOperation {
        public Add(int index, E addedValue) {
            super(index, addedValue, null);
        }

        @Override
        public void operate() {
            PersistentList.this.list.add(this.getIndex(), this.getAddedInstance());
        }
    }

    abstract class AbstractListValueDelayedOperation
    extends AbstractPersistentCollection.AbstractValueDelayedOperation {
        private int index;

        AbstractListValueDelayedOperation(Integer index, E addedValue, Object orphan) {
            super(addedValue, orphan);
            this.index = index;
        }

        protected final int getIndex() {
            return this.index;
        }
    }

    final class SimpleAdd
    extends AbstractPersistentCollection.AbstractValueDelayedOperation {
        public SimpleAdd(E addedValue) {
            super(addedValue, null);
        }

        @Override
        public void operate() {
            PersistentList.this.list.add(this.getAddedInstance());
        }
    }

    final class Clear
    implements AbstractPersistentCollection.DelayedOperation {
        Clear() {
        }

        @Override
        public void operate() {
            PersistentList.this.list.clear();
        }

        public E getAddedInstance() {
            return null;
        }

        @Override
        public Object getOrphan() {
            throw new UnsupportedOperationException("queued clear cannot be used with orphan delete");
        }
    }
}

