/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public class PersistentMap<K, V>
extends AbstractPersistentCollection<V>
implements Map<K, V> {
    protected Map<K, V> map;
    private transient List<Object[]> loadingEntries;

    protected PersistentMap() {
    }

    public PersistentMap(SharedSessionContractImplementor session, PersistentCollectionDescriptor<?, ?, V> collectionDescriptor) {
        super(session, collectionDescriptor);
    }

    public PersistentMap(SharedSessionContractImplementor session, PersistentCollectionDescriptor<?, ?, V> descriptor, Map<K, V> map) {
        this(session, descriptor);
        super.setMap(map);
        this.setDirectlyAccessible(true);
    }

    public PersistentMap(SharedSessionContractImplementor session, PersistentCollectionDescriptor<?, ?, V> descriptor, Object key) {
        super(session, descriptor, key);
    }

    @Override
    public Serializable getSnapshot(PersistentCollectionDescriptor descriptor) throws HibernateException {
        HashMap clonedMap = new HashMap(this.map.size());
        Iterator<Map.Entry<K, V>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> o;
            Map.Entry<K, V> e = o = iterator.next();
            Object copy = descriptor.getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().deepCopy(e.getValue());
            clonedMap.put(e.getKey(), copy);
        }
        return clonedMap;
    }

    @Override
    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        Map sn = (Map)((Object)snapshot);
        return PersistentMap.getOrphans(sn.values(), this.map.values(), entityName, this.getSession());
    }

    @Override
    public boolean equalsSnapshot(PersistentCollectionDescriptor collectionDescriptor) throws HibernateException {
        Map snapshotMap = (Map)((Object)this.getSnapshot());
        if (snapshotMap.size() != this.map.size()) {
            return false;
        }
        for (Map.Entry<K, V> o : this.map.entrySet()) {
            Map.Entry<K, V> entry = o;
            if (!collectionDescriptor.isDirty(entry.getValue(), snapshotMap.get(entry.getKey()), this.getSession())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSnapshotEmpty(Serializable snapshot) {
        return ((Map)((Object)snapshot)).isEmpty();
    }

    @Override
    public boolean isWrapper(Object collection) {
        return this.map == collection;
    }

    @Override
    public void beforeInitialize(int anticipatedSize, PersistentCollectionDescriptor collectionDescriptor) {
        this.map = (Map)this.getCollectionDescriptor().instantiateRaw(anticipatedSize);
    }

    @Override
    public int size() {
        return this.readSize() ? this.getCachedSize() : this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Boolean exists = this.readIndexExistence(key);
        return exists == null ? this.map.containsKey(key) : exists.booleanValue();
    }

    @Override
    public boolean containsValue(Object value) {
        Boolean exists = this.readElementExistence(value);
        return exists == null ? this.map.containsValue(value) : exists.booleanValue();
    }

    @Override
    public V get(Object key) {
        Object result = this.readElementByIndex(key);
        return (V)(result == UNKNOWN ? this.map.get(key) : result);
    }

    @Override
    public V put(K key, V value) {
        Object old;
        if (this.isPutQueueEnabled() && (old = this.readElementByIndex(key)) != UNKNOWN) {
            this.queueOperation(new Put(key, value, old));
            return (V)old;
        }
        this.initialize(true);
        old = this.map.put(key, value);
        if (value != old) {
            this.dirty();
        }
        return (V)old;
    }

    @Override
    public V remove(Object key) {
        Object old;
        if (this.isPutQueueEnabled() && (old = this.readElementByIndex(key)) != UNKNOWN) {
            this.elementRemoved = true;
            this.queueOperation(new Remove(key, old));
            return (V)old;
        }
        this.initialize(true);
        if (this.map.containsKey(key)) {
            this.elementRemoved = true;
            this.dirty();
        }
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> puts) {
        if (puts.size() > 0) {
            this.initialize(true);
            for (Map.Entry<K, V> entry : puts.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void clear() {
        if (this.isClearQueueEnabled()) {
            this.queueOperation(new Clear());
        } else {
            this.initialize(true);
            if (!this.map.isEmpty()) {
                this.dirty();
                this.map.clear();
            }
        }
    }

    @Override
    public Set keySet() {
        this.read();
        return new AbstractPersistentCollection.SetProxy(this.map.keySet());
    }

    @Override
    public Collection values() {
        this.read();
        return new AbstractPersistentCollection.SetProxy(this.map.values());
    }

    @Override
    public Set entrySet() {
        this.read();
        return new EntrySetProxy(this.map.entrySet());
    }

    @Override
    public boolean empty() {
        return this.map.isEmpty();
    }

    public String toString() {
        this.read();
        return this.map.toString();
    }

    @Override
    public boolean endRead() {
        if (this.loadingEntries != null) {
            for (Object[] entry : this.loadingEntries) {
                this.map.put(entry[0], entry[1]);
            }
            this.loadingEntries = null;
        }
        return super.endRead();
    }

    @Override
    public Iterator entries(PersistentCollectionDescriptor descriptor) {
        return this.map.entrySet().iterator();
    }

    public void load(K key, V value) {
        assert (this.isInitializing());
        this.map.put(key, value);
    }

    private void setMap(Map<K, V> map) {
        this.map = map;
        this.setInitialized();
    }

    @Override
    public void initializeFromCache(Serializable disassembled, Object owner, PersistentCollectionDescriptor collectionDescriptor) throws HibernateException {
        Serializable[] array = (Serializable[])disassembled;
        int size = array.length;
        this.beforeInitialize(size, collectionDescriptor);
        for (int i = 0; i < size; i += 2) {
            this.map.put(this.getCollectionDescriptor().getIndexDescriptor().getJavaTypeDescriptor().getMutabilityPlan().assemble(array[i]), this.getCollectionDescriptor().getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().assemble(array[i + 1]));
        }
    }

    @Override
    public Serializable disassemble(PersistentCollectionDescriptor collectionDescriptor) throws HibernateException {
        Serializable[] result = new Serializable[this.map.size() * 2];
        Iterator<Map.Entry<K, V>> itr = this.map.entrySet().iterator();
        int i = 0;
        while (itr.hasNext()) {
            Map.Entry<K, V> e = itr.next();
            result[i++] = collectionDescriptor.getIndexDescriptor().getJavaTypeDescriptor().getMutabilityPlan().disassemble(e.getKey());
            result[i++] = collectionDescriptor.getElementDescriptor().getJavaTypeDescriptor().getMutabilityPlan().disassemble(e.getValue());
        }
        return result;
    }

    @Override
    public Iterator getDeletes(PersistentCollectionDescriptor descriptor, boolean indexIsFormula) throws HibernateException {
        ArrayList deletes = new ArrayList();
        Iterator iterator = ((Map)((Object)this.getSnapshot())).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            Object key = e.getKey();
            if (e.getValue() == null || this.map.get(key) != null) continue;
            deletes.add(indexIsFormula ? e.getValue() : key);
        }
        return deletes.iterator();
    }

    @Override
    public boolean needsInserting(Object entry, int i) throws HibernateException {
        Map sn = (Map)((Object)this.getSnapshot());
        Map.Entry e = (Map.Entry)entry;
        return e.getValue() != null && sn.get(e.getKey()) == null;
    }

    @Override
    public boolean needsUpdating(Object entry, int i) throws HibernateException {
        Map sn = (Map)((Object)this.getSnapshot());
        Map.Entry e = (Map.Entry)entry;
        Object snValue = sn.get(e.getKey());
        return e.getValue() != null && snValue != null && this.getCollectionDescriptor().isDirty(snValue, e.getValue(), this.getSession());
    }

    @Override
    public Object getIndex(Object entry, int assumedIndex, PersistentCollectionDescriptor collectionDescriptor) {
        return ((Map.Entry)entry).getKey();
    }

    @Override
    public Object getElement(Object entry, PersistentCollectionDescriptor collectionDescriptor) {
        return ((Map.Entry)entry).getValue();
    }

    @Override
    public V getSnapshotElement(Object entry, int index) {
        Map sn = (Map)((Object)this.getSnapshot());
        return sn.get(((Map.Entry)entry).getKey());
    }

    @Override
    public boolean equals(Object other) {
        this.read();
        return this.map.equals(other);
    }

    @Override
    public int hashCode() {
        this.read();
        return this.map.hashCode();
    }

    @Override
    public boolean entryExists(Object entry, int i) {
        return ((Map.Entry)entry).getValue() != null;
    }

    final class Remove
    extends AbstractMapValueDelayedOperation {
        public Remove(K index, Object orphan) {
            super(index, null, orphan);
        }

        @Override
        public void operate() {
            PersistentMap.this.map.remove(this.getIndex());
        }
    }

    final class Put
    extends AbstractMapValueDelayedOperation {
        public Put(K index, V addedValue, Object orphan) {
            super(index, addedValue, orphan);
        }

        @Override
        public void operate() {
            PersistentMap.this.map.put(this.getIndex(), this.getAddedInstance());
        }
    }

    abstract class AbstractMapValueDelayedOperation
    extends AbstractPersistentCollection.AbstractValueDelayedOperation {
        private K index;

        protected AbstractMapValueDelayedOperation(K index, V addedValue, Object orphan) {
            super(addedValue, orphan);
            this.index = index;
        }

        protected final K getIndex() {
            return this.index;
        }
    }

    final class Clear
    implements AbstractPersistentCollection.DelayedOperation {
        Clear() {
        }

        @Override
        public void operate() {
            PersistentMap.this.map.clear();
        }

        @Override
        public Object getAddedInstance() {
            return null;
        }

        @Override
        public Object getOrphan() {
            throw new UnsupportedOperationException("queued clear cannot be used with orphan delete");
        }
    }

    final class MapEntryProxy
    implements Map.Entry {
        private final Map.Entry me;

        MapEntryProxy(Map.Entry me) {
            this.me = me;
        }

        public Object getKey() {
            return this.me.getKey();
        }

        public Object getValue() {
            return this.me.getValue();
        }

        @Override
        public boolean equals(Object o) {
            return this.me.equals(o);
        }

        @Override
        public int hashCode() {
            return this.me.hashCode();
        }

        public Object setValue(Object value) {
            PersistentMap.this.write();
            return this.me.setValue(value);
        }
    }

    final class EntryIteratorProxy
    implements Iterator {
        private final Iterator iter;

        EntryIteratorProxy(Iterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return new MapEntryProxy((Map.Entry)this.iter.next());
        }

        @Override
        public void remove() {
            PersistentMap.this.write();
            this.iter.remove();
        }
    }

    class EntrySetProxy
    implements Set {
        private final Set set;

        EntrySetProxy(Set set) {
            this.set = set;
        }

        @Override
        public boolean add(Object entry) {
            return this.set.add(entry);
        }

        @Override
        public boolean addAll(Collection entries) {
            return this.set.addAll(entries);
        }

        @Override
        public void clear() {
            PersistentMap.this.write();
            this.set.clear();
        }

        @Override
        public boolean contains(Object entry) {
            return this.set.contains(entry);
        }

        @Override
        public boolean containsAll(Collection entries) {
            return this.set.containsAll(entries);
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new EntryIteratorProxy(this.set.iterator());
        }

        @Override
        public boolean remove(Object entry) {
            PersistentMap.this.write();
            return this.set.remove(entry);
        }

        @Override
        public boolean removeAll(Collection entries) {
            PersistentMap.this.write();
            return this.set.removeAll(entries);
        }

        @Override
        public boolean retainAll(Collection entries) {
            PersistentMap.this.write();
            return this.set.retainAll(entries);
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public Object[] toArray(Object[] array) {
            return this.set.toArray(array);
        }
    }
}

