/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;
import org.hibernate.collection.internal.PersistentArrayHolder;
import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public class StandardArraySemantics
implements CollectionSemantics<Object[]> {
    public static final StandardArraySemantics INSTANCE = new StandardArraySemantics();

    private StandardArraySemantics() {
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return CollectionClassification.ARRAY;
    }

    @Override
    public Object[] instantiateRaw(int anticipatedSize, PersistentCollectionDescriptor collectionDescriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> PersistentCollection<E> instantiateWrapper(Object key, PersistentCollectionDescriptor<?, Object[], E> collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentArrayHolder(key, session, collectionDescriptor);
    }

    @Override
    public <E> PersistentCollection<E> wrap(Object rawCollection, PersistentCollectionDescriptor<?, Object[], E> collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentArrayHolder(session, (PersistentCollectionDescriptor)collectionDescriptor, rawCollection);
    }

    @Override
    public <E> Iterator<E> getElementIterator(Object[] rawCollection) {
        return Arrays.stream(rawCollection).iterator();
    }

    @Override
    public void visitElements(Object[] array, Consumer action) {
        if (array == null) {
            return;
        }
        for (Object element : array) {
            action.accept(element);
        }
    }
}

