/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.util.Collection;
import org.hibernate.collection.internal.AbstractBagSemantics;
import org.hibernate.collection.internal.PersistentBag;
import org.hibernate.collection.internal.PersistentIdentifierBag;
import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.IdentifierBagAttribute;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public class StandardBagSemantics
extends AbstractBagSemantics<Collection<?>> {
    public static final StandardBagSemantics INSTANCE = new StandardBagSemantics();

    private StandardBagSemantics() {
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return CollectionClassification.BAG;
    }

    @Override
    public <E> PersistentCollection<E> instantiateWrapper(Object key, PersistentCollectionDescriptor<?, Collection<?>, E> collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentBag(session, (PersistentCollectionDescriptor)collectionDescriptor);
    }

    @Override
    public <E> PersistentCollection<E> wrap(Object rawCollection, PersistentCollectionDescriptor<?, Collection<?>, E> collectionDescriptor, SharedSessionContractImplementor session) {
        if (collectionDescriptor.getDescribedAttribute() instanceof IdentifierBagAttribute) {
            return new PersistentIdentifierBag<E>(session, collectionDescriptor, (Collection)rawCollection);
        }
        return new PersistentBag(session, collectionDescriptor, (Collection)rawCollection);
    }
}

