/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.util.SortedMap;
import java.util.TreeMap;
import org.hibernate.collection.internal.AbstractMapSemantics;
import org.hibernate.collection.internal.PersistentSortedMap;
import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public class StandardSortedMapSemantics
extends AbstractMapSemantics<SortedMap<?, ?>> {
    public static final StandardSortedMapSemantics INSTANCE = new StandardSortedMapSemantics();

    private StandardSortedMapSemantics() {
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return CollectionClassification.SORTED_MAP;
    }

    @Override
    public TreeMap<?, ?> instantiateRaw(int anticipatedSize, PersistentCollectionDescriptor collectionDescriptor) {
        return new TreeMap(collectionDescriptor.getSortingComparator());
    }

    @Override
    public PersistentCollection instantiateWrapper(Object key, PersistentCollectionDescriptor collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentSortedMap(session, collectionDescriptor, key);
    }

    @Override
    public PersistentCollection wrap(Object rawCollection, PersistentCollectionDescriptor collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentSortedMap(session, collectionDescriptor, (SortedMap)rawCollection);
    }
}

