/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.collection.internal.AbstractSetSemantics;
import org.hibernate.collection.internal.PersistentSortedSet;
import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public class StandardSortedSetSemantics
extends AbstractSetSemantics<SortedSet<?>> {
    public static final StandardSortedSetSemantics INSTANCE = new StandardSortedSetSemantics();

    private StandardSortedSetSemantics() {
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return CollectionClassification.SORTED_SET;
    }

    @Override
    public SortedSet instantiateRaw(int anticipatedSize, PersistentCollectionDescriptor collectionDescriptor) {
        return new TreeSet(collectionDescriptor.getSortingComparator());
    }

    @Override
    public PersistentCollection instantiateWrapper(Object key, PersistentCollectionDescriptor collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentSortedSet(session, collectionDescriptor, key);
    }

    @Override
    public PersistentCollection wrap(Object rawCollection, PersistentCollectionDescriptor collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentSortedSet(session, collectionDescriptor, (SortedSet)rawCollection);
    }

    @Override
    public <E> Iterator<E> getElementIterator(SortedSet<?> rawCollection) {
        return rawCollection.iterator();
    }
}

