/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.ScrollMode;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.identity.HANAIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.BlobImplementer;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.ClobImplementer;
import org.hibernate.engine.jdbc.NClobImplementer;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.env.spi.AnsiSqlKeywords;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.naming.Identifier;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.spi.AnsiTrimFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.ConcatFunctionTemplate;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.AbstractJdbcValueBinder;
import org.hibernate.sql.AbstractJdbcValueExtractor;
import org.hibernate.sql.JdbcValueBinder;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorHANADatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.descriptor.java.internal.LobStreamDataHelper;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.AbstractTemplateSqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.BitSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.BlobSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.BooleanSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.CharSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.ClobSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.DecimalSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.DoubleSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.sql.spi.NCharSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.NClobSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.NVarcharSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.SmallIntSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.VarcharSqlDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractHANADialect
extends Dialect {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AbstractHANADialect.class);
    private static final AbstractLimitHandler LIMIT_HANDLER = new AbstractLimitHandler(){

        @Override
        public String processSql(String sql, RowSelection selection) {
            boolean hasOffset = LimitHelper.hasFirstRow(selection);
            return sql + (hasOffset ? " limit ? offset ?" : " limit ?");
        }

        @Override
        public boolean supportsLimit() {
            return true;
        }

        @Override
        public boolean bindLimitParametersInReverseOrder() {
            return true;
        }
    };
    private static final String MAX_LOB_PREFETCH_SIZE_PARAMETER_NAME = new String("hibernate.dialect.hana.max_lob_prefetch_size");
    private static final String USE_LEGACY_BOOLEAN_TYPE_PARAMETER_NAME = new String("hibernate.dialect.hana.use_legacy_boolean_type");
    private static final String USE_UNICODE_STRING_TYPES_PARAMETER_NAME = new String("hibernate.dialect.hana.use_unicode_string_types");
    private static final String TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_PARAMETER_NAME = new String("hibernate.dialect.hana.treat_double_typed_fields_as_decimal");
    private static final int MAX_LOB_PREFETCH_SIZE_DEFAULT_VALUE = 1024;
    private static final Boolean USE_LEGACY_BOOLEAN_TYPE_DEFAULT_VALUE = Boolean.FALSE;
    private static final Boolean USE_UNICODE_STRING_TYPES_DEFAULT_VALUE = Boolean.FALSE;
    private static final Boolean TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_DEFAULT_VALUE = Boolean.FALSE;
    private HANANClobSqlDescriptor nClobTypeDescriptor = new HANANClobSqlDescriptor(1024);
    private HANABlobTypeDescriptor blobTypeDescriptor = new HANABlobTypeDescriptor(1024);
    private HANAClobTypeDescriptor clobTypeDescriptor = new HANAClobTypeDescriptor(1024, USE_UNICODE_STRING_TYPES_DEFAULT_VALUE);
    private boolean useLegacyBooleanType = USE_LEGACY_BOOLEAN_TYPE_DEFAULT_VALUE;
    private boolean useUnicodeStringTypes = USE_UNICODE_STRING_TYPES_DEFAULT_VALUE;
    private boolean treatDoubleTypedFieldsAsDecimal = TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_DEFAULT_VALUE;
    private final StandardTableExporter hanaTableExporter = new StandardTableExporter(this){

        @Override
        public String[] getSqlCreateStrings(ExportableTable table, JdbcServices jdbcServices) {
            String[] sqlCreateStrings = super.getSqlCreateStrings(table, jdbcServices);
            return this.quoteTypeIfNecessary(table, sqlCreateStrings, AbstractHANADialect.this.getCreateTableString());
        }

        @Override
        public String[] getSqlDropStrings(ExportableTable table, JdbcServices jdbcServices) {
            String[] sqlDropStrings = super.getSqlDropStrings(table, jdbcServices);
            return this.quoteTypeIfNecessary(table, sqlDropStrings, "drop table");
        }

        private String[] quoteTypeIfNecessary(ExportableTable table, String[] strings, String prefix) {
            if (table.getTableName() == null || table.getTableName().isQuoted() || !"type".equals(table.getTableName().getText().toLowerCase())) {
                return strings;
            }
            Pattern createTableTypePattern = Pattern.compile("(" + prefix + "\\s+)(" + table.getTableName().getText() + ")(.+)");
            Pattern commentOnTableTypePattern = Pattern.compile("(comment\\s+on\\s+table\\s+)(" + table.getTableName().getText() + ")(.+)");
            for (int i = 0; i < strings.length; ++i) {
                Matcher createTableTypeMatcher = createTableTypePattern.matcher(strings[i]);
                Matcher commentOnTableTypeMatcher = commentOnTableTypePattern.matcher(strings[i]);
                if (createTableTypeMatcher.matches()) {
                    strings[i] = createTableTypeMatcher.group(1) + "\"TYPE\"" + createTableTypeMatcher.group(3);
                }
                if (!commentOnTableTypeMatcher.matches()) continue;
                strings[i] = commentOnTableTypeMatcher.group(1) + "\"TYPE\"" + commentOnTableTypeMatcher.group(3);
            }
            return strings;
        }
    };

    public AbstractHANADialect() {
        this.registerColumnType(3, "decimal($p, $s)");
        this.registerColumnType(2, "decimal($p, $s)");
        this.registerColumnType(8, "double");
        this.registerColumnType(-2, 5000L, "varbinary($l)");
        this.registerColumnType(-3, 5000L, "varbinary($l)");
        this.registerColumnType(-4, 5000L, "varbinary($l)");
        this.registerColumnType(-2, "blob");
        this.registerColumnType(-3, "blob");
        this.registerColumnType(-4, "blob");
        this.registerColumnType(1, "varchar(1)");
        this.registerColumnType(-15, "nvarchar(1)");
        this.registerColumnType(12, 5000L, "varchar($l)");
        this.registerColumnType(-1, 5000L, "varchar($l)");
        this.registerColumnType(-9, 5000L, "nvarchar($l)");
        this.registerColumnType(-16, 5000L, "nvarchar($l)");
        this.registerColumnType(-1, "clob");
        this.registerColumnType(12, "clob");
        this.registerColumnType(-16, "nclob");
        this.registerColumnType(-9, "nclob");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(2011, "nclob");
        this.registerColumnType(16, "boolean");
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerHibernateType(2011, StandardSpiBasicTypes.MATERIALIZED_NCLOB.getJavaTypeDescriptor().getTypeName());
        this.registerHibernateType(2005, StandardSpiBasicTypes.MATERIALIZED_CLOB.getJavaTypeDescriptor().getTypeName());
        this.registerHibernateType(2004, StandardSpiBasicTypes.MATERIALIZED_BLOB.getJavaTypeDescriptor().getTypeName());
        this.registerHibernateType(-9, StandardSpiBasicTypes.STRING.getJavaTypeDescriptor().getTypeName());
        this.registerHanaKeywords();
        this.getDefaultProperties().setProperty("hibernate.jdbc.lob.non_contextual_creation", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "false");
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.registerNamed("to_date", StandardSpiBasicTypes.DATE);
        registry.registerNamed("to_seconddate", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNamed("to_time", StandardSpiBasicTypes.TIME);
        registry.registerNamed("to_timestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNoArgs("current_date", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("current_time", StandardSpiBasicTypes.TIME);
        registry.registerNoArgs("current_timestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNoArgs("current_utcdate", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("current_utctime", StandardSpiBasicTypes.TIME);
        registry.registerNoArgs("current_utctimestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNamed("add_days");
        registry.registerNamed("add_months");
        registry.registerNamed("add_seconds");
        registry.registerNamed("add_years");
        registry.registerNamed("dayname", StandardSpiBasicTypes.STRING);
        registry.registerNamed("dayofmonth", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("dayofyear", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("days_between", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("hour", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("isoweek", StandardSpiBasicTypes.STRING);
        registry.registerNamed("last_day", StandardSpiBasicTypes.DATE);
        registry.registerNamed("localtoutc", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNamed("minute", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("month", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("monthname", StandardSpiBasicTypes.STRING);
        registry.registerNamed("next_day", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("now", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNamed("quarter", StandardSpiBasicTypes.STRING);
        registry.registerNamed("second", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("seconds_between", StandardSpiBasicTypes.LONG);
        registry.registerNamed("week", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("weekday", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("year", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("utctolocal", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNamed("to_bigint", StandardSpiBasicTypes.LONG);
        registry.registerNamed("to_binary", StandardSpiBasicTypes.BINARY);
        registry.registerNamed("to_decimal", StandardSpiBasicTypes.BIG_DECIMAL);
        registry.registerNamed("to_double", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("to_int", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("to_integer", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("to_real", StandardSpiBasicTypes.FLOAT);
        registry.registerNamed("to_smalldecimal", StandardSpiBasicTypes.BIG_DECIMAL);
        registry.registerNamed("to_smallint", StandardSpiBasicTypes.SHORT);
        registry.registerNamed("to_tinyint", StandardSpiBasicTypes.BYTE);
        registry.registerNamed("abs");
        registry.registerNamed("acos", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("asin", StandardSpiBasicTypes.DOUBLE);
        registry.namedTemplateBuilder("atan2", "atan").setInvariantType(StandardSpiBasicTypes.DOUBLE).register();
        registry.registerNamed("bin2hex", StandardSpiBasicTypes.STRING);
        registry.registerNamed("bitand", StandardSpiBasicTypes.LONG);
        registry.registerNamed("ceil");
        registry.registerNamed("cos", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("cosh", StandardSpiBasicTypes.DOUBLE);
        registry.namedTemplateBuilder("cot", "cos").setInvariantType(StandardSpiBasicTypes.DOUBLE).register();
        registry.registerNamed("exp", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("floor");
        registry.registerNamed("greatest");
        registry.registerNamed("hex2bin", StandardSpiBasicTypes.BINARY);
        registry.registerNamed("least");
        registry.registerNamed("ln", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("log", StandardSpiBasicTypes.DOUBLE);
        registry.namedTemplateBuilder("log", "ln").setInvariantType(StandardSpiBasicTypes.DOUBLE).register();
        registry.registerNamed("power");
        registry.registerNamed("round");
        registry.registerNamed("mod", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("sign", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("sin", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("sinh", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("sqrt", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("tan", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("tanh", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("uminus");
        registry.registerNamed("to_alphanum", StandardSpiBasicTypes.STRING);
        registry.registerNamed("to_nvarchar", StandardSpiBasicTypes.STRING);
        registry.registerNamed("to_varchar", StandardSpiBasicTypes.STRING);
        registry.registerNamed("ascii", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("char", StandardSpiBasicTypes.CHARACTER);
        registry.register("concat", ConcatFunctionTemplate.INSTANCE);
        registry.registerNamed("lcase", StandardSpiBasicTypes.STRING);
        registry.registerNamed("left", StandardSpiBasicTypes.STRING);
        registry.registerNamed("length", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("locate", "locate(?2, ?1, ?3)", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("lpad", StandardSpiBasicTypes.STRING);
        registry.registerNamed("ltrim", StandardSpiBasicTypes.STRING);
        registry.registerNamed("nchar", StandardSpiBasicTypes.STRING);
        registry.registerNamed("replace", StandardSpiBasicTypes.STRING);
        registry.registerNamed("right", StandardSpiBasicTypes.STRING);
        registry.registerNamed("rpad", StandardSpiBasicTypes.STRING);
        registry.registerNamed("rtrim", StandardSpiBasicTypes.STRING);
        registry.registerNamed("substr_after", StandardSpiBasicTypes.STRING);
        registry.registerNamed("substr_before", StandardSpiBasicTypes.STRING);
        registry.registerNamed("substring", StandardSpiBasicTypes.STRING);
        registry.register("trim", AnsiTrimFunctionTemplate.INSTANCE);
        registry.registerNamed("ucase", StandardSpiBasicTypes.STRING);
        registry.registerNamed("unicode", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("bit_length", "length(to_binary(?1))*8", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("to_blob", StandardSpiBasicTypes.BLOB);
        registry.registerNamed("to_clob", StandardSpiBasicTypes.CLOB);
        registry.registerNamed("to_nclob", StandardSpiBasicTypes.NCLOB);
        registry.registerNamed("coalesce");
        registry.registerNoArgs("current_connection", StandardSpiBasicTypes.INTEGER);
        registry.registerNoArgs("current_schema", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("current_user", StandardSpiBasicTypes.STRING);
        registry.registerVarArgs("grouping_id", StandardSpiBasicTypes.INTEGER, "(", ",", ")");
        registry.registerNamed("ifnull");
        registry.registerNamed("map");
        registry.registerNamed("nullif");
        registry.registerNamed("session_context");
        registry.registerNoArgs("session_user", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("sysuuid", StandardSpiBasicTypes.STRING);
    }

    @Override
    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            @Override
            public JDBCException convert(SQLException sqlException, String message, String sql) {
                int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
                if (errorCode == 131) {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                if (errorCode == 146) {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                if (errorCode == 132) {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                if (errorCode == 133) {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                if (errorCode == 257 || errorCode >= 259 && errorCode <= 263) {
                    throw new SQLGrammarException(message, sqlException, sql);
                }
                if (errorCode == 287 || errorCode == 301 || errorCode == 461 || errorCode == 462) {
                    String constraintName = AbstractHANADialect.this.getViolatedConstraintNameExtracter().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
                return null;
            }
        };
    }

    @Override
    public boolean forUpdateOfColumns() {
        return true;
    }

    @Override
    public String getAddColumnString() {
        return "add (";
    }

    @Override
    public String getAddColumnSuffixString() {
        return ")";
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    @Override
    protected String getCreateSequenceString(String sequenceName, int initialValue, int incrementSize) throws MappingException {
        if (incrementSize == 0) {
            throw new MappingException("Unable to create the sequence [" + sequenceName + "]: the increment size must not be 0");
        }
        String createSequenceString = this.getCreateSequenceString(sequenceName) + " start with " + initialValue + " increment by " + incrementSize;
        if (incrementSize > 0) {
            if (initialValue < 1) {
                createSequenceString = createSequenceString + " minvalue " + initialValue;
            }
        } else if (incrementSize < 0 && initialValue > -1) {
            createSequenceString = createSequenceString + " maxvalue " + initialValue;
        }
        return createSequenceString;
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new GlobalTemporaryTableStrategy(this.getIdTableExporter());
    }

    @Override
    protected Exporter<IdTable> getIdTableExporter() {
        return new GlobalTempTableExporter();
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp from sys.dummy";
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode = lockOptions.findGreatestLockMode();
        lockOptions.setLockMode(lockMode);
        if (aliases == null || aliases.isEmpty()) {
            return this.getForUpdateString(lockOptions);
        }
        return this.getForUpdateString(aliases, lockMode, lockOptions.getTimeOut());
    }

    private String getForUpdateString(String aliases, LockMode lockMode, int timeout) {
        switch (lockMode) {
            case UPGRADE: {
                return this.getForUpdateString(aliases);
            }
            case PESSIMISTIC_READ: {
                return this.getReadLockString(aliases, timeout);
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(aliases, timeout);
            }
            case UPGRADE_NOWAIT: 
            case FORCE: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                return this.getForUpdateNowaitString(aliases);
            }
            case UPGRADE_SKIPLOCKED: {
                return this.getForUpdateSkipLockedString(aliases);
            }
        }
        return "";
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.getForUpdateString() + " nowait";
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuilder(sql.length() + 20).append(sql).append(hasOffset ? " limit ? offset ?" : " limit ?").toString();
    }

    @Override
    public String getNotExpression(String expression) {
        return "not (" + expression + ")";
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from sys.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorHANADatabaseImpl.INSTANCE;
    }

    @Override
    public String getSelectSequenceNextValString(String sequenceName) {
        return sequenceName + ".nextval";
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName) + " from sys.dummy";
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        switch (sqlCode) {
            case 16: {
                return this.useLegacyBooleanType ? BitSqlDescriptor.INSTANCE : BooleanSqlDescriptor.INSTANCE;
            }
            case 1: {
                return this.useUnicodeStringTypes ? NCharSqlDescriptor.INSTANCE : CharSqlDescriptor.INSTANCE;
            }
            case 12: {
                return this.useUnicodeStringTypes ? NVarcharSqlDescriptor.INSTANCE : VarcharSqlDescriptor.INSTANCE;
            }
            case -6: {
                return SmallIntSqlDescriptor.INSTANCE;
            }
            case 2004: {
                return this.blobTypeDescriptor;
            }
            case 2005: {
                return this.clobTypeDescriptor;
            }
            case 2011: {
                return this.nClobTypeDescriptor;
            }
            case 8: {
                return this.treatDoubleTypedFieldsAsDecimal ? DecimalSqlDescriptor.INSTANCE : DoubleSqlDescriptor.INSTANCE;
            }
        }
        return super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    protected void registerHanaKeywords() {
        this.registerKeyword("all");
        this.registerKeyword("alter");
        this.registerKeyword("as");
        this.registerKeyword("before");
        this.registerKeyword("begin");
        this.registerKeyword("both");
        this.registerKeyword("case");
        this.registerKeyword("char");
        this.registerKeyword("condition");
        this.registerKeyword("connect");
        this.registerKeyword("cross");
        this.registerKeyword("cube");
        this.registerKeyword("current_connection");
        this.registerKeyword("current_date");
        this.registerKeyword("current_schema");
        this.registerKeyword("current_time");
        this.registerKeyword("current_timestamp");
        this.registerKeyword("current_transaction_isolation_level");
        this.registerKeyword("current_user");
        this.registerKeyword("current_utcdate");
        this.registerKeyword("current_utctime");
        this.registerKeyword("current_utctimestamp");
        this.registerKeyword("currval");
        this.registerKeyword("cursor");
        this.registerKeyword("declare");
        this.registerKeyword("deferred");
        this.registerKeyword("distinct");
        this.registerKeyword("else");
        this.registerKeyword("elseif");
        this.registerKeyword("end");
        this.registerKeyword("except");
        this.registerKeyword("exception");
        this.registerKeyword("exec");
        this.registerKeyword("false");
        this.registerKeyword("for");
        this.registerKeyword("from");
        this.registerKeyword("full");
        this.registerKeyword("group");
        this.registerKeyword("having");
        this.registerKeyword("if");
        this.registerKeyword("in");
        this.registerKeyword("inner");
        this.registerKeyword("inout");
        this.registerKeyword("intersect");
        this.registerKeyword("into");
        this.registerKeyword("is");
        this.registerKeyword("join");
        this.registerKeyword("leading");
        this.registerKeyword("left");
        this.registerKeyword("limit");
        this.registerKeyword("loop");
        this.registerKeyword("minus");
        this.registerKeyword("natural");
        this.registerKeyword("nchar");
        this.registerKeyword("nextval");
        this.registerKeyword("null");
        this.registerKeyword("on");
        this.registerKeyword("order");
        this.registerKeyword("out");
        this.registerKeyword("prior");
        this.registerKeyword("return");
        this.registerKeyword("returns");
        this.registerKeyword("reverse");
        this.registerKeyword("right");
        this.registerKeyword("rollup");
        this.registerKeyword("rowid");
        this.registerKeyword("select");
        this.registerKeyword("session_user");
        this.registerKeyword("set");
        this.registerKeyword("sql");
        this.registerKeyword("start");
        this.registerKeyword("sysuuid");
        this.registerKeyword("tablesample");
        this.registerKeyword("top");
        this.registerKeyword("trailing");
        this.registerKeyword("true");
        this.registerKeyword("union");
        this.registerKeyword("unknown");
        this.registerKeyword("using");
        this.registerKeyword("utctimestamp");
        this.registerKeyword("values");
        this.registerKeyword("when");
        this.registerKeyword("where");
        this.registerKeyword("while");
        this.registerKeyword("with");
    }

    @Override
    public ScrollMode defaultScrollMode() {
        return ScrollMode.FORWARD_ONLY;
    }

    @Override
    public boolean supportsColumnCheck() {
        return false;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean supportsExpectedLobUsagePattern() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsPooledSequences() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsTableCheck() {
        return true;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    @Override
    public int getMaxAliasLength() {
        return 128;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LIMIT_HANDLER;
    }

    @Override
    public String getSelectGUIDString() {
        return "select sysuuid from sys.dummy";
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.applyIdentifierCasing(dbMetaData);
        builder.applyReservedWords(dbMetaData);
        builder.applyReservedWords(AnsiSqlKeywords.INSTANCE.sql2003());
        builder.applyReservedWords(this.getKeywords());
        builder.setNameQualifierSupport(this.getNameQualifierSupport());
        builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.UPPER);
        final IdentifierHelper identifierHelper = builder.build();
        return new IdentifierHelper(){
            private final IdentifierHelper helper;
            {
                this.helper = identifierHelper;
            }

            @Override
            public String toMetaDataSchemaName(Identifier schemaIdentifier) {
                return this.helper.toMetaDataSchemaName(schemaIdentifier);
            }

            @Override
            public String toMetaDataObjectName(Identifier identifier) {
                return this.helper.toMetaDataObjectName(identifier);
            }

            @Override
            public String toMetaDataCatalogName(Identifier catalogIdentifier) {
                return this.helper.toMetaDataCatalogName(catalogIdentifier);
            }

            @Override
            public Identifier toIdentifier(String text) {
                return this.normalizeQuoting(Identifier.toIdentifier(text));
            }

            @Override
            public Identifier toIdentifier(String text, boolean quoted) {
                return this.normalizeQuoting(Identifier.toIdentifier(text, quoted));
            }

            @Override
            public Identifier normalizeQuoting(Identifier identifier) {
                Identifier normalizedIdentifier = this.helper.normalizeQuoting(identifier);
                if (normalizedIdentifier == null) {
                    return null;
                }
                if (!normalizedIdentifier.isQuoted() && !normalizedIdentifier.getText().matches("\\w+")) {
                    normalizedIdentifier = Identifier.quote(normalizedIdentifier);
                }
                return normalizedIdentifier;
            }

            @Override
            public boolean isReservedWord(String word) {
                return this.helper.isReservedWord(word);
            }

            @Override
            public Identifier applyGlobalQuoting(String text) {
                return this.helper.applyGlobalQuoting(text);
            }
        };
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select current_schema from sys.dummy";
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString(aliases) + " nowait";
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.getWriteLockString(timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        return this.getWriteLockString(aliases, timeout);
    }

    @Override
    public String getWriteLockString(int timeout) {
        long timeoutInSeconds = this.getLockWaitTimeoutInSeconds(timeout);
        if (timeoutInSeconds > 0L) {
            return this.getForUpdateString() + " wait " + timeoutInSeconds;
        }
        if (timeoutInSeconds == 0L) {
            return this.getForUpdateNowaitString();
        }
        return this.getForUpdateString();
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        if (timeout > 0) {
            return this.getForUpdateString(aliases) + " wait " + this.getLockWaitTimeoutInSeconds(timeout);
        }
        if (timeout == 0) {
            return this.getForUpdateNowaitString(aliases);
        }
        return this.getForUpdateString(aliases);
    }

    private long getLockWaitTimeoutInSeconds(int timeoutInMilliseconds) {
        Duration duration = Duration.ofMillis(timeoutInMilliseconds);
        long timeoutInSeconds = duration.getSeconds();
        if (duration.getNano() != 0) {
            LOG.info("Changing the query timeout from " + timeoutInMilliseconds + " ms to " + timeoutInSeconds + " s, because HANA requires the timeout in seconds");
        }
        return timeoutInSeconds;
    }

    @Override
    public String getQueryHintString(String query, List<String> hints) {
        return query + " with hint (" + String.join((CharSequence)",", hints) + ")";
    }

    @Override
    public String getTableComment(String comment) {
        return "comment '" + comment + "'";
    }

    @Override
    public String getColumnComment(String comment) {
        return "comment '" + comment + "'";
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        ConnectionProvider connectionProvider = serviceRegistry.getService(ConnectionProvider.class);
        int maxLobPrefetchSizeDefault = 1024;
        if (connectionProvider != null) {
            Connection conn = null;
            try {
                conn = connectionProvider.getConnection();
                try (Statement statement = conn.createStatement();
                     ResultSet rs = statement.executeQuery("SELECT TOP 1 VALUE, MAP(LAYER_NAME, 'DEFAULT', 1, 'SYSTEM', 2, 'DATABASE', 3, 4) AS LAYER FROM SYS.M_INIFILE_CONTENTS WHERE FILE_NAME='indexserver.ini' AND SECTION='session' AND KEY='max_lob_prefetch_size' ORDER BY LAYER DESC");){
                    if (rs.next()) {
                        maxLobPrefetchSizeDefault = rs.getInt(1);
                    }
                }
            }
            catch (Exception e) {
                LOG.debug("An error occurred while trying to determine the value of the HANA parameter indexserver.ini / session / max_lob_prefetch_size. Using the default value " + maxLobPrefetchSizeDefault, e);
            }
            finally {
                if (conn != null) {
                    try {
                        connectionProvider.closeConnection(conn);
                    }
                    catch (SQLException e) {}
                }
            }
        }
        ConfigurationService configurationService = serviceRegistry.getService(ConfigurationService.class);
        this.useUnicodeStringTypes = configurationService.getSetting(USE_UNICODE_STRING_TYPES_PARAMETER_NAME, StandardConverters.BOOLEAN, USE_UNICODE_STRING_TYPES_DEFAULT_VALUE);
        if (this.useUnicodeStringTypes) {
            this.registerColumnType(1, "nvarchar(1)");
            this.registerColumnType(12, 5000L, "nvarchar($l)");
            this.registerColumnType(-1, 5000L, "nvarchar($l)");
            this.registerColumnType(-1, "nclob");
            this.registerColumnType(12, "nclob");
            this.registerColumnType(2005, "nclob");
        }
        int maxLobPrefetchSize = configurationService.getSetting(MAX_LOB_PREFETCH_SIZE_PARAMETER_NAME, value -> Integer.valueOf(value.toString()), Integer.valueOf(maxLobPrefetchSizeDefault));
        typeContributions.contributeSqlTypeDescriptor(new HANANClobSqlDescriptor(maxLobPrefetchSize));
        typeContributions.contributeSqlTypeDescriptor(new HANABlobTypeDescriptor(maxLobPrefetchSize));
        typeContributions.contributeSqlTypeDescriptor(new HANAClobTypeDescriptor(maxLobPrefetchSize, this.useUnicodeStringTypes));
        this.useLegacyBooleanType = configurationService.getSetting(USE_LEGACY_BOOLEAN_TYPE_PARAMETER_NAME, StandardConverters.BOOLEAN, USE_LEGACY_BOOLEAN_TYPE_DEFAULT_VALUE);
        if (this.useLegacyBooleanType) {
            this.registerColumnType(16, "tinyint");
        }
        this.treatDoubleTypedFieldsAsDecimal = configurationService.getSetting(TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_PARAMETER_NAME, StandardConverters.BOOLEAN, TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_DEFAULT_VALUE);
        if (this.treatDoubleTypedFieldsAsDecimal) {
            this.registerHibernateType(8, StandardSpiBasicTypes.BIG_DECIMAL.getJavaTypeDescriptor().getTypeName());
        }
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        if (this.useLegacyBooleanType) {
            return bool ? "1" : "0";
        }
        return bool ? "true" : "false";
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new HANAIdentityColumnSupport();
    }

    @Override
    public Exporter<ExportableTable> getTableExporter() {
        return this.hanaTableExporter;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.REF_CURSOR_INSTANCE;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int position) throws SQLException {
        return position;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsNoWait() {
        return true;
    }

    @Override
    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }

    @Override
    public boolean supportsNoColumnsInsert() {
        return false;
    }

    private static class MaterializedNClob
    implements NClob {
        private String data;

        public MaterializedNClob(String data) {
            this.data = data;
        }

        @Override
        public void truncate(long len) {
            this.data = new String();
        }

        @Override
        public int setString(long pos, String str, int offset, int len) {
            this.data = this.data.substring(0, (int)(pos - 1L)) + str.substring(offset, offset + len) + this.data.substring((int)(pos - 1L + (long)len));
            return len;
        }

        @Override
        public int setString(long pos, String str) {
            this.data = this.data.substring(0, (int)(pos - 1L)) + str + this.data.substring((int)(pos - 1L + (long)str.length()));
            return str.length();
        }

        @Override
        public Writer setCharacterStream(long pos) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public OutputStream setAsciiStream(long pos) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public long position(Clob searchstr, long start) {
            return this.data.indexOf(LobStreamDataHelper.extractString(searchstr), (int)(start - 1L));
        }

        @Override
        public long position(String searchstr, long start) {
            return this.data.indexOf(searchstr, (int)(start - 1L));
        }

        @Override
        public long length() {
            return this.data.length();
        }

        @Override
        public String getSubString(long pos, int length) {
            return this.data.substring((int)(pos - 1L), (int)(pos - 1L + (long)length));
        }

        @Override
        public Reader getCharacterStream(long pos, long length) {
            return new StringReader(this.data.substring((int)(pos - 1L), (int)(pos - 1L + length)));
        }

        @Override
        public Reader getCharacterStream() {
            return new StringReader(this.data);
        }

        @Override
        public InputStream getAsciiStream() {
            return new ByteArrayInputStream(this.data.getBytes(StandardCharsets.ISO_8859_1));
        }

        @Override
        public void free() {
            this.data = null;
        }
    }

    private static class MaterializedBlob
    implements Blob {
        private byte[] bytes = null;

        public MaterializedBlob(byte[] bytes) {
            this.setBytes(bytes);
        }

        @Override
        public long length() {
            return this.getBytes().length;
        }

        @Override
        public byte[] getBytes(long pos, int length) {
            return Arrays.copyOfRange(this.bytes, (int)(pos - 1L), (int)(pos - 1L + (long)length));
        }

        @Override
        public InputStream getBinaryStream() {
            return new ByteArrayInputStream(this.getBytes());
        }

        @Override
        public long position(byte[] pattern, long start) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public long position(Blob pattern, long start) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public int setBytes(long pos, byte[] bytes) {
            int bytesSet = 0;
            if ((long)this.bytes.length < pos - 1L + (long)bytes.length) {
                this.bytes = Arrays.copyOf(this.bytes, (int)(pos - 1L + (long)bytes.length));
            }
            int i = 0;
            while (i < bytes.length && i < this.bytes.length) {
                this.bytes[(int)((long)i + pos - 1L)] = bytes[i];
                ++i;
                ++bytesSet;
            }
            return bytesSet;
        }

        @Override
        public int setBytes(long pos, byte[] bytes, int offset, int len) {
            int bytesSet = 0;
            if ((long)this.bytes.length < pos - 1L + (long)len) {
                this.bytes = Arrays.copyOf(this.bytes, (int)(pos - 1L + (long)len));
            }
            int i = offset;
            while (i < len && i < this.bytes.length) {
                this.bytes[(int)((long)i + pos - 1L)] = bytes[i];
                ++i;
                ++bytesSet;
            }
            return bytesSet;
        }

        @Override
        public OutputStream setBinaryStream(long pos) {
            return new ByteArrayOutputStream(){
                {
                    this.buf = this.getBytes();
                }
            };
        }

        @Override
        public void truncate(long len) {
            this.setBytes(Arrays.copyOf(this.getBytes(), (int)len));
        }

        @Override
        public void free() {
            this.setBytes(null);
        }

        @Override
        public InputStream getBinaryStream(long pos, long length) {
            return new ByteArrayInputStream(this.getBytes(), (int)(pos - 1L), (int)length);
        }

        byte[] getBytes() {
            return this.bytes;
        }

        void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    private static class CloseSuppressingInputStream
    extends FilterInputStream {
        protected CloseSuppressingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }

    private static class CloseSuppressingReader
    extends FilterReader {
        protected CloseSuppressingReader(Reader in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }

    private static class HANAStreamBlobTypeDescriptor
    extends AbstractTemplateSqlTypeDescriptor {
        private static final long serialVersionUID = -2476600722093442047L;
        final int maxLobPrefetchSize;

        public HANAStreamBlobTypeDescriptor(int maxLobPrefetchSize) {
            this.maxLobPrefetchSize = maxLobPrefetchSize;
        }

        @Override
        public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
            return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(Clob.class);
        }

        @Override
        public int getJdbcTypeCode() {
            return 2004;
        }

        @Override
        public boolean canBeRemapped() {
            return true;
        }

        @Override
        protected <X> JdbcValueBinder<X> createBinder(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, int index, X value, ExecutionContext executionContext) throws SQLException {
                    BinaryStream binaryStream = javaTypeDescriptor.unwrap(value, BinaryStream.class, executionContext.getSession());
                    if (value instanceof BlobImplementer) {
                        try (CloseSuppressingInputStream is = new CloseSuppressingInputStream(binaryStream.getInputStream());){
                            st.setBinaryStream(index, (InputStream)is, binaryStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setBinaryStream(index, binaryStream.getInputStream(), binaryStream.getLength());
                    }
                }

                @Override
                protected void doBind(CallableStatement st, String name, X value, ExecutionContext executionContext) throws SQLException {
                    BinaryStream binaryStream = javaTypeDescriptor.unwrap(value, BinaryStream.class, executionContext.getSession());
                    if (value instanceof BlobImplementer) {
                        try (CloseSuppressingInputStream is = new CloseSuppressingInputStream(binaryStream.getInputStream());){
                            st.setBinaryStream(name, (InputStream)is, binaryStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setBinaryStream(name, binaryStream.getInputStream(), binaryStream.getLength());
                    }
                }
            };
        }

        @Override
        protected <X> JdbcValueExtractor<X> createExtractor(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueExtractor<X>(javaTypeDescriptor, this){

                @Override
                protected X doExtract(ResultSet rs, int position, ExecutionContext executionContext) throws SQLException {
                    Blob rsBlob = rs.getBlob(position);
                    if (rsBlob == null || rsBlob.length() < (long)maxLobPrefetchSize) {
                        return javaTypeDescriptor.wrap(rsBlob, executionContext.getSession());
                    }
                    MaterializedBlob blob = new MaterializedBlob(LobStreamDataHelper.extractBytes(rsBlob.getBinaryStream()));
                    return javaTypeDescriptor.wrap(blob, executionContext.getSession());
                }

                @Override
                protected X doExtract(CallableStatement statement, int position, ExecutionContext executionContext) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getBlob(position), executionContext.getSession());
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, ExecutionContext executionContext) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getBlob(name), executionContext.getSession());
                }
            };
        }

        @Override
        public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
            return null;
        }
    }

    public static class HANABlobTypeDescriptor
    extends AbstractTemplateSqlTypeDescriptor {
        private static final long serialVersionUID = 5874441715643764323L;
        final int maxLobPrefetchSize;
        final HANAStreamBlobTypeDescriptor hanaStreamBlobTypeDescriptor;

        public HANABlobTypeDescriptor(int maxLobPrefetchSize) {
            this.maxLobPrefetchSize = maxLobPrefetchSize;
            this.hanaStreamBlobTypeDescriptor = new HANAStreamBlobTypeDescriptor(maxLobPrefetchSize);
        }

        @Override
        public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
            return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(Clob.class);
        }

        @Override
        public int getJdbcTypeCode() {
            return 2004;
        }

        @Override
        public boolean canBeRemapped() {
            return true;
        }

        @Override
        protected <X> JdbcValueExtractor<X> createExtractor(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueExtractor<X>(javaTypeDescriptor, this){

                @Override
                protected X doExtract(ResultSet rs, int position, ExecutionContext executionContext) throws SQLException {
                    Blob rsBlob = rs.getBlob(position);
                    if (rsBlob == null || rsBlob.length() < (long)maxLobPrefetchSize) {
                        return javaTypeDescriptor.wrap(rsBlob, executionContext.getSession());
                    }
                    MaterializedBlob blob = new MaterializedBlob(LobStreamDataHelper.extractBytes(rsBlob.getBinaryStream()));
                    return javaTypeDescriptor.wrap(blob, executionContext.getSession());
                }

                @Override
                protected X doExtract(CallableStatement statement, int position, ExecutionContext executionContext) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getBlob(position), executionContext.getSession());
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, ExecutionContext executionContext) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getBlob(name), executionContext.getSession());
                }
            };
        }

        @Override
        protected <X> JdbcValueBinder<X> createBinder(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, int index, X value, ExecutionContext executionContext) throws SQLException {
                    SharedSessionContractImplementor session = executionContext.getSession();
                    AbstractTemplateSqlTypeDescriptor descriptor = BlobSqlDescriptor.BLOB_BINDING;
                    if (byte[].class.isInstance(value)) {
                        descriptor = BlobSqlDescriptor.PRIMITIVE_ARRAY_BINDING;
                    } else if (session.useStreamForLobBinding()) {
                        descriptor = hanaStreamBlobTypeDescriptor;
                    }
                    TypeConfiguration typeConfiguration = session.getFactory().getTypeConfiguration();
                    descriptor.getSqlExpressableType(javaTypeDescriptor, typeConfiguration).getJdbcValueBinder().bind(st, index, value, executionContext);
                }

                @Override
                protected void doBind(CallableStatement st, String name, X value, ExecutionContext executionContext) throws SQLException {
                    SharedSessionContractImplementor session = executionContext.getSession();
                    AbstractTemplateSqlTypeDescriptor descriptor = BlobSqlDescriptor.BLOB_BINDING;
                    if (byte[].class.isInstance(value)) {
                        descriptor = BlobSqlDescriptor.PRIMITIVE_ARRAY_BINDING;
                    } else if (session.useStreamForLobBinding()) {
                        descriptor = hanaStreamBlobTypeDescriptor;
                    }
                    TypeConfiguration typeConfiguration = session.getFactory().getTypeConfiguration();
                    descriptor.getSqlExpressableType(javaTypeDescriptor, typeConfiguration).getJdbcValueBinder().bind(st, name, value, executionContext);
                }
            };
        }

        public int getMaxLobPrefetchSize() {
            return this.maxLobPrefetchSize;
        }

        @Override
        public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
            return null;
        }
    }

    private static class HANANClobSqlDescriptor
    extends NClobSqlDescriptor {
        private static final long serialVersionUID = 5651116091681647859L;
        final int maxLobPrefetchSize;

        public HANANClobSqlDescriptor(int maxLobPrefetchSize) {
            this.maxLobPrefetchSize = maxLobPrefetchSize;
        }

        @Override
        public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
            return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(Clob.class);
        }

        @Override
        protected <X> JdbcValueBinder<X> createBinder(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, int index, X value, ExecutionContext executionContext) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, executionContext.getSession());
                    if (value instanceof NClobImplementer) {
                        try (CloseSuppressingReader r = new CloseSuppressingReader(characterStream.asReader());){
                            st.setCharacterStream(index, (Reader)r, characterStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setCharacterStream(index, characterStream.asReader(), characterStream.getLength());
                    }
                }

                @Override
                protected void doBind(CallableStatement st, String name, X value, ExecutionContext executionContext) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, executionContext.getSession());
                    if (value instanceof NClobImplementer) {
                        try (CloseSuppressingReader r = new CloseSuppressingReader(characterStream.asReader());){
                            st.setCharacterStream(name, (Reader)r, characterStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setCharacterStream(name, characterStream.asReader(), characterStream.getLength());
                    }
                }
            };
        }

        @Override
        protected <X> JdbcValueExtractor<X> createExtractor(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueExtractor<X>(javaTypeDescriptor, this){

                @Override
                protected X doExtract(ResultSet rs, int position, ExecutionContext executionContext) throws SQLException {
                    NClob rsNClob = rs.getNClob(position);
                    if (rsNClob == null || rsNClob.length() < (long)maxLobPrefetchSize) {
                        return javaTypeDescriptor.wrap(rsNClob, executionContext.getSession());
                    }
                    MaterializedNClob nClob = new MaterializedNClob(LobStreamDataHelper.extractString(rsNClob));
                    return javaTypeDescriptor.wrap(nClob, executionContext.getSession());
                }

                @Override
                protected X doExtract(CallableStatement statement, int position, ExecutionContext executionContext) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getNClob(position), executionContext.getSession());
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, ExecutionContext executionContext) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getNClob(name), executionContext.getSession());
                }
            };
        }

        public int getMaxLobPrefetchSize() {
            return this.maxLobPrefetchSize;
        }

        @Override
        public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
            return null;
        }
    }

    private static class HANAClobTypeDescriptor
    extends ClobSqlDescriptor {
        private static final long serialVersionUID = -379042275442752102L;
        final int maxLobPrefetchSize;
        final boolean useUnicodeStringTypes;

        public HANAClobTypeDescriptor(int maxLobPrefetchSize, boolean useUnicodeStringTypes) {
            this.maxLobPrefetchSize = maxLobPrefetchSize;
            this.useUnicodeStringTypes = useUnicodeStringTypes;
        }

        @Override
        public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
            return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(Clob.class);
        }

        @Override
        protected <X> JdbcValueBinder<X> createBinder(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, int index, X value, ExecutionContext executionContext) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, executionContext.getSession());
                    if (value instanceof ClobImplementer) {
                        try (CloseSuppressingReader r = new CloseSuppressingReader(characterStream.asReader());){
                            st.setCharacterStream(index, (Reader)r, characterStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setCharacterStream(index, characterStream.asReader(), characterStream.getLength());
                    }
                }

                @Override
                protected void doBind(CallableStatement st, String name, X value, ExecutionContext executionContext) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, executionContext.getSession());
                    if (value instanceof ClobImplementer) {
                        try (CloseSuppressingReader r = new CloseSuppressingReader(characterStream.asReader());){
                            st.setCharacterStream(name, (Reader)r, characterStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setCharacterStream(name, characterStream.asReader(), characterStream.getLength());
                    }
                }
            };
        }

        @Override
        protected <X> JdbcValueExtractor<X> createExtractor(final BasicJavaDescriptor<X> javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return new AbstractJdbcValueExtractor<X>(javaTypeDescriptor, this){

                @Override
                protected X doExtract(ResultSet rs, int position, ExecutionContext executionContext) throws SQLException {
                    Clob rsClob = useUnicodeStringTypes ? rs.getNClob(position) : rs.getClob(position);
                    if (rsClob == null || rsClob.length() < (long)maxLobPrefetchSize) {
                        return javaTypeDescriptor.wrap(rsClob, executionContext.getSession());
                    }
                    MaterializedNClob clob = new MaterializedNClob(LobStreamDataHelper.extractString(rsClob));
                    return javaTypeDescriptor.wrap(clob, executionContext.getSession());
                }

                @Override
                protected X doExtract(CallableStatement statement, int position, ExecutionContext executionContext) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getClob(position), executionContext.getSession());
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, ExecutionContext executionContext) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getClob(name), executionContext.getSession());
                }
            };
        }
    }
}

