/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.SybaseLocateEmulationFunctionTemplate;
import org.hibernate.dialect.identity.AbstractTransactSQLIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.naming.Identifier;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.spi.ConcatFunctionTemplate;
import org.hibernate.type.spi.StandardSpiBasicTypes;

abstract class AbstractTransactSQLDialect
extends Dialect {
    public AbstractTransactSQLDialect() {
        this.registerColumnType(-2, "binary($l)");
        this.registerColumnType(-7, "tinyint");
        this.registerColumnType(-5, "numeric(19,0)");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(4, "int");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "datetime");
        this.registerColumnType(92, "datetime");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "image");
        this.registerColumnType(2005, "text");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.namedTemplateBuilder("ascii").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("char").setInvariantType(StandardSpiBasicTypes.CHARACTER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("len").setInvariantType(StandardSpiBasicTypes.LONG).setExactArgumentCount(1).register();
        CommonFunctionFactory.lower(registry);
        CommonFunctionFactory.upper(registry);
        registry.namedTemplateBuilder("str").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 3).register();
        registry.namedTemplateBuilder("ltrim").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("rtrim").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("reverse").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("space").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.registerNoArgs("user", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("current_timestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNoArgs("current_time", StandardSpiBasicTypes.TIME);
        registry.registerNoArgs("current_date", StandardSpiBasicTypes.DATE);
        registry.noArgsBuilder("getdate").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setUseParenthesesWhenNoArgs(true).register();
        registry.noArgsBuilder("getutcdate").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setUseParenthesesWhenNoArgs(true).register();
        registry.namedTemplateBuilder("day").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("month").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("year").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("datename").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(2).register();
        CommonFunctionFactory.abs(registry);
        CommonFunctionFactory.sign(registry);
        CommonFunctionFactory.acos(registry);
        CommonFunctionFactory.asin(registry);
        CommonFunctionFactory.atan(registry);
        CommonFunctionFactory.cos(registry);
        CommonFunctionFactory.cot(registry);
        CommonFunctionFactory.exp(registry);
        CommonFunctionFactory.log(registry);
        CommonFunctionFactory.log10(registry);
        CommonFunctionFactory.sin(registry);
        CommonFunctionFactory.sqrt(registry);
        CommonFunctionFactory.tan(registry);
        CommonFunctionFactory.sin(registry);
        registry.noArgsBuilder("pi").setInvariantType(StandardSpiBasicTypes.DOUBLE).setUseParenthesesWhenNoArgs(true).register();
        registry.namedTemplateBuilder("square").setExactArgumentCount(1).register();
        CommonFunctionFactory.rand(registry);
        CommonFunctionFactory.radians(registry);
        CommonFunctionFactory.degrees(registry);
        CommonFunctionFactory.round(registry);
        CommonFunctionFactory.ceiling(registry);
        CommonFunctionFactory.floor(registry);
        registry.namedTemplateBuilder("isnull").setExactArgumentCount(2).register();
        registry.register("concat", new ConcatFunctionTemplate("(", "+", ")"));
        registry.registerAlternateKey("length", "len");
        registry.registerPattern("trim", "ltrim(rtrim(?1))", StandardSpiBasicTypes.STRING);
        registry.register("locate", new SybaseLocateEmulationFunctionTemplate());
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getNullColumnString() {
        return "";
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getForUpdateString() {
        return "";
    }

    @Override
    public String appendLockHint(LockOptions lockOptions, String tableName) {
        return lockOptions.getLockMode().greaterThan(LockMode.READ) ? tableName + " holdlock" : tableName;
    }

    @Override
    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        Iterator<Map.Entry<String, LockMode>> itr = aliasedLockOptions.getAliasLockIterator();
        StringBuilder buffer = new StringBuilder(sql);
        while (itr.hasNext()) {
            Map.Entry<String, LockMode> entry = itr.next();
            LockMode lockMode = entry.getValue();
            if (!lockMode.greaterThan(LockMode.READ)) continue;
            String alias = entry.getKey();
            int start = -1;
            int end = -1;
            if (sql.endsWith(" " + alias)) {
                start = buffer.length() - alias.length();
                end = start + alias.length();
            } else {
                int position = buffer.indexOf(" " + alias + " ");
                if (position <= -1) {
                    position = buffer.indexOf(" " + alias + ",");
                }
                if (position > -1) {
                    start = position + 1;
                    end = start + alias.length();
                }
            }
            if (start <= -1) continue;
            String lockHint = this.appendLockHint(aliasedLockOptions, alias);
            buffer.replace(start, end, lockHint);
        }
        return buffer.toString();
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select getdate()";
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        StandardIdTableSupport idTableSupport = new StandardIdTableSupport(this.getIdTableExporter()){

            @Override
            protected Identifier determineIdTableName(Identifier baseName) {
                return new Identifier("#" + baseName.getText(), false);
            }
        };
        return new LocalTemporaryTableStrategy(idTableSupport);
    }

    @Override
    public String getSelectGUIDString() {
        return "select newid()";
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public boolean supportsTuplesInSubqueries() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new AbstractTransactSQLIdentityColumnSupport();
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }
}

