/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.ConvertFunctionTemplate;
import org.hibernate.dialect.function.NvlFunctionTemplate;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.dialect.identity.Chache71IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadUpdateLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteUpdateLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.lock.UpdateLockingStrategy;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.exception.internal.CacheSQLExceptionConversionDelegate;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.metamodel.model.domain.spi.Lockable;
import org.hibernate.naming.Identifier;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.sql.CacheJoinFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class Cache71Dialect
extends Dialect {
    private LimitHandler limitHandler;
    public static final ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        @Override
        protected String doExtractConstraintName(SQLException sqle) throws NumberFormatException {
            return this.extractUsingTemplate("constraint (", ") violated", sqle.getMessage());
        }
    };

    public Cache71Dialect() {
        this.commonRegistration();
        this.limitHandler = new TopLimitHandler(true, true);
    }

    protected final void commonRegistration() {
        this.registerColumnType(-2, "varbinary($1)");
        this.registerColumnType(-5, "BigInt");
        this.registerColumnType(-7, "bit");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal");
        this.registerColumnType(8, "double");
        this.registerColumnType(6, "float");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "longvarbinary");
        this.registerColumnType(-1, "longvarchar");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(7, "real");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(92, "time");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(-3, "longvarbinary");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(2004, "longvarbinary");
        this.registerColumnType(2005, "longvarchar");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "false");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.use_sql_comments", "false");
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        this.commonFunctionRegistrations(registry);
        this.register71Functions(registry);
    }

    protected void commonFunctionRegistrations(SqmFunctionRegistry registry) {
        CommonFunctionFactory.acos(registry);
        registry.namedTemplateBuilder("%alphaup").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("ascii").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        CommonFunctionFactory.asin(registry);
        CommonFunctionFactory.atan(registry);
        registry.registerPattern("bit_length", "($length(?1)*8)", StandardSpiBasicTypes.INTEGER);
        CommonFunctionFactory.ceiling(registry);
        registry.wrapInJdbcEscape("char", registry.namedTemplateBuilder("char").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register());
        registry.namedTemplateBuilder("bit_length").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("character_length").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("char_length").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        CommonFunctionFactory.cos(registry);
        CommonFunctionFactory.cot(registry);
        registry.register("concat", new VarArgsSQLFunction(StandardSpiBasicTypes.STRING, "", "||", ""));
        registry.register("convert", new ConvertFunctionTemplate());
        registry.wrapInJdbcEscape("curdate", registry.registerNamed("curdate", StandardSpiBasicTypes.DATE));
        registry.wrapInJdbcEscape("curtime", registry.registerNamed("curtime", StandardSpiBasicTypes.TIME));
        registry.wrapInJdbcEscape("database", registry.registerNamed("database", StandardSpiBasicTypes.STRING));
        registry.registerVarArgs("dateadd", StandardSpiBasicTypes.TIMESTAMP, "dateadd(", ",", ")");
        registry.registerVarArgs("datediff", StandardSpiBasicTypes.INTEGER, "datediff(", ",", ")");
        registry.registerVarArgs("datename", StandardSpiBasicTypes.STRING, "datename(", ",", ")");
        registry.registerVarArgs("datepart", StandardSpiBasicTypes.INTEGER, "datepart(", ",", ")");
        registry.registerNamed("day", StandardSpiBasicTypes.INTEGER);
        registry.wrapInJdbcEscape("dayname", registry.registerNamed("dayname", StandardSpiBasicTypes.STRING));
        registry.wrapInJdbcEscape("dayofmonth", registry.registerNamed("dayofmonth", StandardSpiBasicTypes.INTEGER));
        registry.wrapInJdbcEscape("dayofweek", registry.registerNamed("dayofweek", StandardSpiBasicTypes.INTEGER));
        registry.wrapInJdbcEscape("dayofyear", registry.registerNamed("dayofyear", StandardSpiBasicTypes.INTEGER));
        registry.registerNamed("%exact", StandardSpiBasicTypes.STRING);
        registry.wrapInJdbcEscape("exp", registry.registerNamed("exp", StandardSpiBasicTypes.DOUBLE));
        registry.registerNamed("%external", StandardSpiBasicTypes.STRING);
        registry.registerVarArgs("$extract", StandardSpiBasicTypes.INTEGER, "$extract(", ",", ")");
        registry.registerVarArgs("$find", StandardSpiBasicTypes.INTEGER, "$find(", ",", ")");
        registry.registerNamed("floor", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("getdate", StandardSpiBasicTypes.TIMESTAMP);
        registry.wrapInJdbcEscape("hour", registry.registerNamed("hour", StandardSpiBasicTypes.INTEGER));
        registry.varArgsBuilder("ifnull", "ifnull(", ",", ")").register();
        registry.registerNamed("%internal");
        registry.varArgsBuilder("isnull", "isnull(", ",", ")").register();
        registry.registerNamed("isnumeric", StandardSpiBasicTypes.INTEGER);
        registry.wrapInJdbcEscape("lcase", registry.registerNamed("lcase", StandardSpiBasicTypes.STRING));
        registry.wrapInJdbcEscape("left", registry.registerNamed("left", StandardSpiBasicTypes.STRING));
        registry.registerNamed("len", StandardSpiBasicTypes.INTEGER);
        registry.varArgsBuilder("$length", "$length(", ",", ")").register();
        registry.varArgsBuilder("$list", "$list(", ",", ")").register();
        registry.varArgsBuilder("$listdata", "$listdata(", ",", ")").register();
        registry.varArgsBuilder("$listfind", "$listfind(", ",", ")").register();
        registry.varArgsBuilder("$listget", "$listget(", ",", ")").register();
        registry.registerNamed("$listlength", StandardSpiBasicTypes.INTEGER);
        registry.namedTemplateBuilder("locate", "$FIND").setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.wrapInJdbcEscape("log", registry.registerNamed("log", StandardSpiBasicTypes.DOUBLE));
        registry.wrapInJdbcEscape("log10", registry.registerNamed("log", StandardSpiBasicTypes.DOUBLE));
        registry.registerNamed("lower");
        registry.registerNamed("ltrim");
        registry.wrapInJdbcEscape("minute", registry.registerNamed("minute", StandardSpiBasicTypes.INTEGER));
        registry.wrapInJdbcEscape("mod", registry.registerNamed("mod", StandardSpiBasicTypes.DOUBLE));
        registry.wrapInJdbcEscape("month", registry.registerNamed("month", StandardSpiBasicTypes.INTEGER));
        registry.wrapInJdbcEscape("monthname", registry.registerNamed("monthname", StandardSpiBasicTypes.STRING));
        registry.wrapInJdbcEscape("now", registry.registerNamed("monthname", StandardSpiBasicTypes.TIMESTAMP));
        registry.varArgsBuilder("nullif", "nullif(", ",", ")").register();
        registry.register("nvl", new NvlFunctionTemplate());
        registry.registerNamed("%odbcin");
        registry.registerNamed("%odbcout");
        registry.registerVarArgs("%pattern", StandardSpiBasicTypes.STRING, "", "%pattern", "");
        registry.wrapInJdbcEscape("pi", registry.registerNamed("pi", StandardSpiBasicTypes.DOUBLE));
        registry.registerVarArgs("$piece", StandardSpiBasicTypes.STRING, "$piece(", ",", ")");
        registry.registerVarArgs("position", StandardSpiBasicTypes.INTEGER, "position(", " in ", ")");
        registry.registerVarArgs("power", StandardSpiBasicTypes.STRING, "power(", ",", ")");
        registry.wrapInJdbcEscape("quarter", registry.registerNamed("quarter", StandardSpiBasicTypes.INTEGER));
        registry.registerVarArgs("repeat", StandardSpiBasicTypes.STRING, "repeat(", ",", ")");
        registry.registerVarArgs("replicate", StandardSpiBasicTypes.STRING, "replicate(", ",", ")");
        registry.wrapInJdbcEscape("right", registry.registerNamed("right", StandardSpiBasicTypes.STRING));
        registry.registerVarArgs("round", StandardSpiBasicTypes.FLOAT, "round(", ",", ")");
        registry.registerNamed("rtrim", StandardSpiBasicTypes.STRING);
        registry.wrapInJdbcEscape("second", registry.registerNamed("second", StandardSpiBasicTypes.INTEGER));
        registry.registerNamed("sign", StandardSpiBasicTypes.INTEGER);
        registry.wrapInJdbcEscape("sin", registry.registerNamed("sin", StandardSpiBasicTypes.DOUBLE));
        registry.registerNamed("space", StandardSpiBasicTypes.STRING);
        registry.registerVarArgs("%sqlstring", StandardSpiBasicTypes.STRING, "%sqlstring(", ",", ")");
        registry.registerVarArgs("%sqlupper", StandardSpiBasicTypes.STRING, "%sqlupper(", ",", ")");
        registry.wrapInJdbcEscape("sqrt", registry.registerNamed("SQRT", StandardSpiBasicTypes.DOUBLE));
        registry.registerVarArgs("%startswith", StandardSpiBasicTypes.STRING, "", "%startswith", "");
        registry.registerPattern("str", "cast(?1 as char varying)", StandardSpiBasicTypes.STRING);
        registry.registerVarArgs("string", StandardSpiBasicTypes.STRING, "string(", ",", ")");
        registry.registerVarArgs("%string", StandardSpiBasicTypes.STRING, "%string(", ",", ")");
        registry.registerVarArgs("substr", StandardSpiBasicTypes.STRING, "substr(", ",", ")");
        registry.registerVarArgs("substring", StandardSpiBasicTypes.STRING, "substring(", ",", ")");
        registry.registerNoArgs("sysdate", StandardSpiBasicTypes.TIMESTAMP);
        registry.wrapInJdbcEscape("tan", registry.registerNamed("tan", StandardSpiBasicTypes.DOUBLE));
        registry.wrapInJdbcEscape("timestampadd", registry.registerNamed("timestampadd", StandardSpiBasicTypes.DOUBLE));
        registry.wrapInJdbcEscape("timestampdiff", registry.registerNamed("timestampdiff", StandardSpiBasicTypes.DOUBLE));
        registry.registerVarArgs("tochar", StandardSpiBasicTypes.STRING, "tochar(", ",", ")");
        registry.registerVarArgs("to_char", StandardSpiBasicTypes.STRING, "to_char(", ",", ")");
        registry.registerVarArgs("todate", StandardSpiBasicTypes.STRING, "todate(", ",", ")");
        registry.registerVarArgs("to_date", StandardSpiBasicTypes.STRING, "todate(", ",", ")");
        registry.registerNamed("tonumber");
        registry.registerAlternateKey("to_number", "tonumber");
        registry.wrapInJdbcEscape("truncate", registry.registerNamed("truncate", StandardSpiBasicTypes.STRING));
        registry.wrapInJdbcEscape("ucase", registry.registerNamed("ucase", StandardSpiBasicTypes.STRING));
        registry.registerNamed("upper");
        registry.registerNamed("%upper");
        registry.wrapInJdbcEscape("user", registry.registerNamed("user", StandardSpiBasicTypes.STRING));
        registry.wrapInJdbcEscape("week", registry.registerNamed("week", StandardSpiBasicTypes.INTEGER));
        registry.registerVarArgs("xmlconcat", StandardSpiBasicTypes.STRING, "xmlconcat(", ",", ")");
        registry.registerVarArgs("xmlelement", StandardSpiBasicTypes.STRING, "xmlelement(", ",", ")");
        registry.wrapInJdbcEscape("year", registry.registerNamed("year", StandardSpiBasicTypes.INTEGER));
    }

    protected void register71Functions(SqmFunctionRegistry registry) {
        registry.register("str", new VarArgsSQLFunction(StandardSpiBasicTypes.STRING, "str(", ",", ")"));
    }

    @Override
    public boolean hasAlterTable() {
        return true;
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        return new StringBuilder(300).append(" ADD CONSTRAINT ").append(constraintName).append(" FOREIGN KEY ").append(constraintName).append(" (").append(String.join((CharSequence)", ", foreignKey)).append(") REFERENCES ").append(referencedTable).append(" (").append(String.join((CharSequence)", ", primaryKey)).append(") ").toString();
    }

    public boolean supportsCheck() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return " add column";
    }

    @Override
    public String getCascadeConstraintsString() {
        return "";
    }

    @Override
    public boolean dropConstraints() {
        return true;
    }

    @Override
    public boolean supportsCascadeDelete() {
        return true;
    }

    @Override
    public boolean hasSelfReferentialForeignKeyBug() {
        return true;
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new GlobalTemporaryTableStrategy(this.generateIdTableSupport());
    }

    private IdTableSupport generateIdTableSupport() {
        return new StandardIdTableSupport(new GlobalTempTableExporter()){

            @Override
            protected Identifier determineIdTableName(Identifier baseName) {
                Identifier name = super.determineIdTableName(baseName);
                return name.getText().length() > 25 ? new Identifier(name.getText().substring(1, 25), false) : name;
            }
        };
    }

    @Override
    public String getNativeIdentifierGeneratorStrategy() {
        return "identity";
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new Chache71IdentityColumnSupport();
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_WRITE) {
            return new PessimisticWriteUpdateLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_READ) {
            return new PessimisticReadUpdateLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC) {
            return new OptimisticLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT) {
            return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode.greaterThan(LockMode.READ)) {
            return new UpdateLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    @Override
    public LimitHandler getLimitHandler() {
        if (this.isLegacyLimitHandlerBehaviorEnabled()) {
            return super.getLimitHandler();
        }
        return this.limitHandler;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsLimitOffset() {
        return false;
    }

    @Override
    public boolean supportsVariableLimit() {
        return true;
    }

    @Override
    public boolean bindLimitParametersFirst() {
        return true;
    }

    @Override
    public boolean useMaxForLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        if (hasOffset) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        int insertionPoint = sql.startsWith("select distinct") ? 15 : 6;
        return new StringBuilder(sql.length() + 8).append(sql).insert(insertionPoint, " TOP ? ").toString();
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public String getLowercaseFunction() {
        return "lower";
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public JoinFragment createOuterJoinFragment() {
        return new CacheJoinFragment();
    }

    @Override
    public String getNoColumnsInsertString() {
        return " default values";
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new CacheSQLExceptionConversionDelegate(this);
    }

    @Override
    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean areStringComparisonsCaseInsensitive() {
        return true;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }
}

