/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.function.DB2SubstringFunctionTemplate;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.descriptor.sql.spi.CharSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.ClobSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.VarcharSqlDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class DB297Dialect
extends DB2Dialect {
    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.registerNamed("chr", StandardSpiBasicTypes.CHARACTER);
        registry.register("substring", new DB2SubstringFunctionTemplate());
    }

    @Override
    public String getCrossJoinSeparator() {
        return " cross join ";
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new GlobalTemporaryTableStrategy(this.generateIdTableSupport());
    }

    @Override
    protected IdTableSupport generateIdTableSupport() {
        return new StandardIdTableSupport(new GlobalTempTableExporter()){

            @Override
            public Exporter<IdTable> getIdTableExporter() {
                return DB297Dialect.this.generateIdTableExporter();
            }
        };
    }

    @Override
    protected Exporter<IdTable> generateIdTableExporter() {
        return new GlobalTempTableExporter(){

            @Override
            protected String getCreateOptions() {
                return "not logged";
            }

            @Override
            protected String getCreateCommand() {
                return "create global temporary table";
            }
        };
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        switch (sqlCode) {
            case -15: {
                return CharSqlDescriptor.INSTANCE;
            }
            case 2011: {
                if (this.useInputStreamToInsertBlob()) {
                    return ClobSqlDescriptor.STREAM_BINDING;
                }
                return ClobSqlDescriptor.CLOB_BINDING;
            }
            case -9: {
                return VarcharSqlDescriptor.INSTANCE;
            }
        }
        return super.getSqlTypeDescriptorOverride(sqlCode);
    }
}

