/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.hibernate.JDBCException;
import org.hibernate.MappingException;
import org.hibernate.NullPrecedence;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.dialect.unique.DB2UniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.naming.Identifier;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.spi.AnsiTrimFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.ConcatFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.StandardAnsiSqlSqmAggregationFunctionTemplates;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorDB2DatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.descriptor.sql.spi.DecimalSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.SmallIntSqlDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class DB2Dialect
extends Dialect {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(DB2Dialect.class);
    private static final AbstractLimitHandler LIMIT_HANDLER = new AbstractLimitHandler(){

        @Override
        public String processSql(String sql, RowSelection selection) {
            if (LimitHelper.hasFirstRow(selection)) {
                return "select * from ( select inner2_.*, rownumber() over(order by order of inner2_) as rownumber_ from ( " + sql + " fetch first " + this.getMaxOrLimit(selection) + " rows only ) as inner2_ ) as inner1_ where rownumber_ > " + selection.getFirstRow() + " order by rownumber_";
            }
            return sql + " fetch first " + this.getMaxOrLimit(selection) + " rows only";
        }

        @Override
        public boolean supportsLimit() {
            return true;
        }

        @Override
        public boolean useMaxForLimit() {
            return true;
        }

        @Override
        public boolean supportsVariableLimit() {
            return false;
        }
    };
    private final UniqueDelegate uniqueDelegate;

    public DB2Dialect() {
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "varchar($l) for bit data");
        this.registerColumnType(2, "decimal($p,$s)");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(2004, "blob($l)");
        this.registerColumnType(2005, "clob($l)");
        this.registerColumnType(-1, "long varchar");
        this.registerColumnType(-4, "long varchar for bit data");
        this.registerColumnType(-2, "varchar($l) for bit data");
        this.registerColumnType(-2, 254L, "char($l) for bit data");
        this.registerColumnType(16, "smallint");
        this.registerKeyword("current");
        this.registerKeyword("date");
        this.registerKeyword("time");
        this.registerKeyword("timestamp");
        this.registerKeyword("fetch");
        this.registerKeyword("first");
        this.registerKeyword("rows");
        this.registerKeyword("only");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
        this.uniqueDelegate = new DB2UniqueDelegate(this);
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.register("avg", new StandardAnsiSqlSqmAggregationFunctionTemplates.AvgFunctionTemplate("double"));
        CommonFunctionFactory.abs(registry);
        CommonFunctionFactory.sign(registry);
        CommonFunctionFactory.ceiling(registry);
        CommonFunctionFactory.ceil(registry);
        CommonFunctionFactory.floor(registry);
        CommonFunctionFactory.round(registry);
        CommonFunctionFactory.sqrt(registry);
        registry.namedTemplateBuilder("absval").setExactArgumentCount(1).register();
        CommonFunctionFactory.acos(registry);
        CommonFunctionFactory.asin(registry);
        CommonFunctionFactory.atan(registry);
        CommonFunctionFactory.cos(registry);
        CommonFunctionFactory.cot(registry);
        CommonFunctionFactory.degrees(registry);
        CommonFunctionFactory.exp(registry);
        CommonFunctionFactory.ln(registry);
        CommonFunctionFactory.log(registry);
        CommonFunctionFactory.log10(registry);
        CommonFunctionFactory.radians(registry);
        CommonFunctionFactory.sin(registry);
        CommonFunctionFactory.radians(registry);
        CommonFunctionFactory.tan(registry);
        registry.namedTemplateBuilder("float").setInvariantType(StandardSpiBasicTypes.DOUBLE).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("hex").setInvariantType(StandardSpiBasicTypes.DOUBLE).setExactArgumentCount(1).register();
        CommonFunctionFactory.rand(registry);
        CommonFunctionFactory.soundex(registry);
        CommonFunctionFactory.stddev(registry);
        CommonFunctionFactory.variance(registry);
        registry.namedTemplateBuilder("julian_day").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("microsecond").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("midnight_seconds").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("minute").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("month").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("monthname").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("quarter").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("hour").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("second").setInvariantType(StandardSpiBasicTypes.INTEGER).setArgumentCountBetween(1, 2).register();
        registry.registerNoArgs("current_date", StandardSpiBasicTypes.DATE);
        registry.namedTemplateBuilder("date").setInvariantType(StandardSpiBasicTypes.DATE).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("day").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("dayname").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("dayofweek").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("dayofweek_iso").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("dayofyear").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("days").setInvariantType(StandardSpiBasicTypes.LONG).setExactArgumentCount(1).register();
        registry.registerNoArgs("current_time", StandardSpiBasicTypes.TIME);
        registry.namedTemplateBuilder("time").setInvariantType(StandardSpiBasicTypes.TIME).setExactArgumentCount(1).register();
        registry.registerNoArgs("current_timestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.namedTemplateBuilder("timestamp").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setArgumentCountBetween(1, 2).register();
        registry.namedTemplateBuilder("timestamp_iso").setInvariantType(StandardSpiBasicTypes.TIMESTAMP).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("week").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("week_iso").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("year").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("double").setInvariantType(StandardSpiBasicTypes.DOUBLE).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("varchar").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentsValidator(StandardArgumentsValidators.min(1)).register();
        registry.namedTemplateBuilder("real").setInvariantType(StandardSpiBasicTypes.FLOAT).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("bigint").setInvariantType(StandardSpiBasicTypes.LONG).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("char").setArgumentsValidator(StandardArgumentsValidators.min(1)).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("integer").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("smallint").setInvariantType(StandardSpiBasicTypes.SHORT).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("digits").setInvariantType(StandardSpiBasicTypes.STRING).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("chr").setInvariantType(StandardSpiBasicTypes.CHARACTER).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("upper").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 3).register();
        registry.namedTemplateBuilder("lower").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 3).register();
        registry.registerAlternateKey("ucase", "upper");
        registry.registerAlternateKey("lcase", "lower");
        registry.namedTemplateBuilder("ltrim").setArgumentCountBetween(1, 2).register();
        registry.namedTemplateBuilder("rtrim").setArgumentCountBetween(1, 2).register();
        registry.namedTemplateBuilder("substr").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(1, 3).register();
        registry.namedTemplateBuilder("posstr").setInvariantType(StandardSpiBasicTypes.INTEGER).setExactArgumentCount(2).register();
        registry.namedTemplateBuilder("substring", "substr").setInvariantType(StandardSpiBasicTypes.STRING).setArgumentCountBetween(2, 4).register();
        registry.registerPattern("bit_length", "length(?1)*8", StandardSpiBasicTypes.INTEGER);
        registry.register("trim", AnsiTrimFunctionTemplate.INSTANCE);
        registry.register("concat", ConcatFunctionTemplate.INSTANCE);
        registry.registerPattern("str", "rtrim(char(?1))", StandardSpiBasicTypes.STRING);
    }

    @Override
    public String getLowercaseFunction() {
        return "lcase";
    }

    @Override
    public String getAddColumnString() {
        return "add column";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "values nextval for " + sequenceName;
    }

    @Override
    public String getSelectSequenceNextValString(String sequenceName) throws MappingException {
        return "next value for " + sequenceName;
    }

    @Override
    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName + " restrict";
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsPooledSequences() {
        return true;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from syscat.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        if (this.getQuerySequencesString() == null) {
            return SequenceInformationExtractorNoOpImpl.INSTANCE;
        }
        return SequenceInformationExtractorDB2DatabaseImpl.INSTANCE;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsVariableLimit() {
        return false;
    }

    @Override
    public String getLimitString(String sql, int offset, int limit) {
        if (offset == 0) {
            return sql + " fetch first " + limit + " rows only";
        }
        return "select * from ( select inner2_.*, rownumber() over(order by order of inner2_) as rownumber_ from ( " + sql + " fetch first " + limit + " rows only ) as inner2_ ) as inner1_ where rownumber_ > " + offset + " order by rownumber_";
    }

    @Override
    public int convertToFirstRowValue(int zeroBasedFirstResult) {
        return zeroBasedFirstResult;
    }

    @Override
    public String getForUpdateString() {
        return " for read only with rs use and keep update locks";
    }

    @Override
    public boolean useMaxForLimit() {
        return true;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        String literal;
        switch (sqlType) {
            case 1: 
            case 12: {
                literal = "'x'";
                break;
            }
            case 91: {
                literal = "'2000-1-1'";
                break;
            }
            case 93: {
                literal = "'2000-1-1 00:00:00'";
                break;
            }
            case 92: {
                literal = "'00:00:00'";
                break;
            }
            default: {
                literal = "0";
            }
        }
        return "nullif(" + literal + ", " + literal + ')';
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new GlobalTemporaryTableStrategy(this.generateIdTableSupport());
    }

    protected IdTableSupport generateIdTableSupport() {
        return new StandardIdTableSupport(new GlobalTempTableExporter()){

            @Override
            protected Identifier determineIdTableName(Identifier baseName) {
                return new Identifier("session." + super.determineIdTableName(baseName).getText(), false);
            }

            @Override
            public Exporter<IdTable> getIdTableExporter() {
                return DB2Dialect.this.generateIdTableExporter();
            }
        };
    }

    protected Exporter<IdTable> generateIdTableExporter() {
        return new GlobalTempTableExporter(){

            @Override
            protected String getCreateOptions() {
                return "not logged";
            }
        };
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "values current timestamp";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsParametersInInsertSelect() {
        return true;
    }

    @Override
    public boolean requiresCastingOfParametersInSelectClause() {
        return true;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public String getCrossJoinSeparator() {
        return ", ";
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        if (sqlCode == 16) {
            return SmallIntSqlDescriptor.INSTANCE;
        }
        if (sqlCode == 2) {
            return DecimalSqlDescriptor.INSTANCE;
        }
        return super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            @Override
            public JDBCException convert(SQLException sqlException, String message, String sql) {
                String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
                int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
                if (-952 == errorCode && "57014".equals(sqlState)) {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                return null;
            }
        };
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public String getNotExpression(String expression) {
        return "not (" + expression + ")";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LIMIT_HANDLER;
    }

    @Override
    public String renderOrderByElement(String expression, String collation, String order, NullPrecedence nullPrecedence) {
        if (nullPrecedence == null || nullPrecedence == NullPrecedence.NONE) {
            return super.renderOrderByElement(expression, collation, order, NullPrecedence.NONE);
        }
        if (nullPrecedence == NullPrecedence.FIRST && "desc".equalsIgnoreCase(order) || nullPrecedence == NullPrecedence.LAST && "asc".equalsIgnoreCase(order)) {
            return super.renderOrderByElement(expression, collation, order, NullPrecedence.NONE);
        }
        return String.format(Locale.ENGLISH, "case when %s is null then %s else %s end, %s %s", expression, nullPrecedence == NullPrecedence.FIRST ? "0" : "1", nullPrecedence == NullPrecedence.FIRST ? "1" : "0", expression, order);
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new DB2IdentityColumnSupport();
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }
}

