/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.PessimisticLockException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.hint.IndexQueryHintHandler;
import org.hibernate.dialect.identity.H2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableManagementTransactionality;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.spi.ConcatFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.StandardAnsiSqlSqmAggregationFunctionTemplates;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorH2DatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.spi.StandardSpiBasicTypes;
import org.jboss.logging.Logger;

public class H2Dialect
extends Dialect {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)H2Dialect.class.getName());
    private static final AbstractLimitHandler LIMIT_HANDLER = new AbstractLimitHandler(){

        @Override
        public String processSql(String sql, RowSelection selection) {
            boolean hasOffset = LimitHelper.hasFirstRow(selection);
            return sql + (hasOffset ? " limit ? offset ?" : " limit ?");
        }

        @Override
        public boolean supportsLimit() {
            return true;
        }

        @Override
        public boolean bindLimitParametersInReverseOrder() {
            return true;
        }
    };
    private final String querySequenceString;
    private final SequenceInformationExtractor sequenceInformationExtractor;
    private static final ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        @Override
        protected String doExtractConstraintName(SQLException sqle) throws NumberFormatException {
            String message;
            int idx;
            String constraintName = null;
            if (sqle.getSQLState().startsWith("23") && (idx = (message = sqle.getMessage()).indexOf("violation: ")) > 0) {
                constraintName = message.substring(idx + "violation: ".length());
            }
            return constraintName;
        }
    };

    public H2Dialect() {
        int buildId = Integer.MIN_VALUE;
        try {
            Class h2ConstantsClass = ReflectHelper.classForName("org.h2.engine.Constants");
            int majorVersion = (Integer)h2ConstantsClass.getDeclaredField("VERSION_MAJOR").get(null);
            int minorVersion = (Integer)h2ConstantsClass.getDeclaredField("VERSION_MINOR").get(null);
            buildId = (Integer)h2ConstantsClass.getDeclaredField("BUILD_ID").get(null);
            if (majorVersion <= 1 && minorVersion <= 2 && buildId < 139) {
                LOG.unsupportedMultiTableBulkHqlJpaql(majorVersion, minorVersion, buildId);
            }
        }
        catch (Exception e) {
            LOG.undeterminedH2Version();
        }
        if (buildId >= 32) {
            this.sequenceInformationExtractor = SequenceInformationExtractorH2DatabaseImpl.INSTANCE;
            this.querySequenceString = "select * from information_schema.sequences";
        } else {
            this.sequenceInformationExtractor = SequenceInformationExtractorNoOpImpl.INSTANCE;
            this.querySequenceString = null;
        }
        this.registerColumnType(16, "boolean");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(-2, "binary");
        this.registerColumnType(-7, "boolean");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(2, "decimal($p,$s)");
        this.registerColumnType(8, "double");
        this.registerColumnType(6, "float");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "longvarbinary");
        this.registerColumnType(-1, String.format("varchar(%d)", Integer.MAX_VALUE));
        this.registerColumnType(7, "real");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-3, "binary($l)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.jdbc.lob.non_contextual_creation", "true");
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.register("avg", new StandardAnsiSqlSqmAggregationFunctionTemplates.AvgFunctionTemplate("double"));
        CommonFunctionFactory.acos(registry);
        CommonFunctionFactory.asin(registry);
        CommonFunctionFactory.atan(registry);
        registry.namedTemplateBuilder("atan2").setInvariantType(StandardSpiBasicTypes.DOUBLE).setExactArgumentCount(1).register();
        registry.namedTemplateBuilder("bitand").setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("bitor").setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("bitxor").setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        CommonFunctionFactory.ceiling(registry);
        CommonFunctionFactory.cos(registry);
        registry.namedTemplateBuilder("compress").setArgumentCountBetween(1, 2).setInvariantType(StandardSpiBasicTypes.BINARY).register();
        CommonFunctionFactory.cot(registry);
        registry.namedTemplateBuilder("decrypt").setExactArgumentCount(3).setInvariantType(StandardSpiBasicTypes.BINARY).register();
        CommonFunctionFactory.degrees(registry);
        registry.namedTemplateBuilder("encrypt").setExactArgumentCount(3).setInvariantType(StandardSpiBasicTypes.BINARY).register();
        CommonFunctionFactory.exp(registry);
        registry.namedTemplateBuilder("expand").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.BINARY).register();
        CommonFunctionFactory.floor(registry);
        registry.namedTemplateBuilder("hash").setExactArgumentCount(3).setInvariantType(StandardSpiBasicTypes.BINARY).register();
        CommonFunctionFactory.log(registry);
        CommonFunctionFactory.log10(registry);
        registry.namedTemplateBuilder("pi").setExactArgumentCount(0).setInvariantType(StandardSpiBasicTypes.DOUBLE).register();
        registry.namedTemplateBuilder("power").setExactArgumentCount(2).setInvariantType(StandardSpiBasicTypes.DOUBLE).register();
        CommonFunctionFactory.radians(registry);
        registry.namedTemplateBuilder("rand").setArgumentCountBetween(0, 1).setInvariantType(StandardSpiBasicTypes.DOUBLE).register();
        CommonFunctionFactory.round(registry);
        registry.namedTemplateBuilder("roundmagic").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.DOUBLE).register();
        CommonFunctionFactory.sign(registry);
        CommonFunctionFactory.sin(registry);
        CommonFunctionFactory.tan(registry);
        registry.namedTemplateBuilder("truncate").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.DOUBLE).register();
        registry.namedTemplateBuilder("ascii").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("char").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.CHARACTER).register();
        registry.register("concat", ConcatFunctionTemplate.INSTANCE);
        registry.namedTemplateBuilder("difference").setExactArgumentCount(2).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("hextoraw").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("insert").setExactArgumentCount(4).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("insert").setExactArgumentCount(2).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("insert").setExactArgumentCount(2).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.registerAlternateKey("lcase", "lower");
        registry.namedTemplateBuilder("ltrim").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("octet_length").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        CommonFunctionFactory.position(registry);
        registry.namedTemplateBuilder("rawtohex").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("repeat").setExactArgumentCount(2).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("replace").setArgumentCountBetween(2, 3).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("right").setArgumentCountBetween(2, 3).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("rtrim").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        CommonFunctionFactory.soundex(registry);
        registry.namedTemplateBuilder("space").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("stringencode").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("stringdecode").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("stringtoutf8").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.BINARY).register();
        registry.registerAlternateKey("ucase", "upper");
        registry.namedTemplateBuilder("utf8tostring").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.registerAlternateKey("curdate", "current_date");
        registry.registerAlternateKey("curtime", "current_time");
        registry.registerAlternateKey("curtimestamp", "current_timestamp");
        registry.namedTemplateBuilder("datediff").setExactArgumentCount(3).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("dayname").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("dayofmonth").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("dayofweek").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("dayofyear").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.registerAlternateKey("now", "current_timestamp");
        registry.namedTemplateBuilder("quarter").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("week").setExactArgumentCount(1).setInvariantType(StandardSpiBasicTypes.INTEGER).register();
        registry.namedTemplateBuilder("database").setExactArgumentCount(0).setInvariantType(StandardSpiBasicTypes.STRING).register();
        registry.namedTemplateBuilder("user").setExactArgumentCount(0).setInvariantType(StandardSpiBasicTypes.STRING).register();
    }

    @Override
    public String getAddColumnString() {
        return "add column";
    }

    @Override
    public String getForUpdateString() {
        return " for update";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LIMIT_HANDLER;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        return sql + (hasOffset ? " limit ? offset ?" : " limit ?");
    }

    @Override
    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    @Override
    public boolean bindLimitParametersFirst() {
        return false;
    }

    @Override
    public boolean supportsIfExistsAfterTableName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsPooledSequences() {
        return true;
    }

    @Override
    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence if exists " + sequenceName;
    }

    @Override
    public String getSelectSequenceNextValString(String sequenceName) {
        return "next value for " + sequenceName;
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "call next value for " + sequenceName;
    }

    @Override
    public String getQuerySequencesString() {
        return this.querySequenceString;
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.sequenceInformationExtractor;
    }

    @Override
    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        SQLExceptionConversionDelegate delegate = super.buildSQLExceptionConversionDelegate();
        if (delegate == null) {
            delegate = new SQLExceptionConversionDelegate(){

                @Override
                public JDBCException convert(SQLException sqlException, String message, String sql) {
                    int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
                    if (40001 == errorCode) {
                        return new LockAcquisitionException(message, sqlException, sql);
                    }
                    if (50200 == errorCode) {
                        return new PessimisticLockException(message, sqlException, sql);
                    }
                    if (90006 == errorCode) {
                        String constraintName = H2Dialect.this.getViolatedConstraintNameExtracter().extractConstraintName(sqlException);
                        return new ConstraintViolationException(message, sqlException, sql, constraintName);
                    }
                    return null;
                }
            };
        }
        return delegate;
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new LocalTemporaryTableStrategy(this.generateIdTableSupport());
    }

    private IdTableSupport generateIdTableSupport() {
        return new StandardIdTableSupport(this.generateIdTableExporter(), IdTableManagementTransactionality.NONE);
    }

    private Exporter<IdTable> generateIdTableExporter() {
        return new LocalTempTableExporter(){

            @Override
            protected String getCreateCommand() {
                return "create cached local temporary table if not exists";
            }

            @Override
            protected String getCreateOptions() {
                return "on commit drop transactional";
            }
        };
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "call current_timestamp()";
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean supportsTuplesInSubqueries() {
        return false;
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new H2IdentityColumnSupport();
    }

    @Override
    public String getQueryHintString(String query, String hints) {
        return IndexQueryHintHandler.INSTANCE.addQueryHints(query, hints);
    }
}

