/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class HANAColumnStoreDialect
extends AbstractHANADialect {
    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.registerNamed("score", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("snippets");
        registry.registerNamed("highlighted");
        registry.registerVarArgs("contains", StandardSpiBasicTypes.BOOLEAN, "contains(", ",", ") /*");
        registry.registerPattern("contains_rhs", "*/", StandardSpiBasicTypes.BOOLEAN);
        registry.registerVarArgs("not_contains", StandardSpiBasicTypes.BOOLEAN, "not_contains(", ",", ") /*");
    }

    @Override
    public String getCreateTableString() {
        return "create column table";
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        return new GlobalTemporaryTableStrategy(this.generateIdTableSupport());
    }

    protected IdTableSupport generateIdTableSupport() {
        return new StandardIdTableSupport(new GlobalTempTableExporter()){

            @Override
            public Exporter<IdTable> getIdTableExporter() {
                return HANAColumnStoreDialect.this.generateIdTableExporter();
            }
        };
    }

    protected Exporter<IdTable> generateIdTableExporter() {
        return new GlobalTempTableExporter(){

            @Override
            protected String getCreateOptions() {
                return "not logged";
            }

            @Override
            protected String getTruncateIdTableCommand() {
                return "truncate table";
            }

            @Override
            protected String getCreateCommand() {
                return "create global temporary column table";
            }
        };
    }
}

