/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.identity.HSQLIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadSelectLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteSelectLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.model.domain.spi.Lockable;
import org.hibernate.naming.Identifier;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.spi.StandardAnsiSqlSqmAggregationFunctionTemplates;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorHSQLDBDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.spi.StandardSpiBasicTypes;
import org.jboss.logging.Logger;

public class HSQLDialect
extends Dialect {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)HSQLDialect.class.getName());
    private int hsqldbVersion = 180;
    private final LimitHandler limitHandler;
    private static final ViolatedConstraintNameExtracter EXTRACTER_18 = new TemplatedViolatedConstraintNameExtracter(){

        @Override
        protected String doExtractConstraintName(SQLException sqle) throws NumberFormatException {
            String constraintName = null;
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqle);
            if (errorCode == -8) {
                constraintName = this.extractUsingTemplate("Integrity constraint violation ", " table:", sqle.getMessage());
            } else if (errorCode == -9) {
                constraintName = this.extractUsingTemplate("Violation of unique index: ", " in statement [", sqle.getMessage());
            } else if (errorCode == -104) {
                constraintName = this.extractUsingTemplate("Unique constraint violation: ", " in statement [", sqle.getMessage());
            } else if (errorCode == -177) {
                constraintName = this.extractUsingTemplate("Integrity constraint violation - no parent ", " table:", sqle.getMessage());
            }
            return constraintName;
        }
    };
    private static final ViolatedConstraintNameExtracter EXTRACTER_20 = new TemplatedViolatedConstraintNameExtracter(){

        @Override
        protected String doExtractConstraintName(SQLException sqle) throws NumberFormatException {
            String constraintName = null;
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqle);
            if (errorCode == -8) {
                constraintName = this.extractUsingTemplate("; ", " table: ", sqle.getMessage());
            } else if (errorCode == -9) {
                constraintName = this.extractUsingTemplate("; ", " table: ", sqle.getMessage());
            } else if (errorCode == -104) {
                constraintName = this.extractUsingTemplate("; ", " table: ", sqle.getMessage());
            } else if (errorCode == -177) {
                constraintName = this.extractUsingTemplate("; ", " table: ", sqle.getMessage());
            }
            return constraintName;
        }
    };

    public HSQLDialect() {
        try {
            Class props = ReflectHelper.classForName("org.hsqldb.persist.HsqlDatabaseProperties");
            String versionString = (String)props.getDeclaredField("THIS_VERSION").get(null);
            this.hsqldbVersion = Integer.parseInt(versionString.substring(0, 1)) * 100;
            this.hsqldbVersion += Integer.parseInt(versionString.substring(2, 3)) * 10;
            this.hsqldbVersion += Integer.parseInt(versionString.substring(4, 5));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(-2, "binary($l)");
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "boolean");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(8, "double");
        this.registerColumnType(6, "float");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "longvarbinary");
        this.registerColumnType(-1, "longvarchar");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2011, "clob");
        if (this.hsqldbVersion < 200) {
            this.registerColumnType(2, "numeric");
        } else {
            this.registerColumnType(2, "numeric($p,$s)");
        }
        if (this.hsqldbVersion < 200) {
            this.registerColumnType(2004, "longvarbinary");
            this.registerColumnType(2005, "longvarchar");
        } else {
            this.registerColumnType(2004, "blob($l)");
            this.registerColumnType(2005, "clob($l)");
        }
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.limitHandler = new HSQLLimitHandler();
    }

    @Override
    public void initializeFunctionRegistry(SqmFunctionRegistry registry) {
        super.initializeFunctionRegistry(registry);
        registry.register("avg", new StandardAnsiSqlSqmAggregationFunctionTemplates.AvgFunctionTemplate("double"));
        registry.registerNamed("ascii", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("char", StandardSpiBasicTypes.CHARACTER);
        registry.registerNamed("lower");
        registry.registerNamed("upper");
        registry.registerNamed("lcase");
        registry.registerNamed("ucase");
        registry.registerNamed("soundex", StandardSpiBasicTypes.STRING);
        registry.registerNamed("ltrim");
        registry.registerNamed("rtrim");
        registry.registerNamed("reverse");
        registry.registerNamed("space", StandardSpiBasicTypes.STRING);
        registry.registerPattern("str", "cast(?1 as varchar(256))", StandardSpiBasicTypes.STRING);
        registry.registerNamed("to_char", StandardSpiBasicTypes.STRING);
        registry.registerNamed("rawtohex");
        registry.registerNamed("hextoraw");
        registry.registerNoArgs("user", StandardSpiBasicTypes.STRING);
        registry.registerNoArgs("database", StandardSpiBasicTypes.STRING);
        if (this.hsqldbVersion < 200) {
            registry.registerNoArgs("sysdate", StandardSpiBasicTypes.DATE);
        } else {
            registry.registerNoArgs("sysdate", StandardSpiBasicTypes.TIMESTAMP);
        }
        registry.registerNoArgs("current_date", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("curdate", StandardSpiBasicTypes.DATE);
        registry.registerNoArgs("current_timestamp", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNoArgs("now", StandardSpiBasicTypes.TIMESTAMP);
        registry.registerNoArgs("current_time", StandardSpiBasicTypes.TIME);
        registry.registerNoArgs("curtime", StandardSpiBasicTypes.TIME);
        registry.registerNamed("day", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("dayofweek", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("dayofyear", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("dayofmonth", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("month", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("year", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("week", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("quarter", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("hour", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("minute", StandardSpiBasicTypes.INTEGER);
        registry.registerPattern("second", "cast(second(?1) as int)", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("dayname", StandardSpiBasicTypes.STRING);
        registry.registerNamed("monthname", StandardSpiBasicTypes.STRING);
        registry.registerNamed("abs");
        registry.registerNamed("sign", StandardSpiBasicTypes.INTEGER);
        registry.registerNamed("acos", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("asin", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("atan", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("cos", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("cot", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("exp", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("log", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("log10", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("sin", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("sqrt", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("tan", StandardSpiBasicTypes.DOUBLE);
        registry.registerNoArgs("pi", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("rand", StandardSpiBasicTypes.FLOAT);
        registry.registerNamed("radians", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("degrees", StandardSpiBasicTypes.DOUBLE);
        registry.registerNamed("round");
        registry.registerNamed("roundmagic");
        registry.registerNamed("truncate");
        registry.registerNamed("trunc");
        registry.registerNamed("ceiling");
        registry.registerNamed("floor");
        if (this.hsqldbVersion > 219) {
            registry.registerNoArgs("rownum", StandardSpiBasicTypes.INTEGER);
        }
        registry.registerVarArgs("concat", StandardSpiBasicTypes.STRING, "(", "||", ")");
    }

    @Override
    public String getAddColumnString() {
        return "add column";
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public String getForUpdateString() {
        if (this.hsqldbVersion >= 200) {
            return " for update";
        }
        return "";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        if (this.hsqldbVersion < 200) {
            return new StringBuilder(sql.length() + 10).append(sql).insert(sql.toLowerCase(Locale.ROOT).indexOf("select") + 6, hasOffset ? " limit ? ?" : " top ?").toString();
        }
        return sql + (hasOffset ? " offset ? limit ?" : " limit ?");
    }

    @Override
    public boolean bindLimitParametersFirst() {
        return this.hsqldbVersion < 200;
    }

    @Override
    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public boolean supportsColumnCheck() {
        return this.hsqldbVersion >= 200;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsPooledSequences() {
        return true;
    }

    @Override
    protected String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName + " start with 1";
    }

    @Override
    protected String getCreateSequenceString(String sequenceName, int initialValue, int incrementSize) throws MappingException {
        if (this.supportsPooledSequences()) {
            return "create sequence " + sequenceName + " start with " + initialValue + " increment by " + incrementSize;
        }
        throw new MappingException(this.getClass().getName() + " does not support pooled sequences");
    }

    @Override
    protected String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName + " if exists";
    }

    @Override
    public String getSelectSequenceNextValString(String sequenceName) {
        return "next value for " + sequenceName;
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "call next value for " + sequenceName;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from information_schema.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorHSQLDBDatabaseImpl.INSTANCE;
    }

    @Override
    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return this.hsqldbVersion < 200 ? EXTRACTER_18 : EXTRACTER_20;
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        String literal;
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                literal = "cast(null as varchar(100))";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                literal = "cast(null as varbinary(100))";
                break;
            }
            case 2005: {
                literal = "cast(null as clob)";
                break;
            }
            case 2004: {
                literal = "cast(null as blob)";
                break;
            }
            case 91: {
                literal = "cast(null as date)";
                break;
            }
            case 93: {
                literal = "cast(null as timestamp)";
                break;
            }
            case 16: {
                literal = "cast(null as boolean)";
                break;
            }
            case -7: {
                literal = "cast(null as bit)";
                break;
            }
            case 92: {
                literal = "cast(null as time)";
                break;
            }
            default: {
                literal = "cast(null as int)";
            }
        }
        return literal;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public SqmMutationStrategy getDefaultIdTableStrategy() {
        if (this.hsqldbVersion < 200) {
            return new GlobalTemporaryTableStrategy();
        }
        return new LocalTemporaryTableStrategy(new StandardIdTableSupport(this.generateLocalTempTableExporter()){

            @Override
            protected Identifier determineIdTableName(Identifier baseName) {
                return new Identifier("MODULE.HT_" + baseName.getText(), false);
            }
        });
    }

    private Exporter<IdTable> generateLocalTempTableExporter() {
        return new LocalTempTableExporter(){

            @Override
            protected String getCreateCommand() {
                return "declare local temporary table";
            }
        };
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "call current_timestamp";
    }

    @Override
    public String getCurrentTimestampSQLFunctionName() {
        return "current_timestamp";
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_WRITE) {
            return new PessimisticWriteSelectLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_READ) {
            return new PessimisticReadSelectLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC) {
            return new OptimisticLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT) {
            return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (this.hsqldbVersion < 200) {
            return new ReadUncommittedLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    @Override
    public boolean supportsCommentOn() {
        return this.hsqldbVersion >= 200;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean requiresCastingOfParametersInSelectClause() {
        return true;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return this.hsqldbVersion >= 200;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return this.hsqldbVersion >= 200;
    }

    @Override
    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return String.valueOf(bool);
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return this.hsqldbVersion >= 229;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new HSQLIdentityColumnSupport(this.hsqldbVersion);
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    @Override
    public boolean supportsNamedParameters(DatabaseMetaData databaseMetaData) throws SQLException {
        return false;
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " CASCADE ";
    }

    private static class ReadUncommittedLockingStrategy
    extends SelectLockingStrategy {
        public ReadUncommittedLockingStrategy(Lockable lockable, LockMode lockMode) {
            super(lockable, lockMode);
        }

        @Override
        public void lock(Serializable id, Object version, Object object, int timeout, SharedSessionContractImplementor session) throws StaleObjectStateException, JDBCException {
            if (this.getLockMode().greaterThan(LockMode.READ)) {
                LOG.hsqldbSupportsOnlyReadCommittedIsolation();
            }
            super.lock(id, version, object, timeout, session);
        }
    }

    private final class HSQLLimitHandler
    extends AbstractLimitHandler {
        private HSQLLimitHandler() {
        }

        @Override
        public String processSql(String sql, RowSelection selection) {
            boolean hasOffset = LimitHelper.hasFirstRow(selection);
            if (HSQLDialect.this.hsqldbVersion < 200) {
                return new StringBuilder(sql.length() + 10).append(sql).insert(sql.toLowerCase(Locale.ROOT).indexOf("select") + 6, hasOffset ? " limit ? ?" : " top ?").toString();
            }
            return sql + (hasOffset ? " offset ? limit ?" : " limit ?");
        }

        @Override
        public boolean supportsLimit() {
            return true;
        }

        @Override
        public boolean bindLimitParametersFirst() {
            return HSQLDialect.this.hsqldbVersion < 200;
        }
    }
}

